/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.conf.AppConfig;
import act.data.JodaDateTimeCodecBase;
import act.data.JodaReadablePatialCodecBase;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@Singleton
public class JodaLocalDateTimeCodec
extends JodaReadablePatialCodecBase<LocalDateTime> {
    private boolean isIso;

    public JodaLocalDateTimeCodec(DateTimeFormatter formatter, boolean isIso) {
        super(formatter);
        this.isIso = isIso;
    }

    public JodaLocalDateTimeCodec(String pattern) {
        super(pattern);
        this.isIso = JodaLocalDateTimeCodec.isIsoStandard(pattern);
    }

    @Inject
    public JodaLocalDateTimeCodec(AppConfig config) {
        this(config.dateTimePattern());
    }

    @Override
    protected LocalDateTime parse(DateTimeFormatter formatter, String value) {
        String amended = this.isIso && !value.endsWith("Z") ? value + "Z" : value;
        return formatter.parseLocalDateTime(amended);
    }

    @Override
    protected DateTimeFormatter isoFormatter() {
        return ISODateTimeFormat.dateTimeNoMillis();
    }

    @Override
    protected LocalDateTime now() {
        return LocalDateTime.now();
    }

    @Override
    protected JodaDateTimeCodecBase<LocalDateTime> create(String pattern) {
        return new JodaLocalDateTimeCodec(pattern);
    }

    @Override
    protected String dateTimePattern(AppConfig config, Locale locale) {
        return config.localizedDateTimePattern(locale);
    }
}

