/*
 * Decompiled with CFR 0.152.
 */
package act.db.di;

import act.Act;
import act.app.ActionContext;
import act.app.App;
import act.db.Dao;
import act.inject.param.JsonDTO;
import act.inject.param.ParamValueLoaderService;
import act.util.ActContext;
import act.view.ActBadRequest;
import act.view.ActNotFound;
import java.util.ArrayList;
import javax.validation.constraints.NotNull;
import org.osgl.inject.ValueLoader;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.Keyword;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

public class FindBy
extends ValueLoader.Base {
    private String requestParamName;
    private String queryFieldName;
    private Dao dao;
    private StringValueResolver resolver;
    private boolean findOne;
    private boolean byId;
    private Class<?> rawType;
    private boolean notNull;

    protected void initialized() {
        App app = App.instance();
        this.rawType = this.spec.rawType();
        this.notNull = this.spec.hasAnnotation(NotNull.class);
        this.findOne = !Iterable.class.isAssignableFrom(this.rawType);
        this.dao = app.dbServiceManager().dao(this.findOne ? this.rawType : (Class)this.spec.typeParams().get(0));
        this.queryFieldName = S.string(this.options.get("field"));
        this.byId = this.findOne && S.blank((String)this.queryFieldName) && (Boolean)this.options.get("byId") != false;
        this.resolver = app.resolverManager().resolver(this.byId ? this.dao.idType() : (Class)this.options.get("fieldType"));
        if (null == this.resolver) {
            throw new IllegalArgumentException("Cannot find String value resolver for type: " + this.dao.idType());
        }
        this.requestParamName = S.string((Object)this.value());
        if (S.blank((String)this.requestParamName)) {
            this.requestParamName = ParamValueLoaderService.bindName(this.spec);
        }
        if (!this.byId && S.blank((String)this.queryFieldName)) {
            this.queryFieldName = this.requestParamName;
        }
    }

    public Object get() {
        Object by;
        ActContext.Base<?> ctx = ActContext.Base.currentContext();
        E.illegalStateIf((null == ctx ? 1 : 0) != 0);
        String value = FindBy.resolve(this.requestParamName, ctx);
        if (S.empty((String)value) && this.findOne) {
            return this.ensureNotNull(null, value, ctx);
        }
        Object object = by = null == value ? null : this.resolver.resolve(value);
        if (this.findOne) {
            this.ensureNotNull(by, value, ctx);
        }
        ArrayList col = null;
        if (!this.findOne) {
            if (this.rawType.equals(Iterable.class)) {
                if (S.empty((String)value)) {
                    return this.dao.findAll();
                }
                col = new ArrayList();
            } else {
                col = (ArrayList)App.instance().getInstance(this.rawType);
            }
        }
        if (null == by) {
            return null;
        }
        if (this.byId) {
            Object bean = this.dao.findById(by);
            return this.ensureNotNull(bean, value, ctx);
        }
        if (this.findOne) {
            Object found = this.dao.findOneBy(Keyword.of((CharSequence)this.queryFieldName).javaVariable(), by);
            return this.ensureNotNull(found, value, ctx);
        }
        if (S.empty((String)value)) {
            col.addAll(this.dao.findAllAsList());
        } else {
            col.addAll(C.list(this.dao.findBy(Keyword.of((CharSequence)this.queryFieldName).javaVariable(), by)));
        }
        return col;
    }

    private Object ensureNotNull(Object obj, String value, ActContext<?> ctx) {
        if (this.notNull) {
            if (null == value) {
                String errMsg = Act.appConfig().i18nEnabled() ? ctx._act_i18n("e400.db_bind.missing_request_param", this.requestParamName) : "missing required parameter: " + this.requestParamName;
                throw ActBadRequest.create(errMsg, new Object[0]);
            }
            if (null == obj) {
                String errMsg = Act.appConfig().i18nEnabled() ? ctx._act_i18n("e404.db_bind.not_found", this.queryFieldName, value) : "db record not found by " + this.queryFieldName + " using value: " + value;
                throw ActNotFound.create(errMsg, new Object[0]);
            }
        }
        return obj;
    }

    private static String resolve(String bindName, ActContext ctx) {
        ActionContext actionContext;
        JsonDTO dto;
        String value = ctx.paramVal(bindName);
        if (S.notEmpty((String)value)) {
            return value;
        }
        if (ctx instanceof ActionContext && null != (dto = (JsonDTO)(actionContext = (ActionContext)ctx).attribute("__json_dto__"))) {
            value = S.string((Object)dto.get(bindName));
        }
        if (S.notEmpty((String)value)) {
            return value;
        }
        Keyword keyword = Keyword.of((CharSequence)bindName);
        if (keyword.tokens().size() > 1) {
            return FindBy.resolve(keyword, ctx);
        }
        keyword = Keyword.of((CharSequence)(bindName + " id"));
        return FindBy.resolve(keyword, ctx);
    }

    private static String resolve(Keyword keyword, ActContext ctx) {
        String value = ctx.paramVal(keyword.underscore());
        if (S.notBlank((String)value)) {
            return value;
        }
        value = ctx.paramVal(keyword.javaVariable());
        if (S.notBlank((String)value)) {
            return value;
        }
        return null;
    }
}

