/*
 * Decompiled with CFR 0.152.
 */
package act.db.meta;

import act.app.App;
import act.app.event.SysEventId;
import act.asm.Type;
import act.db.DB;
import act.db.meta.EntityClassMetaInfo;
import act.db.meta.EntityMetaInfoRepo;
import act.job.JobManager;
import act.util.ClassInfoRepository;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.MappedSuperclass;
import org.osgl.inject.NamedProvider;

@Singleton
public class MasterEntityMetaInfoRepo
extends EntityMetaInfoRepo {
    private Map<String, EntityMetaInfoRepo> regions = new HashMap<String, EntityMetaInfoRepo>();
    private Set<String> entityAnnotations = new HashSet<String>();
    private Set<String> mappedSuperClassAnnotations = new HashSet<String>();
    private Set<String> entityListenerAnnotations = new HashSet<String>();
    private String defaultAlias;

    @Inject
    public MasterEntityMetaInfoRepo(final App app) {
        super(app);
        this.registerEntityAnnotation(Entity.class);
        this.registerMappedSuperClassAnnotation(MappedSuperclass.class);
        this.registerEntityListenerAnnotation(EntityListeners.class);
        final MasterEntityMetaInfoRepo me = this;
        JobManager jobManager = app.jobManager();
        jobManager.on(SysEventId.CLASS_LOADED, new Runnable(){

            @Override
            public void run() {
                ClassInfoRepository classRepo = app.classLoader().classInfoRepository();
                for (Map.Entry entry : MasterEntityMetaInfoRepo.this.lookup.entrySet()) {
                    Class<?> entityClass = app.classForName((String)entry.getKey());
                    EntityClassMetaInfo info = (EntityClassMetaInfo)entry.getValue();
                    info.mergeFromMappedSuperClasses(classRepo, me);
                    MasterEntityMetaInfoRepo.this.register(entityClass, info);
                    DB db = entityClass.getAnnotation(DB.class);
                    String dbId = (null == db ? "default" : db.value()).toUpperCase();
                    EntityMetaInfoRepo repo = (EntityMetaInfoRepo)MasterEntityMetaInfoRepo.this.regions.get(dbId);
                    if (null == repo) {
                        repo = new EntityMetaInfoRepo(app);
                        MasterEntityMetaInfoRepo.this.regions.put(dbId, repo);
                    }
                    repo.register(entityClass, info);
                }
            }
        });
        jobManager.on(SysEventId.DEPENDENCY_INJECTOR_PROVISIONED, new Runnable(){

            @Override
            public void run() {
                app.injector().registerNamedProvider(EntityMetaInfoRepo.class, (NamedProvider<EntityMetaInfoRepo>)((NamedProvider)app.getInstance(EntityMetaInfoRepo.Provider.class)));
            }
        });
    }

    public void registerEntityAnnotation(Class<? extends Annotation> annoType) {
        this.entityAnnotations.add(Type.getType(annoType).getDescriptor());
    }

    public void registerMappedSuperClassAnnotation(Class<? extends Annotation> annoType) {
        this.mappedSuperClassAnnotations.add(Type.getType(annoType).getDescriptor());
    }

    public void registerEntityListenerAnnotation(Class<? extends Annotation> annoType) {
        this.entityListenerAnnotations.add(Type.getType(annoType).getDescriptor());
    }

    public void setDefaultAlias(String defaultAlias) {
        this.defaultAlias = defaultAlias;
    }

    public boolean isEntity(String descriptor) {
        return this.entityAnnotations.contains(descriptor);
    }

    public boolean isMappedSuperClass(String descriptor) {
        return this.mappedSuperClassAnnotations.contains(descriptor);
    }

    public boolean isEntityListener(String descriptor) {
        return this.entityListenerAnnotations.contains(descriptor);
    }

    public EntityMetaInfoRepo forDefaultDb() {
        return this.forDb("default");
    }

    public EntityMetaInfoRepo forDb(String dbId) {
        String DEF = "default".toUpperCase();
        EntityMetaInfoRepo repo = this.regions.get(dbId = null == dbId ? DEF : dbId.toUpperCase());
        if (null == repo && null != this.defaultAlias) {
            String DEF_ALIAS = this.defaultAlias.toUpperCase();
            if (DEF.equals(dbId)) {
                dbId = DEF_ALIAS;
            } else if (DEF_ALIAS.equals(dbId)) {
                dbId = DEF;
            }
            repo = this.regions.get(dbId);
        }
        return repo;
    }
}

