/*
 * Decompiled with CFR 0.152.
 */
package act.db.util;

import act.Act;
import act.app.App;
import act.app.DbServiceManager;
import act.cli.Command;
import act.cli.Required;
import act.conf.AppConfig;
import act.db.util._SequenceNumberGenerator;
import java.util.List;
import javax.inject.Inject;
import org.osgl.$;

public class SequenceNumberGenerator {
    private static volatile _SequenceNumberGenerator impl;

    public static void registerImpl(_SequenceNumberGenerator impl) {
        SequenceNumberGenerator.impl = (_SequenceNumberGenerator)$.requireNotNull((Object)impl);
    }

    public static long next(String name) {
        return impl.next(name);
    }

    public static long get(String name) {
        return impl.get(name);
    }

    public static class SequenceAdmin {
        @Command(name="act.seq.next", help="display the next number in the sequence specified")
        public long generateNext(@Required(value="specify sequence name") String sequence) {
            return SequenceNumberGenerator.next(sequence);
        }

        @Command(name="act.seq.get", help="display the current number in the sequence specified")
        public long getCurrent(@Required(value="Specify sequence name") String sequence) {
            return SequenceNumberGenerator.get(sequence);
        }
    }

    public static class Provider
    implements javax.inject.Provider<_SequenceNumberGenerator> {
        @Inject
        private List<_SequenceNumberGenerator> generators;

        public _SequenceNumberGenerator get() {
            if (this.generators.size() > 1) {
                App app = Act.app();
                AppConfig<?> config = app.config();
                DbServiceManager dbServiceManager = app.dbServiceManager();
                for (_SequenceNumberGenerator gen : this.generators) {
                    if (_SequenceNumberGenerator.InMemorySequenceNumberGenerator.class.isInstance(gen)) continue;
                    try {
                        gen.configure(config, dbServiceManager);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    return gen;
                }
            }
            return this.generators.get(0);
        }
    }
}

