/*
 * Decompiled with CFR 0.152.
 */
package act.handler.builtin;

import act.ActResponse;
import act.app.ActionContext;
import act.handler.ExpressHandler;
import act.handler.builtin.controller.FastRequestHandler;
import act.util.ByteBuffers;
import java.nio.ByteBuffer;
import org.osgl.http.H;
import org.osgl.util.S;

public class Echo
extends FastRequestHandler
implements ExpressHandler {
    private ByteBuffer buffer;
    private String toString;
    private String contentType;

    public Echo(String msg) {
        this(msg, H.Format.TXT.contentType());
    }

    public Echo(String msg, String contentType) {
        this.buffer = ByteBuffers.wrap(msg);
        this.contentType = contentType;
        this.toString = "echo: " + msg;
    }

    @Override
    public void handle(ActionContext context) {
        ActResponse<?> resp = context.resp();
        if (S.notBlank((String)this.contentType)) {
            resp.contentType(this.contentType);
        }
        resp.writeContent(this.buffer.duplicate());
    }

    public String readContent() {
        ByteBuffer copy = this.buffer.duplicate();
        byte[] bytes = new byte[copy.remaining()];
        copy.get(bytes);
        return new String(bytes);
    }

    @Override
    public String toString() {
        return this.toString;
    }
}

