/*
 * Decompiled with CFR 0.152.
 */
package act.handler.builtin;

import act.Act;
import act.ActResponse;
import act.app.ActionContext;
import act.handler.RequestHandler;
import act.handler.builtin.AlwaysForbidden;
import act.handler.builtin.AlwaysNotFound;
import act.handler.builtin.AlwaysNotModified;
import act.handler.builtin.FileGetter;
import act.handler.builtin.FixedResourceGetter;
import act.handler.builtin.controller.FastRequestHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.http.H;
import org.osgl.mvc.result.NotFound;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;

public class ResourceGetter
extends FastRequestHandler {
    private static final char SEP = '/';
    private FastRequestHandler delegate;
    private String base;
    private URL baseUrl;
    private int preloadSizeLimit;
    private boolean isFolder;
    private ByteBuffer buffer;
    private H.Format preloadedContentType;
    private boolean preloadFailure;
    private boolean preloaded;
    private String etag;
    private volatile RequestHandler indexHandler;
    private ConcurrentMap<String, RequestHandler> subFolderIndexHandlers = new ConcurrentHashMap<String, RequestHandler>();
    private Set<URL> folders = new HashSet<URL>();
    private Map<String, String> etags = new HashMap<String, String>();
    private Map<String, ByteBuffer> cachedBuffers = new HashMap<String, ByteBuffer>();
    private Map<String, H.Format> cachedContentType = new HashMap<String, H.Format>();
    private Map<String, Boolean> cachedFailures = new HashMap<String, Boolean>();

    public ResourceGetter(String base) {
        String path;
        E.illegalArgumentIf((boolean)S.blank((String)base), (String)"empty resource string encountered");
        this.base = path = S.ensureStartsWith((String)base, (char)'/');
        this.baseUrl = FileGetter.class.getResource(path);
        this.delegate = this.verifyBase(this.baseUrl, base);
        if (null == this.delegate) {
            this.isFolder = this.isFolder(this.baseUrl, path);
            if (!this.isFolder && "file".equals(this.baseUrl.getProtocol())) {
                Act.jobManager().beforeAppStart(new Runnable(){

                    @Override
                    public void run() {
                        ResourceGetter.this.preloadCache();
                    }
                });
            }
            this.preloadSizeLimit = Act.appConfig().resourcePreloadSizeLimit();
        }
    }

    @Override
    protected void releaseResources() {
    }

    @Override
    public boolean express(ActionContext context) {
        if (this.preloaded || null != this.delegate) {
            return true;
        }
        String path = context.paramVal("__path");
        return Act.isProd() && (this.cachedBuffers.containsKey(path) || this.cachedFailures.containsKey(path) || null != context.req().etag() && context.req().etagMatches(this.etags.get(path)));
    }

    @Override
    public void handle(ActionContext context) {
        if (null != this.delegate) {
            this.delegate.handle(context);
            return;
        }
        context.handler(this);
        String path = this.path(context);
        this.handle(path, context);
    }

    protected String path(ActionContext context) {
        return context.paramVal("__path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handle(String path, ActionContext context) {
        block27: {
            ByteBuffer buffer;
            H.Request req = context.req();
            if (Act.isProd()) {
                ActResponse<?> resp = context.prepareRespForWrite();
                if (this.preloaded) {
                    if (this.preloadFailure) {
                        AlwaysNotFound.INSTANCE.handle(context);
                    } else {
                        resp.contentType(this.preloadedContentType);
                        if (req.etagMatches(this.etag)) {
                            AlwaysNotModified.INSTANCE.handle(context);
                        } else {
                            H.Format contentType = this.cachedContentType.get(path);
                            if (null == contentType) {
                                contentType = req.contentType();
                            }
                            resp.contentType(contentType).header("Cache-Control", "public, max-age=7200").etag(this.etag).writeContent(this.buffer.duplicate());
                        }
                    }
                    return;
                }
                if (this.cachedFailures.containsKey(path)) {
                    AlwaysNotFound.INSTANCE.handle(context);
                    return;
                }
                if (null != req.etag() && req.etagMatches(this.etags.get(path))) {
                    H.Format contentType = this.cachedContentType.get(path);
                    if (null == contentType) {
                        contentType = req.contentType();
                    }
                    resp.contentType(contentType);
                    AlwaysNotModified.INSTANCE.handle(context);
                    return;
                }
            }
            if (null != (buffer = this.cachedBuffers.get(path))) {
                context.resp().contentType(this.cachedContentType.get(path)).header("Cache-Control", "public, max-age=7200");
                context.applyContentType();
                ((ActResponse)context.prepareRespForWrite().etag(this.etags.get(path))).writeContent(buffer.duplicate());
                return;
            }
            try {
                String loadPath;
                URL target;
                if (S.blank((String)path)) {
                    target = this.baseUrl;
                    loadPath = this.base;
                    if (this.isFolder) {
                        if (null == this.indexHandler) {
                            ResourceGetter resourceGetter = this;
                            synchronized (resourceGetter) {
                                if (null == this.indexHandler) {
                                    loadPath = S.pathConcat((String)this.base, (char)'/', (String)"index.html");
                                    target = FileGetter.class.getResource(loadPath);
                                }
                                this.indexHandler = null == target ? AlwaysForbidden.INSTANCE : new FixedResourceGetter(loadPath);
                            }
                        }
                        this.indexHandler.handle(context);
                        return;
                    }
                } else {
                    loadPath = S.pathConcat((String)this.base, (char)'/', (String)path);
                    target = FileGetter.class.getResource(loadPath);
                    if (null == target) {
                        throw NotFound.get();
                    }
                }
                if (this.preventFolderAccess(target, loadPath, context)) {
                    return;
                }
                H.Format contentType = FileGetter.contentType(target.getPath());
                ActResponse<?> resp = context.prepareRespForWrite();
                resp.contentType(contentType);
                if (Act.isProd()) {
                    resp.header("Cache-Control", "public, max-age=7200");
                }
                context.applyCorsSpec().applyContentSecurityPolicy().applyContentType();
                try {
                    int n = IO.copy((InputStream)target.openStream(), (OutputStream)resp.outputStream());
                    if (!Act.isProd()) break block27;
                    this.etags.put(path, String.valueOf(n));
                    if (n >= context.config().resourcePreloadSizeLimit()) break block27;
                    Lang.Var etagBag = $.var();
                    buffer = this.doPreload(target, (Lang.Var<String>)etagBag);
                    if (null == buffer) {
                        this.cachedFailures.put(path, true);
                        break block27;
                    }
                    this.cachedBuffers.put(path, buffer);
                    this.cachedContentType.put(path, contentType);
                }
                catch (NullPointerException e) {
                    this.folders.add(target);
                    AlwaysForbidden.INSTANCE.handle(context);
                }
            }
            catch (IOException e) {
                this.logger.warn((Throwable)e, "Error servicing static resource request");
                throw NotFound.get();
            }
        }
    }

    private boolean preventFolderAccess(URL target, String path, ActionContext context) {
        RequestHandler folderHandler = (RequestHandler)this.subFolderIndexHandlers.get(path);
        if (null != folderHandler) {
            folderHandler.handle(context);
            return true;
        }
        if (this.isFolder(target, path)) {
            String indexPath = S.pathConcat((String)path, (char)'/', (String)"index.html");
            URL indexTarget = ResourceGetter.class.getResource(indexPath);
            if (null != indexTarget) {
                folderHandler = this.exists(indexTarget, indexPath) ? new FixedResourceGetter(indexPath) : AlwaysForbidden.INSTANCE;
                this.subFolderIndexHandlers.putIfAbsent(path, folderHandler);
                folderHandler.handle(context);
            }
            return true;
        }
        return false;
    }

    private boolean isFolder(URL target, String path) {
        if ("file".equals(target.getProtocol())) {
            File file = new File(target.getFile());
            return file.isDirectory();
        }
        if ("jar".equals(target.getProtocol())) {
            if (path.endsWith("/")) {
                return true;
            }
            URL url = FileGetter.class.getResource(S.ensureEndsWith((String)path, (String)"/"));
            return null != url;
        }
        return false;
    }

    private boolean exists(URL target, String path) {
        if ("file".equals(target.getProtocol())) {
            File file = new File(target.getFile());
            return file.exists();
        }
        if ("jar".equals(target.getProtocol())) {
            URL url = FileGetter.class.getResource(path);
            return null != url;
        }
        return false;
    }

    private void preloadCache() {
        if (Act.isDev()) {
            return;
        }
        H.Format contentType = FileGetter.contentType(this.baseUrl.getPath());
        if (H.Format.HTML == contentType || H.Format.CSS == contentType || H.Format.JAVASCRIPT == contentType || H.Format.TXT == contentType || H.Format.CSV == contentType || H.Format.JSON == contentType || H.Format.XML == contentType || this.resourceSizeIsOkay()) {
            Lang.Var etagBag = $.var();
            this.buffer = this.doPreload(this.baseUrl, (Lang.Var<String>)etagBag);
            if (null == this.buffer) {
                this.preloadFailure = true;
            } else {
                this.etag = (String)etagBag.get();
            }
            this.preloadedContentType = contentType;
            this.preloaded = true;
        }
    }

    private ByteBuffer doPreload(URL target, Lang.Var<String> etagBag) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IO.copy((InputStream)target.openStream(), (OutputStream)baos);
            byte[] ba = baos.toByteArray();
            this.buffer = ByteBuffer.wrap(ba);
            etagBag.set((Object)String.valueOf(Arrays.hashCode(ba)));
            return this.buffer;
        }
        catch (IOException e) {
            Act.LOGGER.warn((Throwable)e, "Error loading resource: %s", new Object[]{this.baseUrl.getPath()});
            return null;
        }
    }

    private boolean resourceSizeIsOkay() {
        if (this.preloadSizeLimit <= 0) {
            return false;
        }
        if ("file".equals(this.baseUrl.getProtocol())) {
            File file = new File(this.baseUrl.getFile());
            return file.length() < (long)this.preloadSizeLimit;
        }
        return false;
    }

    @Override
    public boolean supportPartialPath() {
        return this.isFolder;
    }

    @Override
    public String toString() {
        S.Buffer buf = S.buffer().append("resource: ").append(this.base);
        if (null == this.baseUrl) {
            buf.append("(not found)");
        }
        return buf.toString();
    }

    private FastRequestHandler verifyBase(URL baseUrl, String baseSupplied) {
        if (null == baseUrl) {
            this.logger.warn("URL base not exists: " + baseSupplied);
            return AlwaysNotFound.INSTANCE;
        }
        return null;
    }
}

