/*
 * Decompiled with CFR 0.152.
 */
package act.inject.genie;

import act.app.ActionContext;
import act.app.App;
import act.cli.CliContext;
import act.cli.CliSession;
import act.inject.SessionVariable;
import act.inject.param.ScopeCacheSupport;
import org.osgl.http.H;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.ScopeCache;
import org.osgl.util.S;

public class SessionScope
extends ScopeCacheSupport.Base
implements ScopeCache.SessionScope,
ScopeCacheSupport {
    public static final SessionScope INSTANCE = new SessionScope();
    private final int TTL = App.instance().config().sessionTtl();

    public <T> T get(BeanSpec target) {
        return this.get(target.toString());
    }

    @Override
    public <T> T get(String key) {
        ActionContext actionContext = ActionContext.current();
        if (null != actionContext) {
            H.Session session = actionContext.session();
            Object t = session.cached(key);
            if (null != t) {
                session.cache(key, t, this.TTL);
            }
            return (T)t;
        }
        CliContext cliContext = CliContext.current();
        if (null != cliContext) {
            CliSession cliSession = cliContext.session();
            return cliSession.attribute(key);
        }
        return null;
    }

    public <T> void put(BeanSpec target, T t) {
        this.put(target.toString(), t);
    }

    @Override
    public <T> void put(String key, T t) {
        CliContext cliContext;
        ActionContext actionContext = ActionContext.current();
        if (null != actionContext) {
            actionContext.session().cache(key, t, this.TTL);
        }
        if (null != (cliContext = CliContext.current())) {
            CliSession cliSession = cliContext.session();
            cliSession.attribute(key, t);
        }
    }

    @Override
    public String key(BeanSpec spec) {
        String key;
        SessionVariable sessionVariable = (SessionVariable)spec.getAnnotation(SessionVariable.class);
        if (null != sessionVariable && S.notBlank((String)(key = sessionVariable.value()))) {
            return key;
        }
        return super.key(spec);
    }
}

