/*
 * Decompiled with CFR 0.152.
 */
package act.inject.param;

import act.inject.param.ParamKey;
import act.inject.param.ParamTreeNode;
import act.util.ActContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.S;

class ParamTree {
    private static final Logger LOGGER = LogManager.get(ParamTree.class);
    private Map<ParamKey, ParamTreeNode> allNodes = new HashMap<ParamKey, ParamTreeNode>();

    ParamTree() {
    }

    void build(ActContext context) {
        Set paramKeys = context.paramKeys();
        for (String key : paramKeys) {
            String[] vals = context.paramVals(key);
            this.buildNode(key, vals);
        }
    }

    private void buildNode(String rawKey, String[] vals) {
        ParamTreeNode node;
        ParamKey key = ParamKey.of(ParamTree.parseRawParamKey(rawKey));
        int len = vals.length;
        if (len == 0) {
            return;
        }
        if (len > 1) {
            node = ParamTreeNode.list(key);
            for (int i = 0; i < vals.length; ++i) {
                ParamTreeNode leafNode = ParamTreeNode.leaf(key, vals[i]);
                node.addListItem(leafNode);
            }
        } else {
            node = ParamTreeNode.leaf(key, vals[0]);
        }
        this.allNodes.put(key, node);
        len = key.size();
        if (len == 1) {
            return;
        }
        this.ensureParent(key, node);
    }

    ParamTreeNode node(ParamKey key) {
        return this.allNodes.get(key);
    }

    private void ensureParent(ParamKey childKey, ParamTreeNode child) {
        ParamKey parentKey = childKey.parent();
        if (null == parentKey) {
            return;
        }
        ParamTreeNode parent = this.allNodes.get(parentKey);
        if (null == parent) {
            parent = ParamTreeNode.map(parentKey);
            this.allNodes.put(parentKey, parent);
        }
        parent.addChild(childKey.name(), child);
        int len = parentKey.size();
        if (len > 1) {
            this.ensureParent(parentKey, parent);
        }
    }

    private static String[] parseRawParamKey(String rawKey) {
        ArrayList<String> list = new ArrayList<String>();
        int len = rawKey.length();
        boolean inSquare = false;
        S.Buffer token = S.buffer();
        block5: for (int i = 0; i < len; ++i) {
            char c = rawKey.charAt(i);
            switch (c) {
                case '.': {
                    if (inSquare) {
                        token.append(c);
                        continue block5;
                    }
                    ParamTree.addTokenToList(list, token);
                    continue block5;
                }
                case ']': {
                    inSquare = false;
                    ParamTree.addTokenToList(list, token);
                    continue block5;
                }
                case '[': {
                    inSquare = true;
                    ParamTree.addTokenToList(list, token);
                    continue block5;
                }
                default: {
                    token.append(c);
                }
            }
        }
        ParamTree.addTokenToList(list, token);
        return list.toArray(new String[list.size()]);
    }

    private static void addTokenToList(List<String> list, S.Buffer token) {
        String s = token.toString();
        if (S.notEmpty((String)s)) {
            list.add(s);
        } else {
            LOGGER.warn("empty index encountered");
        }
        token.delete(0, s.length() + 1);
    }
}

