/*
 * Decompiled with CFR 0.152.
 */
package act.inject.param;

import act.Destroyable;
import act.app.App;
import act.app.AppServiceBase;
import act.inject.DependencyInjector;
import act.inject.genie.GenieInjector;
import act.inject.param.ParamValueLoader;
import act.util.ActContext;
import act.util.DestroyableBase;
import act.util.SingletonBase;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Singleton;
import org.osgl.inject.BeanSpec;

public class ProvidedValueLoader
extends DestroyableBase
implements ParamValueLoader {
    private DependencyInjector<?> injector;
    private BeanSpec beanSpec;
    private Object singleton;
    private static ConcurrentMap<BeanSpec, ProvidedValueLoader> lookup;

    private ProvidedValueLoader(BeanSpec beanSpec, DependencyInjector<?> injector) {
        Class type = beanSpec.rawType();
        if (AppServiceBase.class.isAssignableFrom(type) || SingletonBase.class.isAssignableFrom(type) || type.isAnnotationPresent(Singleton.class) || type.isAnnotationPresent(ApplicationScoped.class)) {
            this.singleton = injector.get(type);
        }
        this.beanSpec = beanSpec;
        this.injector = injector;
    }

    @Override
    public Object load(Object bean, ActContext<?> context, boolean noDefaultValue) {
        if (null != this.singleton) {
            return this.singleton;
        }
        if (null != context && context.getClass().equals(this.beanSpec.rawType())) {
            return context;
        }
        GenieInjector genieInjector = (GenieInjector)this.injector;
        return genieInjector.get(this.beanSpec);
    }

    @Override
    public String bindName() {
        return this.beanSpec.name();
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.tryDestroy(this.singleton);
        this.singleton = null;
        this.injector = null;
        lookup.clear();
    }

    public static void classInit(App app) {
        lookup = app.createConcurrentMap();
    }

    public static ProvidedValueLoader get(BeanSpec beanSpec, DependencyInjector<?> injector) {
        ProvidedValueLoader newLoader;
        ProvidedValueLoader loader = (ProvidedValueLoader)lookup.get(beanSpec);
        if (null == loader && null == (loader = lookup.putIfAbsent(beanSpec, newLoader = new ProvidedValueLoader(beanSpec, injector)))) {
            loader = newLoader;
        }
        return loader;
    }
}

