/*
 * Decompiled with CFR 0.152.
 */
package act.internal.util;

import act.Act;
import act.crypto.AppCrypto;
import act.util.DestroyableBase;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.E;
import org.osgl.util.S;

@Singleton
public class ResourceChecksumManager
extends DestroyableBase {
    @Inject
    private AppCrypto crypto;
    private Map<String, Lang.Val<String>> checksums = new HashMap<String, Lang.Val<String>>();

    @Override
    protected void releaseResources() {
        this.checksums.clear();
        this.crypto = null;
    }

    public String checksumOf(String path) {
        Lang.Val bag;
        E.illegalArgumentIf((path.startsWith("http:") || path.startsWith("//") ? 1 : 0) != 0);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.contains("?")) {
            path = S.beforeFirst((String)path, (String)"?");
        }
        if (null == (bag = this.checksums.get(path))) {
            InputStream is = Act.app().classLoader().getResourceAsStream(path);
            String checksum = null == is ? null : this.crypto.checksum(is);
            bag = $.val((Object)checksum);
            this.checksums.put(path, (Lang.Val<String>)bag);
        }
        return (String)bag.get();
    }
}

