/*
 * Decompiled with CFR 0.152.
 */
package act.job;

import act.app.App;
import act.app.AppHolderBase;
import act.app.event.SysEventId;
import act.job.AlongWith;
import act.job.Cron;
import act.job.Every;
import act.job.FixedDelay;
import act.job.InvokeAfter;
import act.job.InvokeBefore;
import act.job.Job;
import act.job.JobManager;
import act.job.JobTrigger;
import act.job.OnAppStart;
import act.job.OnAppStop;
import act.job.OnSysEvent;
import act.job.bytecode.JobAnnoInfo;
import act.job.bytecode.ReflectedJobInvoker;
import act.job.meta.JobClassMetaInfo;
import act.job.meta.JobMethodMetaInfo;
import java.lang.annotation.Annotation;
import java.util.List;
import org.osgl.Lang;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.E;
import org.osgl.util.S;

public class JobAnnotationProcessor
extends AppHolderBase<JobAnnotationProcessor> {
    private static final Logger LOGGER = LogManager.get(JobAnnotationProcessor.class);
    private JobManager manager;

    public JobAnnotationProcessor(App app) {
        super(app);
        this.manager = app.jobManager();
    }

    public void register(final JobMethodMetaInfo method, final Class<? extends Annotation> anno, final JobAnnoInfo info) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("register job[%s] on anno[%s] with arg[%s]", new Object[]{method, anno, info});
        }
        if (this.isAbstract(method)) {
            this.app().jobManager().on(SysEventId.SINGLETON_PROVISIONED, new Runnable(){

                @Override
                public void run() {
                    List<JobMethodMetaInfo> list = method.extendedJobMethodMetaInfoList(JobAnnotationProcessor.this.app());
                    for (JobMethodMetaInfo subMethodInfo : list) {
                        JobAnnotationProcessor.this.register(subMethodInfo, anno, info);
                    }
                }
            });
            return;
        }
        Job job = this.createMethodJob(method);
        String value = info.value;
        if (Cron.class.isAssignableFrom(anno)) {
            this.registerCron(job, this.evaluateExpression(value, anno));
        } else if (AlongWith.class.isAssignableFrom(anno)) {
            int delayInSeconds = info.delayInSeconds;
            this.registerAlongWith(job, value, delayInSeconds);
        } else if (Every.class.isAssignableFrom(anno)) {
            this.registerEvery(job, this.evaluateExpression(value, anno), info.startImmediately);
        } else if (FixedDelay.class.isAssignableFrom(anno)) {
            this.registerFixedDelay(job, this.evaluateExpression(value, anno), info.startImmediately);
        } else if (InvokeAfter.class.isAssignableFrom(anno)) {
            this.registerInvokeAfter(job, value);
        } else if (InvokeBefore.class.isAssignableFrom(anno)) {
            this.registerInvokeBefore(job, value);
        } else if (OnAppStart.class.isAssignableFrom(anno)) {
            boolean async = info.async;
            int delayInSeconds = info.delayInSeconds;
            this.registerOnAppStart(job, async, delayInSeconds);
        } else if (OnAppStop.class.isAssignableFrom(anno)) {
            boolean async = info.async;
            this.registerOnAppStop(job, async);
        } else if (OnSysEvent.class.isAssignableFrom(anno)) {
            this.registerOnSysEvent(job, info.sysEventId, info.async);
        } else {
            throw E.unsupport((String)"Unknown job annotation class: %s", (Object[])new Object[]{anno.getName()});
        }
    }

    private String evaluateExpression(String expression, Class<? extends Annotation> annoClass) {
        String prefix = annoClass.getSimpleName();
        prefix = S.eq((String)FixedDelay.class.getName(), (String)prefix) ? "fixed-delay" : prefix.toLowerCase();
        String ret = expression.trim();
        if (ret.startsWith(prefix) && S.blank((String)(ret = (String)this.app().config().get(expression)))) {
            throw E.invalidConfiguration((String)"Expression configuration not found: %s", (Object[])new Object[]{expression});
        }
        return ret;
    }

    private void registerCron(Job job, String expression) {
        JobTrigger.cron(expression).register(job, this.manager);
    }

    private void registerAlongWith(Job job, String targetJobId, int delayInSeconds) {
        if (delayInSeconds > 0) {
            JobTrigger.delayAfter(targetJobId, delayInSeconds).register(job, this.manager);
        } else {
            JobTrigger.alongWith(targetJobId).register(job, this.manager);
        }
    }

    private void registerEvery(Job job, String expression, boolean startImmediately) {
        JobTrigger.every(expression, startImmediately).register(job, this.manager);
    }

    private void registerFixedDelay(Job job, String expression, boolean startImmediately) {
        JobTrigger.fixedDelay(expression, startImmediately).register(job, this.manager);
    }

    private void registerInvokeAfter(Job job, String targetJobId) {
        JobTrigger.after(targetJobId).register(job, this.manager);
    }

    private void registerInvokeBefore(Job job, String targetJobId) {
        JobTrigger.before(targetJobId).register(job, this.manager);
    }

    private void registerOnAppStart(Job job, boolean async, int delayInSeconds) {
        JobTrigger.onAppStart(async, delayInSeconds).register(job, this.manager);
    }

    private void registerOnAppStop(Job job, boolean async) {
        JobTrigger.onAppStop(async).register(job, this.manager);
    }

    private void registerOnSysEvent(Job job, SysEventId sysEventId, boolean async) {
        JobTrigger.onSysEvent(sysEventId, async).register(job, this.manager);
    }

    private boolean isAbstract(JobMethodMetaInfo method) {
        JobClassMetaInfo classMetaInfo = method.classInfo();
        return classMetaInfo.isAbstract();
    }

    private Job createMethodJob(JobMethodMetaInfo method) {
        String id = method.id();
        return new Job(id, this.app().jobManager(), (Lang.Func0<?>)new ReflectedJobInvoker<JobMethodMetaInfo>(method, this.app()), false);
    }
}

