/*
 * Decompiled with CFR 0.152.
 */
package act.job.meta;

import act.Destroyable;
import act.asm.Type;
import act.job.AlongWith;
import act.job.Cron;
import act.job.Every;
import act.job.FixedDelay;
import act.job.InvokeAfter;
import act.job.InvokeBefore;
import act.job.OnAppStart;
import act.job.OnAppStop;
import act.job.OnSysEvent;
import act.job.meta.JobMethodMetaInfo;
import act.util.DestroyableBase;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.util.C;
import org.osgl.util.S;

@ApplicationScoped
public final class JobClassMetaInfo
extends DestroyableBase {
    private Type type;
    private Type superType;
    private boolean isAbstract = false;
    private List<JobMethodMetaInfo> actions = new ArrayList<JobMethodMetaInfo>();
    private Map<String, JobMethodMetaInfo> actionLookup = null;
    private boolean isJob;
    private static final C.Set<Class<? extends Annotation>> ACTION_ANNOTATION_TYPES = C.set(AlongWith.class, (Object[])new Class[]{Cron.class, Every.class, FixedDelay.class, InvokeAfter.class, InvokeBefore.class, OnAppStart.class, OnAppStop.class, OnSysEvent.class});

    public JobClassMetaInfo className(String name) {
        this.type = Type.getObjectType((String)name);
        return this;
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.destroyAll(this.actions, ApplicationScoped.class);
        this.actions.clear();
        Destroyable.Util.destroyAll(this.actionLookup.values(), ApplicationScoped.class);
        this.actionLookup.clear();
        super.releaseResources();
    }

    public String className() {
        return this.type.getClassName();
    }

    public Type type() {
        return this.type;
    }

    public JobClassMetaInfo superType(Type type) {
        this.superType = type;
        return this;
    }

    public Type superType() {
        return this.superType;
    }

    public JobClassMetaInfo setAbstract() {
        this.isAbstract = true;
        return this;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isJob() {
        return this.isJob;
    }

    public JobClassMetaInfo isJob(boolean b) {
        this.isJob = b;
        return this;
    }

    public JobClassMetaInfo addAction(JobMethodMetaInfo info) {
        this.actions.add(info);
        return this;
    }

    public JobMethodMetaInfo action(String name) {
        if (null == this.actionLookup) {
            for (JobMethodMetaInfo act : this.actions) {
                if (!S.eq((String)name, (String)act.name())) continue;
                return act;
            }
            return null;
        }
        return this.actionLookup.get(name);
    }

    private void buildActionLookup() {
        HashMap<String, JobMethodMetaInfo> lookup = new HashMap<String, JobMethodMetaInfo>();
        for (JobMethodMetaInfo act : this.actions) {
            lookup.put(act.name(), act);
        }
        this.actionLookup = lookup;
    }

    public static boolean isActionAnnotation(Class<? extends Annotation> type) {
        return ACTION_ANNOTATION_TYPES.contains(type);
    }
}

