/*
 * Decompiled with CFR 0.152.
 */
package act.job.meta;

import act.Act;
import act.app.App;
import act.app.event.SysEventId;
import act.asm.Type;
import act.event.meta.SimpleEventListenerMetaInfo;
import act.job.meta.JobClassMetaInfo;
import act.sys.meta.InvokeType;
import act.sys.meta.ReturnTypeInfo;
import act.util.ClassNode;
import act.util.DestroyableBase;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.inject.BeanSpec;
import org.osgl.util.E;
import org.osgl.util.S;

public class JobMethodMetaInfo
extends DestroyableBase {
    private String id;
    private String name;
    private InvokeType invokeType;
    private JobClassMetaInfo clsInfo;
    private ReturnTypeInfo returnType = new ReturnTypeInfo();
    private List<BeanSpec> paramTypes;
    private Method method;

    public JobMethodMetaInfo(final JobClassMetaInfo clsInfo, final List<String> paramTypes) {
        this.clsInfo = clsInfo;
        App app = Act.app();
        app.jobManager().on(SysEventId.DEPENDENCY_INJECTOR_PROVISIONED, new Runnable(){

            @Override
            public void run() {
                Lang.Var var = $.var();
                JobMethodMetaInfo.this.paramTypes = SimpleEventListenerMetaInfo.convert(paramTypes, clsInfo.className(), JobMethodMetaInfo.this.name, (Lang.Var<Method>)var);
                JobMethodMetaInfo.this.method = (Method)var.get();
            }
        });
    }

    private JobMethodMetaInfo(JobClassMetaInfo clsInfo, JobMethodMetaInfo parent) {
        this.clsInfo = clsInfo;
        this.paramTypes = parent.paramTypes;
    }

    @Override
    protected void releaseResources() {
        this.clsInfo.destroy();
        super.releaseResources();
    }

    public JobClassMetaInfo classInfo() {
        return this.clsInfo;
    }

    public JobMethodMetaInfo name(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String fullName() {
        return S.concat((String)this.clsInfo.className(), (String)".", (String)this.name());
    }

    public JobMethodMetaInfo id(String id) {
        this.id = id;
        return this;
    }

    public String id() {
        return S.blank((String)this.id) ? this.fullName() : this.id;
    }

    public Method method() {
        if (null == this.method) {
            Class c = $.classForName((String)this.classInfo().className(), (ClassLoader)Act.app().classLoader());
            if (null == this.paramTypes() || this.paramTypes().isEmpty()) {
                this.method = $.getMethod((Class)c, (String)this.name(), (Class[])new Class[0]);
            } else {
                throw new IllegalStateException("method cannot have parameters for Job invoked before app fully loaded");
            }
        }
        return this.method;
    }

    public JobMethodMetaInfo invokeStaticMethod() {
        this.invokeType = InvokeType.STATIC;
        return this;
    }

    public JobMethodMetaInfo invokeInstanceMethod() {
        this.invokeType = InvokeType.VIRTUAL;
        return this;
    }

    public boolean isStatic() {
        return InvokeType.STATIC == this.invokeType;
    }

    public JobMethodMetaInfo returnType(Type type) {
        this.returnType = ReturnTypeInfo.of(type);
        return this;
    }

    public Type returnType() {
        return this.returnType.type();
    }

    public List<BeanSpec> paramTypes() {
        return this.paramTypes;
    }

    public int hashCode() {
        return $.hc((Object)this.fullName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JobMethodMetaInfo) {
            JobMethodMetaInfo that = (JobMethodMetaInfo)obj;
            return $.eq((Object)that.fullName(), (Object)this.fullName());
        }
        return false;
    }

    public String toString() {
        S.Buffer sb = S.newBuffer();
        sb.append(this._invokeType()).append(this._return()).append(this.fullName());
        return sb.toString();
    }

    public List<JobMethodMetaInfo> extendedJobMethodMetaInfoList(App app) {
        E.illegalStateIf((!this.classInfo().isAbstract() ? 1 : 0) != 0, (String)"this job method meta info is not abstract");
        final ArrayList<JobMethodMetaInfo> list = new ArrayList<JobMethodMetaInfo>();
        JobClassMetaInfo clsInfo = this.classInfo();
        String clsName = clsInfo.className();
        ClassNode node = app.classLoader().classInfoRepository().node(clsName);
        if (null == node) {
            return list;
        }
        final JobMethodMetaInfo me = this;
        node.visitTree((Lang.Function<ClassNode, ?>)new Lang.Visitor<ClassNode>(){

            public void visit(ClassNode classNode) throws Lang.Break {
                if (!classNode.isAbstract() && classNode.isPublic()) {
                    JobClassMetaInfo subClsInfo = new JobClassMetaInfo().className(classNode.name());
                    JobMethodMetaInfo subMethodInfo = new JobMethodMetaInfo(subClsInfo, JobMethodMetaInfo.this);
                    if (me.isStatic()) {
                        subMethodInfo.invokeStaticMethod();
                    } else {
                        subMethodInfo.invokeInstanceMethod();
                    }
                    subMethodInfo.name(me.name());
                    subMethodInfo.returnType(me.returnType());
                    list.add(subMethodInfo);
                }
            }
        });
        return list;
    }

    private String _invokeType() {
        if (null == this.invokeType) {
            return "";
        }
        switch (this.invokeType) {
            case VIRTUAL: {
                return "";
            }
            case STATIC: {
                return "static ";
            }
        }
        assert (false);
        return "";
    }

    private String _return() {
        if (null == this.returnType) {
            return " ";
        }
        if (this.returnType.hasReturn()) {
            return this.returnType.type().getClassName() + " ";
        }
        return "";
    }
}

