/*
 * Decompiled with CFR 0.152.
 */
package act.plugin;

import act.Destroyable;
import act.app.App;
import act.plugin.AppServicePlugin;
import act.util.DestroyableBase;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;

public class AppServicePluginManager
extends DestroyableBase {
    private Map<Class<? extends AppServicePlugin>, AppServicePlugin> registry = new HashMap<Class<? extends AppServicePlugin>, AppServicePlugin>();

    synchronized void register(AppServicePlugin plugin) {
        if (!this.registry.containsKey(plugin.getClass())) {
            this.registry.put(plugin.getClass(), plugin);
        }
    }

    public synchronized void applyTo(App app) {
        for (AppServicePlugin plugin : this.registry.values()) {
            plugin.applyTo(app);
        }
    }

    public <T extends AppServicePlugin> T get(Class<T> key) {
        return (T)this.registry.get(key);
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.tryDestroyAll(this.registry.values(), ApplicationScoped.class);
        this.registry = null;
    }
}

