/*
 * Decompiled with CFR 0.152.
 */
package act.security;

import act.Act;
import act.app.ActionContext;
import act.app.App;
import act.crypto.AppCrypto;
import org.osgl.http.H;
import org.osgl.util.S;

public interface CSRFProtector {
    public boolean verifyToken(String var1, H.Session var2, App var3);

    public String retrieveToken(H.Session var1, String var2, App var3);

    public String generateToken(H.Session var1, App var2);

    public void clearExistingToken(H.Session var1, String var2);

    public void outputToken(String var1, String var2, String var3, ActionContext var4);

    public static enum Predefined implements CSRFProtector
    {
        HMAC{

            @Override
            public boolean verifyToken(String token, H.Session session, App app) {
                return S.eq((String)Act.app().decrypt(token), (String)this.generateToken(session, app));
            }

            @Override
            public String retrieveToken(H.Session session, String cookieName, App app) {
                return null;
            }

            @Override
            public void clearExistingToken(H.Session session, String cookieName) {
            }

            @Override
            public String generateToken(H.Session session, App app) {
                String id = session.id();
                String username = session.get(app.config().sessionKeyUsername());
                String payload = S.concat((String)id, (String)username);
                String sign = app.sign(payload);
                return S.concat((String)payload, (String)"-", (String)sign);
            }

            @Override
            public void outputToken(String token, String cookieName, String cookieDomain, ActionContext context) {
            }
        }
        ,
        RANDOM{

            @Override
            public boolean verifyToken(String token, H.Session session, App app) {
                String tokenInSession = session.get(app.config().csrfCookieName());
                if (S.eq((String)token, (String)tokenInSession)) {
                    return true;
                }
                AppCrypto crypto = Act.crypto();
                return S.eq((String)crypto.decrypt(token), (String)crypto.decrypt(tokenInSession));
            }

            @Override
            public String retrieveToken(H.Session session, String cookieName, App app) {
                return session.get(cookieName);
            }

            @Override
            public void clearExistingToken(H.Session session, String cookieName) {
                session.remove(cookieName);
            }

            @Override
            public String generateToken(H.Session session, App app) {
                return String.valueOf(Act.crypto().generateRandomInt());
            }

            @Override
            public void outputToken(String token, String cookieName, String cookieDomain, ActionContext context) {
                context.session().put(cookieName, token);
            }
        };


        public static CSRFProtector valueOfIgnoreCase(String s) {
            if (S.eq((String)HMAC.name(), (String)s.toUpperCase())) {
                return HMAC;
            }
            if (S.eq((String)RANDOM.name(), (String)s.toUpperCase())) {
                return RANDOM;
            }
            return null;
        }
    }
}

