/*
 * Decompiled with CFR 0.152.
 */
package act.session;

import act.conf.AppConfig;
import act.crypto.AppCrypto;
import act.crypto.RotateSecretCrypto;
import act.session.SessionCodec;
import act.util.DestroyableBase;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.osgl.$;
import org.osgl.http.H;
import org.osgl.util.C;
import org.osgl.util.Charsets;
import org.osgl.util.Codec;
import org.osgl.util.S;

@Singleton
public class DefaultSessionCodec
extends DestroyableBase
implements SessionCodec {
    private final boolean sessionWillExpire;
    private final boolean encryptSession;
    private final int ttlInMillis;
    private final String pingPath;
    private RotateSecretCrypto crypto;

    @Inject
    public DefaultSessionCodec(AppConfig conf, RotateSecretCrypto crypto) {
        this.ttlInMillis = conf.sessionTtl() * 1000;
        this.sessionWillExpire = this.ttlInMillis > 0;
        this.pingPath = conf.pingPath();
        this.encryptSession = conf.encryptSession();
        this.crypto = (RotateSecretCrypto)$.requireNotNull((Object)crypto);
    }

    @Override
    protected void releaseResources() {
        this.crypto = null;
    }

    @Override
    public String encodeSession(H.Session session) {
        if (null == session) {
            return null;
        }
        boolean sessionChanged = session.changed();
        if (!(sessionChanged || !session.empty() && this.sessionWillExpire)) {
            return null;
        }
        session.id();
        if (this.sessionWillExpire && !session.contains("___TS")) {
            session.put("___TS", (Object)($.ms() + (long)this.ttlInMillis));
        }
        return this.dissolveIntoCookieContent((H.KV<?>)session, true);
    }

    @Override
    public String encodeFlash(H.Flash flash) {
        if (null == flash || flash.isEmpty()) {
            return null;
        }
        return this.dissolveIntoCookieContent(flash.out(), false);
    }

    @Override
    public H.Session decodeSession(String encodedSession, H.Request request) {
        H.Session session = new H.Session();
        boolean newSession = true;
        if (S.notBlank((String)encodedSession)) {
            this.resolveFromCookieContent((H.KV<?>)session, encodedSession, true);
            newSession = false;
        }
        session = DefaultSessionCodec.processExpiration(session, $.ms(), newSession, this.sessionWillExpire, this.ttlInMillis, this.pingPath, request);
        return session;
    }

    @Override
    public H.Flash decodeFlash(String encodedFlash) {
        H.Flash flash = new H.Flash();
        if (S.notBlank((String)encodedFlash)) {
            this.resolveFromCookieContent((H.KV<?>)flash, encodedFlash, false);
            flash.discard();
        }
        return flash;
    }

    private void resolveFromCookieContent(H.KV<?> kv, String content, boolean isSession) {
        List<char[]> pairs;
        String data = Codec.decodeUrl((String)content, (Charset)Charsets.UTF_8);
        if (isSession) {
            int firstDashIndex;
            if (this.encryptSession) {
                try {
                    data = this.crypto.decrypt(data);
                }
                catch (Exception e) {
                    return;
                }
            }
            if ((firstDashIndex = data.indexOf("-")) < 0) {
                return;
            }
            String sign = data.substring(0, firstDashIndex);
            if (!this.crypto.verifySignature(data = data.substring(firstDashIndex + 1), sign)) {
                return;
            }
        }
        if ((pairs = this.split(data.toCharArray(), '\u0000')).isEmpty()) {
            return;
        }
        for (char[] pair : pairs) {
            List<char[]> kAndV = this.split(pair, '\u0001');
            int sz = kAndV.size();
            if (sz != 2) {
                S.Buffer sb = S.newBuffer();
                for (int i = 0; i < sz; ++i) {
                    if (i > 0) {
                        sb.append(":");
                    }
                    sb.append(Arrays.toString(kAndV.get(i)));
                }
                this.warn("unexpected KV string: %S", sb.toString());
                continue;
            }
            kv.put(new String(kAndV.get(0)), new String(kAndV.get(1)));
        }
    }

    private List<char[]> split(char[] content, char separator) {
        int len = content.length;
        if (0 == len) {
            return C.list();
        }
        ArrayList<char[]> l = new ArrayList<char[]>();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            char c = content[i];
            if (c != separator) continue;
            if (i == start) {
                ++start;
                continue;
            }
            char[] ca = new char[i - start];
            System.arraycopy(content, start, ca, 0, i - start);
            l.add(ca);
            start = i + 1;
        }
        if (start == 0) {
            l.add(content);
        } else {
            char[] ca = new char[len - start];
            System.arraycopy(content, start, ca, 0, len - start);
            l.add(ca);
        }
        return l;
    }

    private String dissolveIntoCookieContent(H.KV<?> kv, boolean isSession) {
        S.Buffer sb = S.buffer();
        int i = 0;
        for (Map.Entry entry : kv.entrySet()) {
            if (i > 0) {
                sb.append("\u0000");
            }
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            sb.append(k);
            sb.append("\u0001");
            sb.append(v);
            ++i;
        }
        String data = sb.toString();
        if (isSession) {
            String sign = this.crypto.sign(data);
            data = S.concat((String)sign, (String)"-", (String)data);
            if (this.encryptSession) {
                data = this.crypto.encrypt(data);
            }
        }
        data = Codec.encodeUrl((String)data, (Charset)Charsets.UTF_8);
        return data;
    }

    static H.Session processExpiration(H.Session session, long now, boolean newSession, boolean sessionWillExpire, int ttlInMillis, String pingPath, H.Request request) {
        if (!sessionWillExpire) {
            return session;
        }
        long expiration = now + (long)ttlInMillis;
        if (newSession) {
            session.load("___TS", String.valueOf(expiration));
        } else {
            String s = session.get("___TS");
            long oldTimestamp = null == s ? -1L : Long.parseLong(s);
            long newTimestamp = expiration;
            if (oldTimestamp < 0L) {
                session = new H.Session();
            } else if (oldTimestamp < now) {
                session = new H.Session();
                session.put("___expired", (Object)true);
            } else {
                session.remove("___expired");
                boolean skipUpdateExpiration = S.eq((String)pingPath, (String)request.url());
                if (skipUpdateExpiration) {
                    newTimestamp = oldTimestamp;
                }
            }
            session.put("___TS", (Object)newTimestamp);
        }
        return session;
    }

    public static void main(String[] args) {
        AppCrypto crypto = new AppCrypto("abc");
        String s = "hello world";
        String se = crypto.encrypt(s);
        System.out.println(crypto.decrypt(se));
        crypto = new AppCrypto("abc-213411253");
        System.out.println(crypto.decrypt(se));
    }
}

