/*
 * Decompiled with CFR 0.152.
 */
package act.session;

import act.conf.AppConfig;
import act.crypto.HMAC;
import act.util.SingletonBase;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.ReadableInstant;
import org.osgl.$;
import org.osgl.util.Codec;
import org.osgl.util.E;
import org.osgl.util.S;

@Singleton
public class JWT
extends SingletonBase {
    private final HMAC hmac;
    private final String issuer;

    @Inject
    public JWT(AppConfig config) {
        this.hmac = config.jwtAlgo();
        this.issuer = config.jwtIssuer();
    }

    public JWT(HMAC hmac, String issuer) {
        this.hmac = (HMAC)$.requireNotNull((Object)hmac);
        this.issuer = (String)$.requireNotNull((Object)issuer);
    }

    public Token newToken() {
        return new Token(this.issuer);
    }

    public String serialize(Token token) {
        return this.hmac.toString(token);
    }

    public Token deserialize(String tokenString) {
        S.List parts = S.fastSplit((String)tokenString, (String)".");
        E.illegalArgumentIf((parts.size() != 3 ? 1 : 0) != 0);
        String encodedHeaders = (String)parts.get(0);
        String encodedPayloads = (String)parts.get(1);
        String hash = (String)parts.get(2);
        if (!this.verifyHash(encodedHeaders, encodedPayloads, hash)) {
            return null;
        }
        String headerString = new String(Codec.decodeUrlSafeBase64((String)encodedHeaders));
        JSONObject headers = JSON.parseObject((String)headerString);
        if (!this.verifyArgo(headers)) {
            return null;
        }
        String payloadString = new String(Codec.decodeUrlSafeBase64((String)encodedPayloads));
        JSONObject payloads = JSON.parseObject((String)payloadString);
        if (!this.verifyIssuer(payloads)) {
            return null;
        }
        if (!this.verifyExpires(payloads)) {
            return null;
        }
        Token token = new Token(this.issuer);
        token.headers.putAll(headers);
        token.payloads.putAll(payloads);
        return token;
    }

    private boolean verifyHash(String header, String payload, String hash) {
        return this.hmac.verifyHash(S.concat((String)header, (String)".", (String)payload), hash);
    }

    private boolean verifyIssuer(JSONObject payloads) {
        return S.eq((String)this.issuer, (String)payloads.getString("iss"));
    }

    private boolean verifyExpires(JSONObject payloads) {
        Object obj = payloads.get((Object)Payload.EXPIRES_AT.key);
        return null != obj && obj instanceof Number && ((Number)obj).longValue() > $.ms() / 1000L;
    }

    private boolean verifyArgo(JSONObject headers) {
        return this.hmac.verifyArgo(headers.getString(Header.ALGO.key));
    }

    public static class Token {
        private Map<String, Object> headers = new HashMap<String, Object>();
        private Map<String, Object> payloads = new HashMap<String, Object>();

        public Token(AppConfig config) {
            this(config.jwtIssuer());
        }

        public Token(String issuer) {
            this.payloads.put(Payload.ISSUER.key, issuer);
            this.headers.put("typ", "JWT");
        }

        public Token header(Header header, String val) {
            this.headers.put(header.key, val);
            return this;
        }

        public Token payload(Payload payload, Object val) {
            if (val instanceof ReadableInstant) {
                val = (int)(((ReadableInstant)val).getMillis() / 1000L);
            } else if (val instanceof Date) {
                val = (int)(((Date)val).getTime() / 1000L);
            }
            return this.payload(payload.key, val);
        }

        public Token payload(String key, Object val) {
            this.payloads.put(key, val);
            return this;
        }

        public String headerJsonString() {
            return JSON.toJSONString(this.headers);
        }

        public String payloadJsonString() {
            return JSON.toJSONString(this.payloads);
        }

        public Map<String, Object> payloads() {
            return this.payloads;
        }

        public int hashCode() {
            return $.hc(this.headers, this.payloads);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Token) {
                Token that = (Token)$.cast((Object)obj);
                return $.eq(that.headers, this.headers) && $.eq(that.payloads, this.payloads);
            }
            return false;
        }

        public String toString(JWT jwt) {
            return jwt.serialize(this);
        }
    }

    public static enum Payload {
        SUBJECT("sub"),
        EXPIRES_AT("exp"),
        NOT_BEFORE("nbf"),
        ISSUED_AT("iat"),
        ISSUER("iss"),
        JWT_ID("jti");

        private String key;

        private Payload(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }
    }

    public static enum Header {
        ALGO("alg");

        private String key;

        private Header(String key) {
            this.key = key;
        }
    }
}

