/*
 * Decompiled with CFR 0.152.
 */
package act.sys;

import act.Act;
import act.asm.Type;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AnnotatedElement;
import org.osgl.util.C;
import org.osgl.util.OS;
import org.osgl.util.S;

public final class Env {
    private static final C.Set<Class<? extends Annotation>> ENV_ANNOTATION_TYPES = C.set(Mode.class, (Object[])new Class[]{Profile.class, Group.class, RequireProfile.class, RequireGroup.class, RequireMode.class});
    private static final C.Set<String> ENV_ANNO_DESCS = C.set((Object)Type.getType(Mode.class).getDescriptor(), (Object[])new String[]{Type.getType(RequireMode.class).getDescriptor(), Type.getType(Profile.class).getDescriptor(), Type.getType(RequireProfile.class).getDescriptor(), Type.getType(Group.class).getDescriptor(), Type.getType(RequireGroup.class).getDescriptor()});

    private Env() {
    }

    public static boolean matches(RequireMode modeTag) {
        return Env.modeMatches(modeTag.value(), modeTag.except());
    }

    @Deprecated
    public static boolean matches(Mode modeTag) {
        return Env.modeMatches(modeTag.value(), modeTag.unless());
    }

    public static boolean modeMatches(Act.Mode mode) {
        return mode == Act.mode();
    }

    public static boolean modeMatches(Act.Mode mode, boolean unless) {
        return unless ^ Env.modeMatches(mode);
    }

    public static boolean matches(RequireProfile profileTag) {
        return Env.profileMatches(profileTag.value(), profileTag.except());
    }

    @Deprecated
    public static boolean matches(Profile profileTag) {
        return Env.profileMatches(profileTag.value(), profileTag.unless());
    }

    public static boolean profileMatches(String profile) {
        return S.eq((String)profile, (String)Act.profile(), (int)4096);
    }

    public static boolean profileMatches(String profile, boolean unless) {
        return unless ^ Env.profileMatches(profile);
    }

    public static boolean modeMatches(String mode) {
        return S.eq((String)mode, (String)Act.mode().name(), (int)4096);
    }

    public static boolean modeMatches(String mode, boolean unless) {
        return unless ^ Env.modeMatches(mode);
    }

    public static boolean matches(RequireGroup groupTag) {
        return Env.groupMatches(groupTag.value(), groupTag.except());
    }

    @Deprecated
    public static boolean matches(Group groupTag) {
        return Env.groupMatches(groupTag.value(), groupTag.unless());
    }

    public static boolean groupMatches(String group) {
        return S.eq((String)group, (String)Act.nodeGroup(), (int)4096);
    }

    public static boolean groupMatches(String group, boolean unless) {
        return unless ^ Env.groupMatches(group);
    }

    public static boolean isEnvAnnotation(Class<? extends Annotation> type) {
        return ENV_ANNOTATION_TYPES.contains(type);
    }

    public static boolean isEnvAnnoDescriptor(String descriptor) {
        return ENV_ANNO_DESCS.contains((Object)descriptor);
    }

    public static boolean matches(AnnotatedElement annotatedElement) {
        Annotation[] annotations;
        for (Annotation anno : annotations = annotatedElement.getDeclaredAnnotations()) {
            Annotation group;
            Annotation mode;
            Annotation profile;
            if (!(anno instanceof RequireProfile ? !Env.matches(profile = (RequireProfile)anno) : (anno instanceof RequireMode ? !Env.matches(mode = (RequireMode)anno) : (anno instanceof RequireGroup ? !Env.matches(group = (RequireGroup)anno) : (anno instanceof Profile ? !Env.matches((Profile)(profile = (Profile)anno)) : (anno instanceof Group ? !Env.matches((Group)(group = (Group)anno)) : anno instanceof Mode && !Env.matches((Mode)(mode = (Mode)anno)))))))) continue;
            return false;
        }
        return true;
    }

    public static class PID {
        private static String pid = PID.getPid();

        private static String getPid() {
            OS os = OS.get();
            if (os.isUnix()) {
                File bash;
                File proc_self = new File("/proc/self");
                if (proc_self.exists()) {
                    try {
                        return proc_self.getCanonicalFile().getName();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bash = new File("/bin/sh")).exists()) {
                    ProcessBuilder pb = new ProcessBuilder("/bin/sh", "-c", "echo $PPID");
                    try {
                        Process p = pb.start();
                        BufferedReader rd = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        return rd.readLine();
                    }
                    catch (IOException e) {
                        return String.valueOf(Thread.currentThread().getId());
                    }
                }
            } else {
                int p;
                String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
                if (null != nameOfRunningVM && (p = nameOfRunningVM.indexOf(64)) > -1) {
                    return nameOfRunningVM.substring(0, p);
                }
            }
            return String.valueOf(Thread.currentThread().getId());
        }

        public static String get() {
            return pid;
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Mode {
        public Act.Mode value();

        public boolean unless() default false;
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RequireMode {
        public Act.Mode value();

        public boolean except() default false;
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Deprecated
    public static @interface Group {
        public String value();

        public boolean unless() default false;
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RequireGroup {
        public String value();

        public boolean except() default false;
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Deprecated
    public static @interface Profile {
        public String value();

        public boolean unless() default false;
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RequireProfile {
        public String value();

        public boolean except() default false;
    }
}

