/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import java.io.File;
import org.osgl.util.FastStr;
import org.osgl.util.S;

public enum ClassNames {


    public static String classFileNameToClassName(String fileName) {
        if (File.separatorChar != '/') {
            fileName = fileName.replace(File.separatorChar, '/');
        }
        if (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        return S.beforeLast((String)fileName.replace('/', '.'), (String)".");
    }

    public static String classNameToClassFileName(String className) {
        return ClassNames.classNameToClassFileName(className, false);
    }

    public static String classNameToClassFileName(String className, boolean keepInnerClass) {
        FastStr fs = FastStr.of((String)className);
        if (!keepInnerClass && className.contains("$")) {
            fs = fs.beforeFirst('$');
        }
        fs = fs.replace('.', '/').append(".class").prepend(Character.valueOf('/'));
        return fs.toString();
    }

    public static String sourceFileNameToClassName(File baseDir, String filePath) {
        FastStr ret;
        if (!filePath.endsWith(".java")) {
            return null;
        }
        FastStr path0 = FastStr.of((String)baseDir.getAbsolutePath());
        FastStr path1 = FastStr.of((String)filePath);
        if (File.separatorChar != '/') {
            path0 = path0.replace(File.separatorChar, '/');
            path1 = path1.replace(File.separatorChar, '/');
        }
        if ((ret = path1.afterFirst(path0)).startsWith((CharSequence)"/")) {
            ret = (FastStr)ret.substr(1);
        }
        return ret.replace('/', '.').beforeLast('.').toString();
    }
}

