/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.Act;
import act.app.App;
import act.app.AppServiceBase;
import act.util.Global;
import act.util.Stateless;
import java.lang.reflect.Field;
import java.util.List;
import org.osgl.$;

public class ReflectedInvokerHelper {
    public static Object tryGetSingleton(Class<?> invokerClass, App app) {
        Object singleton = app.singleton(invokerClass);
        if (null == singleton) {
            List fields = $.fieldsOf(invokerClass);
            if (fields.isEmpty()) {
                singleton = app.getInstance(invokerClass);
            }
            boolean stateful = false;
            for (Field field : fields) {
                if (ReflectedInvokerHelper.isGlobalOrStateless(field)) continue;
                stateful = true;
                break;
            }
            if (!stateful) {
                singleton = app.getInstance(invokerClass);
            }
        }
        return singleton;
    }

    private static boolean isGlobalOrStateless(Field field) {
        if (null != field.getAnnotation(Stateless.class) || null != field.getAnnotation(Global.class)) {
            return true;
        }
        Class<?> fieldType = field.getType();
        return Act.app().isSingleton(fieldType) || AppServiceBase.class.isAssignableFrom(fieldType);
    }
}

