/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.Destroyable;
import act.util.DestroyableBase;
import act.util.ProgressGauge;
import java.util.ArrayList;
import java.util.List;
import org.osgl.$;
import org.osgl.util.E;

public class SimpleProgressGauge
extends DestroyableBase
implements ProgressGauge {
    private String id;
    private int maxHint;
    private int currentSteps;
    private ProgressGauge delegate;
    private List<ProgressGauge.Listener> listeners = new ArrayList<ProgressGauge.Listener>();

    private SimpleProgressGauge(ProgressGauge delegate) {
        this.delegate = (ProgressGauge)$.requireNotNull((Object)delegate);
    }

    public SimpleProgressGauge(int maxHint) {
        this.maxHint = maxHint;
    }

    public SimpleProgressGauge() {
        this.maxHint = 100;
    }

    @Override
    protected void releaseResources() {
        this.maxHint = 100;
        this.currentSteps = 0;
        Destroyable.Util.tryDestroy(this.delegate);
        this.triggerUpdateEvent();
    }

    @Override
    public void addListener(ProgressGauge.Listener listener) {
        if (null != this.delegate) {
            this.delegate.addListener(listener);
        } else {
            this.listeners.add(listener);
        }
    }

    @Override
    public void updateMaxHint(int maxHint) {
        if (null != this.delegate) {
            this.delegate.updateMaxHint(maxHint);
        } else {
            this.maxHint = maxHint;
            this.triggerUpdateEvent();
        }
    }

    @Override
    public void step() {
        if (null != this.delegate) {
            this.delegate.step();
        } else {
            ++this.currentSteps;
            this.triggerUpdateEvent();
        }
    }

    @Override
    public void stepBy(int steps) {
        if (null != this.delegate) {
            this.delegate.stepBy(steps);
        } else {
            this.currentSteps += steps;
            this.triggerUpdateEvent();
        }
    }

    @Override
    public void stepTo(int steps) {
        E.illegalArgumentIf((steps < 0 ? 1 : 0) != 0);
        if (null != this.delegate) {
            this.delegate.stepTo(steps);
        } else {
            this.currentSteps = steps;
            this.triggerUpdateEvent();
        }
    }

    @Override
    public int currentSteps() {
        if (null != this.delegate) {
            return this.delegate.currentSteps();
        }
        return this.currentSteps;
    }

    public int getCurrentSteps() {
        return this.currentSteps();
    }

    @Override
    public int maxHint() {
        if (null != this.delegate) {
            return this.delegate.maxHint();
        }
        return this.maxHint;
    }

    public int getMaxHint() {
        return this.maxHint();
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public int currentProgressPercent() {
        if (null != this.delegate) {
            return this.delegate.currentSteps() * 100 / this.delegate.maxHint();
        }
        return this.currentSteps * 100 / this.maxHint;
    }

    public int getProgressPercent() {
        return this.currentProgressPercent();
    }

    @Override
    public boolean isDone() {
        if (null != this.delegate) {
            return this.delegate.isDone();
        }
        return this.currentSteps == this.maxHint;
    }

    @Override
    public void markAsDone() {
        this.stepTo(this.maxHint);
    }

    private void triggerUpdateEvent() {
        for (ProgressGauge.Listener listener : this.listeners) {
            listener.onUpdate(this);
        }
    }

    public static SimpleProgressGauge wrap(ProgressGauge progressGauge) {
        E.NPE((Object)progressGauge);
        if (progressGauge instanceof SimpleProgressGauge) {
            return (SimpleProgressGauge)progressGauge;
        }
        return new SimpleProgressGauge(progressGauge);
    }

    public static String wsJobProgressTag(String jobId) {
        return "__act_job_progress_" + jobId + "__";
    }
}

