/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.Act;
import act.app.App;
import act.util.Files;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.fileupload.FileItemStream;
import org.osgl.$;
import org.osgl.storage.ISObject;
import org.osgl.storage.KeyGenerator;
import org.osgl.storage.KeyNameProvider;
import org.osgl.storage.impl.FileSystemService;
import org.osgl.storage.impl.SObject;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;

public class UploadFileStorageService
extends FileSystemService {
    public static final KeyNameProvider ACT_STORAGE_KEY_NAME_PROVIDER = new KeyNameProvider(){

        public String newKeyName() {
            return Act.cuid();
        }
    };
    private int inMemoryCacheThreshold;

    public UploadFileStorageService(Map<String, String> conf, int inMemoryCacheThreshold) {
        super(conf);
        this.setKeyNameProvider(ACT_STORAGE_KEY_NAME_PROVIDER);
        this.inMemoryCacheThreshold = inMemoryCacheThreshold;
    }

    public static UploadFileStorageService create(App app) {
        File tmp = app.tmpDir();
        if (!tmp.exists() && !tmp.mkdirs()) {
            throw E.unexpected((String)"Cannot create tmp dir", (Object[])new Object[0]);
        }
        C.Map conf = C.newMap((Object[])new Object[]{"storage.fs.home.dir", Files.file(app.tmpDir(), "uploads").getAbsolutePath(), "storage.keygen", KeyGenerator.Predefined.BY_DATE.name()});
        conf.put("storage.id", "__upload");
        conf.put("storage.storeSuffix", "false");
        return new UploadFileStorageService((Map<String, String>)conf, app.config().uploadInMemoryCacheThreshold());
    }

    public static ISObject store(FileItemStream fileItemStream, App app) {
        UploadFileStorageService ss = app.uploadFileStorageService();
        try {
            return ss._store(fileItemStream);
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    private ISObject _store(FileItemStream fileItemStream) throws IOException {
        String contentType;
        ISObject retVal;
        String filename = fileItemStream.getName();
        String key = this.newKey(filename);
        File tmpFile = this.getFile(key);
        InputStream input = fileItemStream.openStream();
        ThresholdingByteArrayOutputStream output = new ThresholdingByteArrayOutputStream(this.inMemoryCacheThreshold, tmpFile);
        IO.copy((InputStream)input, (OutputStream)output);
        if (output.exceedThreshold) {
            retVal = this.getFull(key);
        } else {
            int size = output.written;
            byte[] buf = output.buf();
            retVal = SObject.of((String)key, (byte[])buf, (int)size);
        }
        if (S.notBlank((String)filename)) {
            retVal.setFilename(filename);
        }
        if (null != (contentType = fileItemStream.getContentType())) {
            retVal.setContentType(contentType);
        }
        return retVal;
    }

    private String newKey(String filename) {
        if (S.blank((String)filename)) {
            return S.concat((String)Act.cuid(), (String)"tmp");
        }
        return S.pathConcat((String)this.getKey(Act.cuid()), (char)'/', (String)filename);
    }

    private static class ThresholdingByteArrayOutputStream
    extends ByteArrayOutputStream {
        private int threshold;
        private int written;
        private boolean exceedThreshold;
        private File file;
        private OutputStream fileOutputStream;

        public ThresholdingByteArrayOutputStream(int threshold, File file) {
            if (threshold < 1024) {
                threshold = 1024;
            }
            this.buf = new byte[threshold];
            this.threshold = threshold;
            this.file = (File)$.requireNotNull((Object)file);
        }

        @Override
        public synchronized void write(int b) {
            if (!this.checkThresholding(1)) {
                super.write(b);
            } else {
                try {
                    this.fileOutputStream.write(b);
                }
                catch (IOException e) {
                    throw E.ioException((IOException)e);
                }
            }
            ++this.written;
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
            if (!this.checkThresholding(len)) {
                super.write(b, off, len);
            } else {
                try {
                    this.fileOutputStream.write(b, off, len);
                }
                catch (IOException e) {
                    throw E.ioException((IOException)e);
                }
            }
            this.written += len;
        }

        @Override
        public void flush() throws IOException {
            if (this.exceedThreshold) {
                this.fileOutputStream.flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.exceedThreshold) {
                IO.close((Closeable)this.fileOutputStream);
            }
        }

        byte[] buf() {
            return this.buf;
        }

        private boolean checkThresholding(int bytes) {
            if (!this.exceedThreshold && this.written + bytes > this.threshold) {
                this.exceedThreshold = true;
                this.fileOutputStream = this.createFileOutputStream();
                try {
                    this.fileOutputStream.write(this.buf, 0, this.written);
                }
                catch (IOException e) {
                    throw E.ioException((IOException)e);
                }
            }
            return this.exceedThreshold;
        }

        private OutputStream createFileOutputStream() {
            File dir = this.file.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                throw E.ioException((String)("Cannot create dir: " + dir.getAbsolutePath()), (Object[])new Object[0]);
            }
            return IO.buffered((OutputStream)IO.os((File)this.file));
        }
    }
}

