/*
 * Decompiled with CFR 0.152.
 */
package act.validation;

import act.Act;
import act.app.App;
import act.inject.ActProvider;
import act.plugin.AppServicePlugin;
import act.validation.ActValidationMessageInterpolator;
import javax.validation.Configuration;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ValidationPlugin
extends AppServicePlugin {
    private Configuration config;
    private ValidatorFactory factory;
    private Validator validator;

    @Override
    protected void applyTo(App app) {
        this.init(app);
        app.registerSingleton(ValidationPlugin.class, this);
    }

    private void init(App app) {
        this.config = Validation.byDefaultProvider().configure();
        this.config.messageInterpolator((MessageInterpolator)new ActValidationMessageInterpolator(this.config.getDefaultMessageInterpolator(), app.config()));
        this.ensureFactoryValidator();
    }

    private void ensureFactoryValidator() {
        if (this.validator != null) {
            return;
        }
        if (this.factory == null) {
            this.factory = this.config.buildValidatorFactory();
        }
        this.validator = this.factory.getValidator();
    }

    public static class ValidatorProvider
    extends ActProvider<Validator> {
        public Validator get() {
            ValidationPlugin plugin = Act.singleton(ValidationPlugin.class);
            return plugin.validator;
        }
    }
}

