/*
 * Decompiled with CFR 0.152.
 */
package act.view;

import act.Act;
import act.app.App;
import act.app.SourceInfo;
import act.asm.AsmContext;
import act.asm.AsmException;
import act.exception.BindException;
import act.util.ActError;
import act.view.ActBadRequest;
import act.view.ActConflict;
import act.view.ActForbidden;
import act.view.ActMethodNotAllowed;
import act.view.ActNotFound;
import act.view.ActNotImplemented;
import act.view.ActUnauthorized;
import act.view.RythmTemplateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import org.osgl.Lang;
import org.osgl.exception.InvalidRangeException;
import org.osgl.exception.UnsupportedException;
import org.osgl.http.H;
import org.osgl.mvc.annotation.ResponseStatus;
import org.osgl.mvc.result.ErrorResult;
import org.osgl.mvc.result.Result;
import org.osgl.util.E;
import org.osgl.util.S;
import org.rythmengine.exception.RythmException;

public class ActErrorResult
extends ErrorResult
implements ActError {
    protected SourceInfo sourceInfo;
    private static Map<Class<? extends Throwable>, Lang.Function<Throwable, Result>> x = new HashMap<Class<? extends Throwable>, Lang.Function<Throwable, Result>>();
    private static Map<Class, Integer> userDefinedStatus;

    public ActErrorResult(H.Status status) {
        super(status, ActError.Util.errorMessage(status));
        this.init();
        this.populateSourceInfo();
    }

    public ActErrorResult(H.Status status, String message, Object ... args) {
        super(status, ActError.Util.errorMessage(status, message, args));
        this.init();
        this.populateSourceInfo();
    }

    public ActErrorResult(H.Status status, int errorCode) {
        super(status, Integer.valueOf(errorCode), ActError.Util.errorMessage(status));
        this.init();
        this.populateSourceInfo();
    }

    public ActErrorResult(H.Status status, int errorCode, String message, Object ... args) {
        super(status, Integer.valueOf(errorCode), ActError.Util.errorMessage(status, message, args));
        this.init();
        this.populateSourceInfo();
    }

    public ActErrorResult(Throwable cause) {
        super(H.Status.INTERNAL_SERVER_ERROR, cause, ActError.Util.errorMessage(H.Status.INTERNAL_SERVER_ERROR), new Object[0]);
        this.init();
        this.populateSourceInfo(cause);
    }

    private ActErrorResult(AsmException exception, boolean scanning) {
        super(H.Status.INTERNAL_SERVER_ERROR, exception.getCause(), ActErrorResult.errorMsg(exception, scanning), new Object[0]);
        this.init();
        this.populateSourceInfo(exception.context());
    }

    public ActErrorResult(H.Status status, Throwable cause) {
        super(status, cause, ActError.Util.errorMessage(status), new Object[0]);
        this.init();
        this.populateSourceInfo(cause);
    }

    public ActErrorResult(H.Status status, Throwable cause, String message, Object ... args) {
        super(status, cause, ActError.Util.errorMessage(status, message, args), new Object[0]);
        this.init();
        this.populateSourceInfo(cause);
    }

    public ActErrorResult(H.Status status, int errorCode, Throwable cause, String message, Object ... args) {
        super(status, Integer.valueOf(errorCode), cause, ActError.Util.errorMessage(status, message, args), new Object[0]);
        this.init();
        this.populateSourceInfo(cause);
    }

    public ActErrorResult(H.Status status, int errorCode, Throwable cause) {
        super(status, Integer.valueOf(errorCode), cause, ActError.Util.errorMessage(status), new Object[0]);
        this.init();
        this.populateSourceInfo(cause);
    }

    @Override
    public Throwable getCauseOrThis() {
        Throwable cause = this.getCause();
        return null == cause ? this : cause;
    }

    @Override
    public SourceInfo sourceInfo() {
        return this.sourceInfo;
    }

    public int statusCode() {
        Throwable cause = super.getCause();
        int statusCode = null == cause ? -1 : ActErrorResult.userDefinedStatusCode(cause.getClass());
        return -1 == statusCode ? super.statusCode() : statusCode;
    }

    @Override
    public List<String> stackTrace() {
        return ActError.Util.stackTraceOf(this);
    }

    @Override
    public boolean isErrorSpot(String traceLine, String nextTraceLine) {
        return false;
    }

    protected void init() {
    }

    protected void populateSourceInfo(Throwable cause) {
        if (!Act.isDev()) {
            return;
        }
        this.sourceInfo = ActError.Util.loadSourceInfo(cause, this.getClass());
    }

    private void populateSourceInfo() {
        if (!Act.isDev()) {
            return;
        }
        this.sourceInfo = ActError.Util.loadSourceInfo(new RuntimeException(), this.getClass());
    }

    protected void populateSourceInfo(AsmContext context) {
        if (!Act.isDev()) {
            return;
        }
        this.sourceInfo = ActError.Util.loadSourceInfo(context);
    }

    public static void classInit(App app) {
        userDefinedStatus = app.createMap();
    }

    private static int userDefinedStatusCode(Class<? extends Throwable> exCls) {
        Integer I = userDefinedStatus.get(exCls);
        if (null == I) {
            ResponseStatus rs = exCls.getAnnotation(ResponseStatus.class);
            if (null == rs) {
                I = -1;
                userDefinedStatus.put(exCls, -1);
            } else {
                I = rs.value();
            }
        }
        return I;
    }

    public static Result of(Throwable t) {
        if (t instanceof Result) {
            return (Result)t;
        }
        if (t instanceof RythmException) {
            return Act.isDev() ? new RythmTemplateException((RythmException)t) : ErrorResult.of((H.Status)H.Status.INTERNAL_SERVER_ERROR);
        }
        if (t instanceof AsmException) {
            return new ActErrorResult((AsmException)t, true);
        }
        Lang.Function<Throwable, Result> transformer = ActErrorResult.transformerOf(t);
        return null == transformer ? new ActErrorResult(t) : (Result)transformer.apply((Object)t);
    }

    public static ActErrorResult scanningError(AsmException exception) {
        return new ActErrorResult(exception, true);
    }

    public static ActErrorResult enhancingError(AsmException exception) {
        return new ActErrorResult(exception, false);
    }

    private static Lang.Function<Throwable, Result> transformerOf(Throwable t) {
        Class<?> tc = t.getClass();
        Lang.Function<Throwable, Result> transformer = x.get(tc);
        if (null != transformer) {
            return transformer;
        }
        for (Class<? extends Throwable> c : x.keySet()) {
            if (!c.isAssignableFrom(tc)) continue;
            return x.get(c);
        }
        return null;
    }

    public static Result ofStatus(int statusCode) {
        return ActErrorResult.of(H.Status.of((int)statusCode));
    }

    @Deprecated
    public static Result of(int statusCode) {
        E.illegalArgumentIf((statusCode < 400 ? 1 : 0) != 0);
        switch (statusCode) {
            case 400: {
                return ActBadRequest.create();
            }
            case 401: {
                return ActUnauthorized.create();
            }
            case 403: {
                return ActForbidden.create();
            }
            case 404: {
                return ActNotFound.create();
            }
            case 405: {
                return ActMethodNotAllowed.create();
            }
            case 409: {
                return ActConflict.create();
            }
            case 501: {
                return ActNotImplemented.create();
            }
        }
        if (Act.isDev()) {
            return new ActErrorResult(new RuntimeException());
        }
        return new ErrorResult(H.Status.of((int)statusCode));
    }

    public static ErrorResult of(H.Status status) {
        E.illegalArgumentIf((!status.isClientError() && !status.isServerError() ? 1 : 0) != 0);
        if (Act.isDev()) {
            return new ActErrorResult(status);
        }
        return ErrorResult.of((H.Status)status);
    }

    public static ErrorResult of(H.Status status, String message, Object ... args) {
        E.illegalArgumentIf((!status.isClientError() && !status.isServerError() ? 1 : 0) != 0);
        if (Act.isDev()) {
            return new ActErrorResult(status, message, args);
        }
        return ErrorResult.of((H.Status)status, (String)message, (Object[])args);
    }

    public static ErrorResult of(H.Status status, int errorCode) {
        E.illegalArgumentIf((!status.isClientError() && !status.isServerError() ? 1 : 0) != 0);
        if (Act.isDev()) {
            return new ActErrorResult(status, errorCode);
        }
        return ErrorResult.of((H.Status)status, (int)errorCode);
    }

    public static ErrorResult of(H.Status status, int errorCode, String message, Object ... args) {
        E.illegalArgumentIf((!status.isClientError() && !status.isServerError() ? 1 : 0) != 0);
        if (Act.isDev()) {
            return new ActErrorResult(status, errorCode, message, args);
        }
        return ErrorResult.of((H.Status)status, (int)errorCode, (String)message, (Object[])args);
    }

    public static Throwable rootCauseOf(Throwable t) {
        Throwable cause;
        if (null == t) {
            return null;
        }
        while (null != (cause = t.getCause())) {
            t = cause;
        }
        return t;
    }

    private static String errorMsg(AsmException exception, boolean scanning) {
        String userMsg = exception.getLocalizedMessage();
        return S.blank((String)userMsg) ? S.concat((String)"Error ", (String)(scanning ? "scanning" : "enhancing"), (String)" bytecode at ", (String)exception.context().toString()) : userMsg;
    }

    static {
        Lang.Transformer<Throwable, Result> unsupported = new Lang.Transformer<Throwable, Result>(){

            public Result transform(Throwable throwable) {
                return ActNotImplemented.create(throwable);
            }
        };
        x.put(UnsupportedException.class, (Lang.Function<Throwable, Result>)unsupported);
        x.put(UnsupportedOperationException.class, (Lang.Function<Throwable, Result>)unsupported);
        x.put(IllegalStateException.class, (Lang.Function<Throwable, Result>)new Lang.Transformer<Throwable, Result>(){

            public Result transform(Throwable throwable) {
                return ActConflict.create(throwable);
            }
        });
        Lang.Transformer<Throwable, Result> badRequest = new Lang.Transformer<Throwable, Result>(){

            public Result transform(Throwable throwable) {
                return ActBadRequest.create(throwable);
            }
        };
        x.put(IllegalArgumentException.class, (Lang.Function<Throwable, Result>)badRequest);
        x.put(InvalidRangeException.class, (Lang.Function<Throwable, Result>)badRequest);
        x.put(IndexOutOfBoundsException.class, (Lang.Function<Throwable, Result>)badRequest);
        x.put(ValidationException.class, (Lang.Function<Throwable, Result>)badRequest);
        x.put(BindException.class, (Lang.Function<Throwable, Result>)badRequest);
    }
}

