/*
 * Decompiled with CFR 0.152.
 */
package act.view;

import act.app.ActionContext;
import act.cli.view.CliView;
import act.route.UrlPath;
import act.util.ActContext;
import act.util.PropertySpec;
import java.io.Writer;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.http.H;
import org.osgl.mvc.result.RenderContent;
import org.osgl.mvc.result.Result;
import org.osgl.util.S;

public class RenderCSV
extends RenderContent {
    private static RenderCSV _INSTANCE = new RenderCSV(){

        public String content() {
            return 1.payload().message;
        }

        public Lang.Visitor<Writer> contentWriter() {
            return 1.payload().contentWriter;
        }

        public long timestamp() {
            return 1.payload().timestamp;
        }
    };

    private RenderCSV() {
        super(H.Format.CSV);
    }

    public RenderCSV(final Object v, final PropertySpec.MetaInfo spec, final ActContext context) {
        super((Lang.Visitor)new Lang.Visitor<Writer>(){

            public void visit(Writer writer) throws Lang.Break {
                RenderCSV.render(writer, v, spec, context);
            }
        }, H.Format.CSV);
    }

    public RenderCSV(H.Status status, final Object v, final PropertySpec.MetaInfo spec, final ActContext context) {
        super(status, (Lang.Visitor)new Lang.Visitor<Writer>(){

            public void visit(Writer writer) throws Lang.Break {
                RenderCSV.render(writer, v, spec, context);
            }
        }, H.Format.CSV);
    }

    public static RenderCSV of(final Object v, final PropertySpec.MetaInfo spec, final ActContext context) {
        RenderCSV.touchPayload().contentWriter((Lang.Visitor)new Lang.Visitor<Writer>(){

            public void visit(Writer writer) throws Lang.Break {
                RenderCSV.render(writer, v, spec, context);
            }
        });
        return _INSTANCE;
    }

    public static RenderCSV of(H.Status status, final Object v, final PropertySpec.MetaInfo spec, final ActionContext context) {
        Result.Payload payload = RenderCSV.touchPayload().status(status);
        if (context.isLargeResponse()) {
            payload.contentWriter((Lang.Visitor)new Lang.Visitor<Writer>(){

                public void visit(Writer writer) throws Lang.Break {
                    RenderCSV.render(writer, v, spec, context);
                }
            });
        } else {
            payload.stringContentProducer((Lang.Func0)new Lang.Func0<String>(){

                public String apply() throws NotAppliedException, Lang.Break {
                    S.Buffer buf = S.buffer();
                    RenderCSV.render((Writer)$.convert((Object)buf).to(Writer.class), v, spec, context);
                    return buf.toString();
                }
            });
        }
        return _INSTANCE;
    }

    private static void render(Writer writer, Object v, PropertySpec.MetaInfo spec, ActContext context) {
        RenderCSV.setDownloadHeader(context);
        CliView.CSV.render(writer, v, spec, context);
    }

    private static void setDownloadHeader(ActContext context) {
        if (context instanceof ActionContext) {
            ActionContext ctx = (ActionContext)context;
            UrlPath path = ctx.urlPath();
            String fileName = S.concat((String)S.underscore((CharSequence)path.lastPart()), (String)".csv");
            ctx.resp().contentDisposition(fileName, false);
        }
    }
}

