/*
 * Decompiled with CFR 0.152.
 */
package act.view;

import act.Act;
import act.app.App;
import act.app.event.SysEventId;
import act.plugin.AppServicePlugin;
import act.util.ActContext;
import act.view.Template;
import java.io.File;
import java.util.List;
import org.osgl.http.H;
import org.osgl.util.C;
import org.osgl.util.IO;
import org.osgl.util.S;

public abstract class View
extends AppServicePlugin {
    public abstract String name();

    @Override
    protected void applyTo(final App app) {
        Act.viewManager().register(this);
        app.jobManager().on(SysEventId.CLASS_LOADER_INITIALIZED, new Runnable(){

            @Override
            public void run() {
                View.this.init(app);
            }
        });
    }

    public boolean appliedTo(ActContext context) {
        H.Format format = context.accept();
        return format.isText();
    }

    protected abstract Template loadTemplate(String var1);

    protected abstract Template loadInlineTemplate(String var1);

    protected void init(App app) {
    }

    protected void reload(App app) {
        this.init(app);
    }

    protected final String templateHome() {
        String templateHome = Act.appConfig().templateHome();
        if (S.blank((String)templateHome) || "default".equals(templateHome)) {
            templateHome = "/" + this.name();
        }
        return templateHome;
    }

    public List<String> loadContent(String template) {
        File file = new File(this.templateRootDir(), template);
        if (file.exists() && file.canRead()) {
            return IO.readLines((File)file);
        }
        return C.list();
    }

    protected final File templateRootDir() {
        App app = Act.app();
        return new File(app.layout().resource(app.base()), this.templateHome());
    }
}

