/*
 * Decompiled with CFR 0.152.
 */
package act.view.rythm;

import act.Act;
import act.conf.AppConfig;
import act.util.ActContext;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.rythmengine.extension.IDateFormatFactory;
import org.rythmengine.template.ITemplate;

public class DateFormatFactory
implements IDateFormatFactory {
    private ConcurrentMap<IDateFormatFactory.DateFormatKey, DateFormat> cache = new ConcurrentHashMap<IDateFormatFactory.DateFormatKey, DateFormat>();
    private AppConfig config;

    public DateFormatFactory(AppConfig config) {
        this.config = config;
    }

    public DateFormat createDateFormat(ITemplate template, String pattern, Locale locale, String timezone) {
        IDateFormatFactory.DateFormatKey key = new IDateFormatFactory.DateFormatKey(locale = this.ensureLocale(locale, template), timezone, pattern);
        DateFormat df = (DateFormat)this.cache.get(key);
        if (null == df) {
            if (null == pattern) {
                pattern = this.config.localizedDateTimePattern(locale);
            }
            df = new SimpleDateFormat(pattern, locale);
            if (null != timezone) {
                df.setTimeZone(TimeZone.getTimeZone(timezone));
            }
            this.cache.putIfAbsent(key, df);
        }
        return df;
    }

    private Locale ensureLocale(Locale locale, ITemplate template) {
        if (null != locale) {
            return locale;
        }
        if (null != template) {
            locale = template.__curLocale();
        }
        if (null == locale) {
            ActContext.Base<?> ctx = ActContext.Base.currentContext();
            return null == ctx ? Act.appConfig().locale() : ctx.locale(true);
        }
        return locale;
    }
}

