/*
 * Decompiled with CFR 0.152.
 */
package act.view.rythm;

import act.Act;
import act.app.App;
import act.conf.AppConfig;
import act.data.DateTimeType;
import act.util.ActContext;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.osgl.$;
import org.osgl.util.S;
import org.rythmengine.extension.Transformer;
import org.rythmengine.template.ITemplate;

public class JodaTransformers {
    private static ConcurrentMap<Key, DateTimeFormatter> formatters;

    public static void classInit(App app) {
        formatters = app.createConcurrentMap();
    }

    private static DateTimeFormatter formatter(DateTimeType type, String pattern, Locale locale, String timezone) {
        Key key = new Key(type, locale, timezone, pattern);
        DateTimeFormatter formatter = (DateTimeFormatter)formatters.get(key);
        if (null == formatter) {
            formatter = type.defaultJodaFormatter();
            AppConfig config = Act.appConfig();
            if (null == locale) {
                ActContext.Base<?> ctx = ActContext.Base.currentContext();
                Locale locale2 = locale = null == ctx ? config.locale() : ctx.locale(true);
            }
            if (config.i18nEnabled() && $.ne((Object)locale, (Object)config.locale())) {
                if (S.blank((String)pattern)) {
                    pattern = type.defaultPattern(config, locale);
                }
                formatter = DateTimeFormat.forPattern((String)pattern).withLocale(locale);
                if (S.notBlank((String)timezone)) {
                    formatter = formatter.withZone(DateTimeZone.forID((String)timezone));
                }
            }
            formatters.putIfAbsent(key, formatter);
        }
        return formatter;
    }

    static String format(ReadableInstant dateTime, String pattern, Locale locale, String timezone) {
        DateTimeFormatter formatter = JodaTransformers.formatter(DateTimeType.DATE_TIME, pattern, locale, timezone);
        return formatter.print(dateTime);
    }

    static String format(ReadablePartial dateTime, String pattern, Locale locale, String timezone) {
        DateTimeType type = DateTimeType.of(dateTime);
        DateTimeFormatter formatter = JodaTransformers.formatter(type, pattern, locale, timezone);
        return formatter.print(dateTime);
    }

    @Transformer(requireTemplate=true)
    public static String shortStyle(DateTime dateTime) {
        return JodaTransformers.shortStyle(null, dateTime);
    }

    public static String shortStyle(ITemplate template, DateTime dateTime) {
        Locale locale = null == template ? Act.appConfig().locale() : template.__curLocale();
        return JodaTransformers.format((ReadableInstant)dateTime, DateTimeFormat.patternForStyle((String)"SS", (Locale)locale), locale, null);
    }

    @Transformer(requireTemplate=true)
    public static String mediumStyle(DateTime dateTime) {
        return JodaTransformers.mediumStyle(null, dateTime);
    }

    public static String mediumStyle(ITemplate template, DateTime dateTime) {
        Locale locale = null == template ? Act.appConfig().locale() : template.__curLocale();
        return JodaTransformers.format((ReadableInstant)dateTime, DateTimeFormat.patternForStyle((String)"MM", (Locale)locale), locale, null);
    }

    @Transformer(requireTemplate=true)
    public static String longStyle(DateTime dateTime) {
        return JodaTransformers.longStyle(null, dateTime);
    }

    public static String longStyle(ITemplate template, DateTime dateTime) {
        Locale locale = null == template ? Act.appConfig().locale() : template.__curLocale();
        return JodaTransformers.format((ReadableInstant)dateTime, DateTimeFormat.patternForStyle((String)"LL", (Locale)locale), locale, null);
    }

    @Transformer(requireTemplate=true)
    public static String shortStyle(LocalDateTime dateTime) {
        return JodaTransformers.shortStyle(null, dateTime);
    }

    public static String shortStyle(ITemplate template, LocalDateTime dateTime) {
        Locale locale = null == template ? Act.appConfig().locale() : template.__curLocale();
        return JodaTransformers.format((ReadablePartial)dateTime, DateTimeFormat.patternForStyle((String)"SS", (Locale)locale), locale, null);
    }

    @Transformer(requireTemplate=true)
    public static String mediumStyle(LocalDateTime dateTime) {
        return JodaTransformers.mediumStyle(null, dateTime);
    }

    public static String mediumStyle(ITemplate template, LocalDateTime dateTime) {
        Locale locale = null == template ? Act.appConfig().locale() : template.__curLocale();
        return JodaTransformers.format((ReadablePartial)dateTime, DateTimeFormat.patternForStyle((String)"MM", (Locale)locale), locale, null);
    }

    @Transformer(requireTemplate=true)
    public static String longStyle(LocalDateTime dateTime) {
        return JodaTransformers.longStyle(null, dateTime);
    }

    public static String longStyle(ITemplate template, LocalDateTime dateTime) {
        Locale locale = null == template ? Act.appConfig().locale() : template.__curLocale();
        return JodaTransformers.format((ReadablePartial)dateTime, DateTimeFormat.patternForStyle((String)"LL", (Locale)locale), locale, null);
    }

    @Transformer(requireTemplate=true)
    public static String shortStyle(LocalDate LocalDate2) {
        return JodaTransformers.shortStyle(null, LocalDate2);
    }

    public static String shortStyle(ITemplate template, LocalDate LocalDate2) {
        Locale locale = null == template ? Act.appConfig().locale() : template.__curLocale();
        return JodaTransformers.format((ReadablePartial)LocalDate2, DateTimeFormat.patternForStyle((String)"S-", (Locale)locale), locale, null);
    }

    @Transformer(requireTemplate=true)
    public static String mediumStyle(LocalDate LocalDate2) {
        return JodaTransformers.mediumStyle(null, LocalDate2);
    }

    public static String mediumStyle(ITemplate template, LocalDate LocalDate2) {
        Locale locale = null == template ? Act.appConfig().locale() : template.__curLocale();
        return JodaTransformers.format((ReadablePartial)LocalDate2, DateTimeFormat.patternForStyle((String)"M-", (Locale)locale), locale, null);
    }

    @Transformer(requireTemplate=true)
    public static String longStyle(LocalDate LocalDate2) {
        return JodaTransformers.longStyle(null, LocalDate2);
    }

    public static String longStyle(ITemplate template, LocalDate LocalDate2) {
        Locale locale = null == template ? Act.appConfig().locale() : template.__curLocale();
        return JodaTransformers.format((ReadablePartial)LocalDate2, DateTimeFormat.patternForStyle((String)"L-", (Locale)locale), locale, null);
    }

    @Transformer(requireTemplate=true)
    public static String shortStyle(LocalTime LocalTime2) {
        return JodaTransformers.shortStyle(null, LocalTime2);
    }

    public static String shortStyle(ITemplate template, LocalTime LocalTime2) {
        Locale locale = null == template ? Act.appConfig().locale() : template.__curLocale();
        return JodaTransformers.format((ReadablePartial)LocalTime2, DateTimeFormat.patternForStyle((String)"-S", (Locale)locale), locale, null);
    }

    @Transformer(requireTemplate=true)
    public static String mediumStyle(LocalTime LocalTime2) {
        return JodaTransformers.mediumStyle(null, LocalTime2);
    }

    public static String mediumStyle(ITemplate template, LocalTime LocalTime2) {
        Locale locale = null == template ? Act.appConfig().locale() : template.__curLocale();
        return JodaTransformers.format((ReadablePartial)LocalTime2, DateTimeFormat.patternForStyle((String)"-M", (Locale)locale), locale, null);
    }

    @Transformer(requireTemplate=true)
    public static String longStyle(LocalTime LocalTime2) {
        return JodaTransformers.longStyle(null, LocalTime2);
    }

    public static String longStyle(ITemplate template, LocalTime LocalTime2) {
        Locale locale = null == template ? Act.appConfig().locale() : template.__curLocale();
        return JodaTransformers.format((ReadablePartial)LocalTime2, DateTimeFormat.patternForStyle((String)"-L", (Locale)locale), locale, null);
    }

    private static class Key {
        private DateTimeType type;
        private Locale locale;
        private String timezone;
        private String pattern;

        public Key(DateTimeType type, Locale locale, String timezone, String pattern) {
            this.type = type;
            this.locale = locale;
            this.timezone = timezone;
            this.pattern = pattern;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.type == key.type && Objects.equals(this.pattern, key.pattern) && Objects.equals(this.locale, key.locale) && Objects.equals(this.timezone, key.timezone);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.locale, this.timezone, this.pattern});
        }
    }
}

