/*
 * Decompiled with CFR 0.152.
 */
package act.ws;

import act.Act;
import act.crypto.AppCrypto;
import act.ws.SecureTicketCodec;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.Codec;
import org.osgl.util.S;
import org.osgl.util.Token;

public class StringSecureTicketCodec
extends SecureTicketCodec.Base<String> {
    public static final String MARKER = "stk:";
    private static final int MARKER_LEN = "stk:".length();
    private AppCrypto crypto;

    public StringSecureTicketCodec() {
        this(Act.crypto());
    }

    public StringSecureTicketCodec(Collection<String> keys) {
        this(Act.crypto(), keys);
    }

    public StringSecureTicketCodec(String ... keys) {
        this(Act.crypto(), keys);
    }

    public StringSecureTicketCodec(String keys) {
        this(Act.crypto(), keys);
    }

    public StringSecureTicketCodec(AppCrypto crypto) {
        this.crypto = (AppCrypto)$.requireNotNull((Object)crypto);
    }

    public StringSecureTicketCodec(AppCrypto crypto, Collection<String> keys) {
        super(keys);
        this.crypto = (AppCrypto)$.requireNotNull((Object)crypto);
    }

    public StringSecureTicketCodec(AppCrypto crypto, String ... keys) {
        super(keys);
        this.crypto = (AppCrypto)$.requireNotNull((Object)crypto);
    }

    public StringSecureTicketCodec(AppCrypto crypto, String keys) {
        super(keys);
        this.crypto = (AppCrypto)$.requireNotNull((Object)crypto);
    }

    @Override
    protected String serialize(String id, Map<String, String> payload) {
        String tk = this.crypto.generateToken(id, this.encode(payload));
        return S.concat((String)MARKER, (String)tk);
    }

    @Override
    protected String deserialize(String ticket, Map<String, String> payload) {
        Token token;
        if (ticket.startsWith(MARKER)) {
            ticket = ticket.substring(MARKER_LEN);
        }
        if ((token = this.crypto.parseToken(ticket)).notValid()) {
            return null;
        }
        List payloadList = token.payload();
        for (String item : payloadList) {
            Lang.T2<String, String> t2 = this.decode(item);
            payload.put((String)t2._1, Codec.decodeUrl((String)((String)t2._2)));
        }
        return token.id();
    }

    @Override
    public boolean probeTicket(Object ticket) {
        String s = ticket.toString();
        return s.startsWith(MARKER);
    }

    private String[] encode(Map<String, String> map) {
        int len = map.size();
        String[] sa = new String[len];
        int i = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sa[i++] = this.encode(entry);
        }
        return sa;
    }

    private String encode(Map.Entry<String, String> entry) {
        return S.concat((String)entry.getKey(), (String)"=", (String)Codec.encodeUrl((String)entry.getValue()));
    }

    private Lang.T2<String, String> decode(String payloadItem) {
        int pos = payloadItem.indexOf(61);
        if (pos < 0) {
            throw new IllegalArgumentException(S.concat((String)"Invalid payload item: ", (String)payloadItem));
        }
        return $.T2((Object)payloadItem.substring(0, pos), (Object)payloadItem.substring(pos + 1, payloadItem.length()));
    }
}

