/*
 * Decompiled with CFR 0.152.
 */
package act.ws;

import act.cli.Command;
import act.cli.Optional;
import act.ws.WebSocketConnectionManager;
import act.ws.WebSocketConnectionRegistry;
import javax.inject.Inject;
import org.osgl.util.S;

public class WebSocketAdminConsole {
    @Inject
    private WebSocketConnectionManager manager;

    @Command(name="act.ws.conn.by-user", help="report websocket connection number by user")
    public int userConnections(@Optional(value="specify user name") String username) {
        WebSocketConnectionRegistry registry = this.manager.usernameRegistry();
        return S.blank((String)username) ? registry.count() : registry.count(username);
    }

    @Command(name="act.ws.conn.by-tag", help="report websocket connection number by user")
    public int tagConnections(@Optional(value="specify the tag label") String label) {
        WebSocketConnectionRegistry registry = this.manager.tagRegistry();
        return S.blank((String)label) ? registry.count() : registry.count(label);
    }

    @Command(name="act.ws.conn.by-session", help="report websocket connection number by user")
    public int sessionConnections(@Optional(value="specify the session id") String sessionId) {
        WebSocketConnectionRegistry registry = this.manager.sessionRegistry();
        return S.blank((String)sessionId) ? registry.count() : registry.count(sessionId);
    }
}

