/*
 * Decompiled with CFR 0.152.
 */
package act.ws;

import act.app.ActionContext;
import act.app.App;
import act.app.AppServiceBase;
import act.util.Stateless;
import act.ws.WebSocketConnectionRegistry;
import act.xio.WebSocketConnection;
import com.alibaba.fastjson.JSON;
import java.util.Collection;
import org.osgl.Lang;
import org.osgl.http.H;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;

@Stateless
public class WebSocketConnectionManager
extends AppServiceBase<WebSocketConnectionManager> {
    private static final Logger logger = LogManager.get(WebSocketConnectionManager.class);
    private final WebSocketConnectionRegistry bySessionId = new WebSocketConnectionRegistry();
    private final WebSocketConnectionRegistry byUsername = new WebSocketConnectionRegistry();
    private final WebSocketConnectionRegistry byUrl = new WebSocketConnectionRegistry();
    private final WebSocketConnectionRegistry byTag = new WebSocketConnectionRegistry();
    private String wsTicketKey;

    public WebSocketConnectionManager(App app) {
        super(app);
        this.wsTicketKey = app.config().wsTicketKey();
    }

    public WebSocketConnectionRegistry sessionRegistry() {
        return this.bySessionId;
    }

    public WebSocketConnectionRegistry usernameRegistry() {
        return this.byUsername;
    }

    public WebSocketConnectionRegistry urlRegistry() {
        return this.byUrl;
    }

    public WebSocketConnectionRegistry tagRegistry() {
        return this.byTag;
    }

    public void subscribe(H.Session session, final String tag) {
        this.sessionRegistry().accept(session.id(), (Lang.Function<WebSocketConnection, ?>)new Lang.Visitor<WebSocketConnection>(){

            public void visit(WebSocketConnection connection) throws Lang.Break {
                WebSocketConnectionManager.this.byTag.register(tag, connection);
            }
        });
    }

    public void sendToUrl(String message, String url) {
        this.sendToConnections(message, this.urlRegistry(), url);
    }

    public void sendJsonToUrl(Object data, String url) {
        this.sendToUrl(JSON.toJSONString((Object)data), url);
    }

    public void sendToTagged(String message, String label) {
        this.sendToConnections(message, this.tagRegistry(), label);
    }

    public void sendToTagged(String message, String ... labels) {
        for (String label : labels) {
            this.sendToTagged(message, label);
        }
    }

    public void sendToTagged(String message, Collection<String> labels) {
        for (String label : labels) {
            this.sendToTagged(message, label);
        }
    }

    public void sendJsonToTagged(Object data, String label) {
        this.sendToTagged(JSON.toJSONString((Object)data), label);
    }

    public void sendJsonToTagged(Object data, String ... labels) {
        for (String label : labels) {
            this.sendJsonToTagged(data, label);
        }
    }

    public void sendJsonToTagged(Object data, Collection<String> labels) {
        for (String label : labels) {
            this.sendJsonToTagged(data, label);
        }
    }

    public void sendToUser(String message, String username) {
        this.sendToConnections(message, this.usernameRegistry(), username);
    }

    public void sendJsonToUser(Object data, String username) {
        this.sendToUser(JSON.toJSONString((Object)data), username);
    }

    public void registerNewConnection(WebSocketConnection connection, ActionContext context) {
        this.bySessionId.register(context.session().id(), connection);
        String username = context.username();
        if (null == username) {
            username = context.paramVal(this.wsTicketKey);
        }
        if (null != username) {
            this.byUsername.register(username, connection);
        }
        String url = context.req().url();
        this.byUrl.register(url, connection);
    }

    @Override
    protected void releaseResources() {
        this.bySessionId.destroy();
        this.byUsername.destroy();
        this.byUrl.destroy();
        this.byTag.destroy();
    }

    private void sendToConnections(String message, WebSocketConnectionRegistry registry, String key) {
        for (WebSocketConnection conn : registry.get(key)) {
            if (logger.isTraceEnabled()) {
                logger.trace("send to websocket connection by key: %s", new Object[]{key});
            }
            conn.send(message);
        }
    }
}

