/*
 * Decompiled with CFR 0.152.
 */
package act.xio;

import act.Act;
import act.app.ActionContext;
import act.app.App;
import act.app.event.SysEventId;
import act.app.util.NamedPort;
import act.event.EventBus;
import act.handler.RequestHandler;
import act.handler.builtin.AlwaysNotFound;
import act.handler.builtin.FileGetter;
import act.handler.builtin.ResourceGetter;
import act.handler.builtin.controller.FastRequestHandler;
import act.handler.builtin.controller.RequestHandlerProxy;
import act.handler.event.PostHandle;
import act.handler.event.PreHandle;
import act.metric.Metric;
import act.metric.Timer;
import act.route.Router;
import act.util.DestroyableBase;
import act.view.ActErrorResult;
import act.xio.NetworkDispatcher;
import act.xio.NetworkJob;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.http.H;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.mvc.result.ErrorResult;
import org.osgl.mvc.result.NotFound;
import org.osgl.mvc.result.Result;
import org.osgl.util.E;
import org.osgl.util.S;

public class NetworkHandler
extends DestroyableBase {
    private static Logger logger = LogManager.get(NetworkHandler.class);
    private final App app;
    private NamedPort port;
    private Metric metric;
    private Lang.Func2<H.Request, String, String> contentSuffixProcessor;
    private Lang.Func2<H.Request, String, String> urlContextProcessor;
    private static Lang.Func2<H.Request, String, String> DUMB_CONTENT_SUFFIX_SENSOR = new Lang.Func2<H.Request, String, String>(){

        public String apply(H.Request request, String s) throws NotAppliedException, Lang.Break {
            return s;
        }
    };

    public NetworkHandler(App app) {
        E.NPE((Object)app);
        this.app = app;
        this.metric = Act.metricPlugin().metric("act.http");
        this.initUrlProcessors();
        app.registerHotReloadListener(new App.HotReloadListener(){

            @Override
            public void preHotReload() {
                NetworkHandler.this.initUrlProcessors();
            }
        });
    }

    private void initUrlProcessors() {
        this.contentSuffixProcessor = this.app.config().contentSuffixAware() != false ? new ContentSuffixSensor() : DUMB_CONTENT_SUFFIX_SENSOR;
        String urlContext = this.app.config().urlContext();
        this.urlContextProcessor = null != urlContext ? new UrlContextProcessor(urlContext) : DUMB_CONTENT_SUFFIX_SENSOR;
    }

    public NetworkHandler(App app, NamedPort port) {
        this(app);
        this.port = port;
    }

    public App app() {
        return this.app;
    }

    public void handle(final ActionContext ctx, final NetworkDispatcher dispatcher) {
        boolean resourceGetter;
        if (this.isDestroyed()) {
            return;
        }
        Exception refreshError = null;
        if (Act.isDev()) {
            try {
                boolean updated = this.app.checkUpdates(false);
                if (updated && !this.app.hasBlockIssue()) {
                    this.app.jobManager().on(SysEventId.POST_START, new Runnable(){

                        @Override
                        public void run() {
                            NetworkHandler.this.handle(ctx, dispatcher);
                        }
                    }, true);
                    dispatcher.keep();
                    return;
                }
            }
            catch (Exception e) {
                refreshError = e;
            }
        }
        final H.Request req = ctx.req();
        String url = req.url();
        H.Method method = req.method();
        url = (String)this.contentSuffixProcessor.apply((Object)req, (Object)url);
        try {
            url = (String)this.urlContextProcessor.apply((Object)req, (Object)url);
        }
        catch (NotFound notFound) {
            ctx.handler(AlwaysNotFound.INSTANCE);
            ctx.saveLocal();
            AlwaysNotFound.INSTANCE.apply(ctx);
            return;
        }
        Timer timer = this.metric.startTimer("act:routing");
        final RequestHandler requestHandler = this.router().getInvoker(method, url, ctx);
        ctx.handler(requestHandler);
        timer.stop();
        boolean bl = resourceGetter = requestHandler instanceof ResourceGetter || requestHandler instanceof FileGetter;
        if (null != refreshError && !resourceGetter) {
            ctx.saveLocal();
            this.handleException(refreshError, ctx, "Error refreshing app");
            ActionContext.clearCurrent();
            return;
        }
        NetworkJob job = new NetworkJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Timer timer = Metric.NULL_METRIC.startTimer("null");
                if (NetworkHandler.this.metric != Metric.NULL_METRIC) {
                    String key = S.concat((String)"act:http", (String)":", (String)requestHandler.toString());
                    timer = NetworkHandler.this.metric.startTimer(key);
                }
                ctx.saveLocal();
                EventBus eventBus = NetworkHandler.this.app.eventBus();
                try {
                    eventBus.emit(new PreHandle(ctx), new Object[0]);
                    requestHandler.handle(ctx);
                }
                catch (Result r) {
                    H.Format fmt;
                    if (NetworkHandler.this.isError(r)) {
                        ctx.handler(FastRequestHandler.DUMB);
                    }
                    try {
                        r = RequestHandlerProxy.GLOBAL_AFTER_INTERCEPTOR.apply(r, ctx);
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e, "Error calling global after interceptor");
                        r = ActErrorResult.of(e);
                    }
                    if (null == ctx.handler() || NetworkHandler.this.isError(r)) {
                        ctx.handler(FastRequestHandler.DUMB);
                    }
                    if (H.Format.UNKNOWN == (fmt = req.accept())) {
                        fmt = req.contentType();
                    }
                    ctx.prepareRespForWrite().addHeaderIfNotAdded("Content-Type", fmt.contentType());
                    r.apply(req, ctx.prepareRespForWrite());
                }
                catch (IllegalStateException e) {
                    if (!S.is((Object)e.getMessage()).contains((CharSequence)"UT000002: The response has already been started")) {
                        NetworkHandler.this.handleException(e, ctx, "Error handling network request");
                    }
                }
                catch (Exception e) {
                    NetworkHandler.this.handleException(e, ctx, "Error handling network request");
                }
                finally {
                    eventBus.emit(new PostHandle(ctx), new Object[0]);
                    ActionContext.clearCurrent();
                    timer.stop();
                }
            }
        };
        if (method.unsafe() || !requestHandler.express(ctx)) {
            dispatcher.dispatch(job);
        } else {
            job.run();
        }
    }

    private boolean isError(Result r) {
        return r instanceof ErrorResult;
    }

    private void handleException(Exception exception, ActionContext ctx, String errorMessage) {
        Result r;
        logger.error((Throwable)exception, errorMessage);
        try {
            r = RequestHandlerProxy.GLOBAL_EXCEPTION_INTERCEPTOR.apply(exception, ctx);
        }
        catch (Exception e) {
            logger.error((Throwable)e, "Error calling global exception interceptor");
            r = ActErrorResult.of(e);
        }
        if (null == r) {
            r = ActErrorResult.of(exception);
        } else if (r instanceof ErrorResult) {
            r = ActErrorResult.of(r);
        }
        if (null == ctx.handler()) {
            ctx.handler(FastRequestHandler.DUMB);
        }
        r.apply(ctx.req(), ctx.prepareRespForWrite());
    }

    public String toString() {
        return this.app().name();
    }

    private Router router() {
        return this.app.router(this.port);
    }

    static class ContentSuffixSensor
    implements Lang.Func2<H.Request, String, String> {
        private static final char[] mp3 = new char[]{'m', 'p'};
        private static final char[] mp4 = new char[]{'m', 'p'};
        private static final char[] mpa = new char[]{'m', 'p'};
        private static final char[] pdf = new char[]{'p'};
        private static final char[] gif = new char[0];
        private static final char[] tif = new char[0];
        private static final char[] png = new char[]{'p'};
        private static final char[] jpg = new char[0];
        private static final char[] mpg = new char[0];
        private static final char[] svg = new char[]{'s'};
        private static final char[] avi = new char[]{'a', 'v'};
        private static final char[] xml = new char[]{'x', 'm'};
        private static final char[] json = new char[]{'j', 's', 'o'};
        private static final char[] ico = new char[]{'i', 'c'};
        private static final char[] bmp = new char[]{'b', 'm'};
        private static final char[] xls = new char[]{'x', 'l'};
        private static final char[] wav = new char[]{'w'};
        private static final char[] flv = new char[]{'f'};
        private static final char[] csv = new char[]{'c'};
        private static final char[] mov = new char[]{'m'};
        private static final char[] xlsx = new char[]{'x', 'l', 's'};

        ContentSuffixSensor() {
        }

        public String apply(H.Request req, String url) throws NotAppliedException, Lang.Break {
            Lang.Var fmtBag = $.var();
            String processedUrl = ContentSuffixSensor.process(url, (Lang.Var<H.Format>)fmtBag);
            H.Format fmt = (H.Format)fmtBag.get();
            if (null != fmt) {
                req.accept(fmt);
            }
            return processedUrl;
        }

        static String process(String url, Lang.Var<H.Format> fmtBag) {
            char[] trait;
            int sz = url.length();
            if (sz < 4) {
                return url;
            }
            int start = sz - 1;
            char c = url.charAt(start);
            int initPos = 1;
            int sepPos = 3;
            H.Format fmt = H.Format.JSON;
            block0 : switch (c) {
                case '3': {
                    trait = mp3;
                    break;
                }
                case '4': {
                    trait = mp4;
                    break;
                }
                case 'a': {
                    trait = mpa;
                    break;
                }
                case 'f': {
                    c = url.charAt(start - 1);
                    initPos = 2;
                    switch (c) {
                        case 'd': {
                            trait = pdf;
                            fmt = H.Format.PDF;
                            break block0;
                        }
                        case 'i': {
                            c = url.charAt(start - 2);
                            initPos = 3;
                            switch (c) {
                                case 'g': {
                                    trait = gif;
                                    fmt = H.Format.GIF;
                                    break block0;
                                }
                                case 't': {
                                    trait = tif;
                                    fmt = H.Format.TIF;
                                    break block0;
                                }
                            }
                            return url;
                        }
                    }
                    return url;
                }
                case 'g': {
                    c = url.charAt(start - 1);
                    initPos = 2;
                    switch (c) {
                        case 'n': {
                            trait = png;
                            fmt = H.Format.PNG;
                            break block0;
                        }
                        case 'p': {
                            c = url.charAt(start - 2);
                            initPos = 3;
                            switch (c) {
                                case 'j': {
                                    trait = jpg;
                                    fmt = H.Format.JPG;
                                    break block0;
                                }
                                case 'm': {
                                    trait = mpg;
                                    fmt = H.Format.MPG;
                                    break block0;
                                }
                            }
                            return url;
                        }
                        case 'v': {
                            trait = svg;
                            fmt = H.Format.SVG;
                            break block0;
                        }
                    }
                    return url;
                }
                case 'i': {
                    trait = avi;
                    fmt = H.Format.AVI;
                    break;
                }
                case 'l': {
                    trait = xml;
                    fmt = H.Format.XML;
                    break;
                }
                case 'n': {
                    sepPos = 4;
                    trait = json;
                    break;
                }
                case 'o': {
                    trait = ico;
                    fmt = H.Format.ICO;
                    break;
                }
                case 'p': {
                    trait = bmp;
                    fmt = H.Format.BMP;
                    break;
                }
                case 's': {
                    trait = xls;
                    fmt = H.Format.XLS;
                    break;
                }
                case 'v': {
                    c = url.charAt(start - 1);
                    initPos = 2;
                    switch (c) {
                        case 'a': {
                            trait = wav;
                            fmt = H.Format.WAV;
                            break block0;
                        }
                        case 'l': {
                            trait = flv;
                            fmt = H.Format.FLV;
                            break block0;
                        }
                        case 's': {
                            trait = csv;
                            fmt = H.Format.CSV;
                            break block0;
                        }
                        case 'o': {
                            trait = mov;
                            fmt = H.Format.MOV;
                            break block0;
                        }
                    }
                    return url;
                }
                case 'x': {
                    sepPos = 4;
                    trait = xlsx;
                    fmt = H.Format.XLSX;
                    break;
                }
                default: {
                    return url;
                }
            }
            char sep = url.charAt(start - sepPos);
            if (sep != '/') {
                return url;
            }
            for (int i = initPos; i < sepPos; ++i) {
                if (url.charAt(start - i) == trait[sepPos - i - 1]) continue;
                return url;
            }
            fmtBag.set((Object)fmt);
            return url.substring(0, sz - sepPos - 1);
        }
    }

    static class UrlContextProcessor
    implements Lang.Func2<H.Request, String, String> {
        private String context;
        private int contextLen;

        UrlContextProcessor(String context) {
            this.context = context;
            this.contextLen = context.length();
        }

        public String apply(H.Request request, String s) throws NotAppliedException, Lang.Break {
            if (s.startsWith("/~/")) {
                return s;
            }
            if (s.length() < this.contextLen || !s.startsWith(this.context)) {
                throw NotFound.get();
            }
            return s.substring(this.contextLen, s.length());
        }
    }
}

