/*
 * Decompiled with CFR 0.152.
 */
package act.xio.undertow;

import act.Act;
import act.controller.meta.ActionMethodMetaInfo;
import act.ws.WebSocketConnectionManager;
import act.xio.NetworkBase;
import act.xio.NetworkHandler;
import act.xio.WebSocketConnectionHandler;
import act.xio.undertow.ActHttpHandler;
import act.xio.undertow.UndertowWebSocketConnectionHandler;
import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.HttpHandler;
import io.undertow.server.protocol.http.HttpOpenListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;

public class UndertowNetwork
extends NetworkBase {
    private static final Logger logger = LogManager.get(UndertowNetwork.class);
    private Xnio xnio;
    private int ioThreads;
    private XnioWorker worker;
    private OptionMap socketOptions;
    private OptionMap serverOptions;
    private List<AcceptingChannel<? extends StreamConnection>> channels;
    private static final char[] STORE_PASSWORD = "password".toCharArray();

    @Override
    protected void bootUp() {
        try {
            this.xnio = Xnio.getInstance((ClassLoader)UndertowNetwork.class.getClassLoader());
            this.worker = this.createWorker();
            this.socketOptions = this.createSocketOptions();
            this.serverOptions = OptionMap.builder().set(UndertowOptions.BUFFER_PIPELINED_DATA, true).set(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, false).set(UndertowOptions.ALWAYS_SET_DATE, true).set(UndertowOptions.RECORD_REQUEST_START_TIME, false).set(UndertowOptions.NO_REQUEST_TIMEOUT, 60000).set(UndertowOptions.ENABLE_STATISTICS, Act.conf().xioStatistics()).getMap();
            this.channels = new ArrayList<AcceptingChannel<? extends StreamConnection>>();
        }
        catch (Exception e) {
            throw E.unexpected((Throwable)e, (String)"Error booting up Undertow service: %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    @Override
    protected void setUpClient(NetworkHandler client, int port, boolean secure) throws IOException {
        ActHttpHandler handler = new ActHttpHandler(client);
        DefaultByteBufferPool buffers = new DefaultByteBufferPool(true, 16384, -1, 4);
        HttpOpenListener openListener = new HttpOpenListener((ByteBufferPool)buffers, this.serverOptions);
        openListener.setRootHandler((HttpHandler)handler);
        ChannelListener acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)openListener);
        if (!secure) {
            AcceptingChannel server = this.worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(port), acceptListener, this.socketOptions);
            server.resumeAccepts();
            this.channels.add((AcceptingChannel<? extends StreamConnection>)server);
        } else {
            try {
                SSLContext sslContext = UndertowNetwork.createSSLContext(UndertowNetwork.loadKeyStore("server.keystore"), UndertowNetwork.loadKeyStore("server.truststore"));
                UndertowXnioSsl xnioSsl = new UndertowXnioSsl(this.xnio, OptionMap.create((Option)Options.USE_DIRECT_BUFFERS, (Object)true), sslContext);
                AcceptingChannel sslServer = xnioSsl.createSslConnectionServer(this.worker, new InetSocketAddress(port), acceptListener, this.socketOptions);
                sslServer.resumeAccepts();
                this.channels.add((AcceptingChannel<? extends StreamConnection>)sslServer);
            }
            catch (Exception e) {
                throw E.unexpected((Throwable)e);
            }
        }
    }

    @Override
    protected WebSocketConnectionHandler internalCreateWsConnHandler(ActionMethodMetaInfo methodInfo, WebSocketConnectionManager manager) {
        return new UndertowWebSocketConnectionHandler(methodInfo, manager);
    }

    @Override
    protected void close() {
        if (null == this.channels) {
            return;
        }
        for (AcceptingChannel<? extends StreamConnection> channel : this.channels) {
            IO.close(channel);
        }
        this.channels.clear();
        this.worker.shutdownNow();
    }

    private XnioWorker createWorker() throws IOException {
        this.ioThreads = Act.isDev() ? 2 : Runtime.getRuntime().availableProcessors() * 2;
        int workerThreads = Act.isDev() ? 4 : this.ioThreads * 8;
        int maxWorkerThreads = Act.conf().xioMaxWorkerThreads();
        if (maxWorkerThreads > 0) {
            workerThreads = Math.min(maxWorkerThreads, workerThreads);
        }
        return this.xnio.createWorker(OptionMap.builder().set(Options.WORKER_IO_THREADS, this.ioThreads).set(Options.WORKER_TASK_CORE_THREADS, workerThreads).set(Options.WORKER_TASK_MAX_THREADS, workerThreads).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.TCP_NODELAY, true).set(Options.CORK, true).getMap());
    }

    private OptionMap createSocketOptions() {
        OptionMap socketOptions = OptionMap.builder().set(Options.WORKER_IO_THREADS, this.ioThreads).set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true).set(Options.BALANCING_TOKENS, 1).set(Options.BALANCING_CONNECTIONS, 2).set(Options.BACKLOG, 10000).getMap();
        return socketOptions;
    }

    private static SSLContext createSSLContext(KeyStore keyStore, KeyStore trustStore) throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, UndertowNetwork.password("key"));
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyStore loadKeyStore(String name) {
        InputStream stream;
        String storeLoc = System.getProperty(name);
        if (storeLoc == null) {
            stream = UndertowNetwork.class.getResourceAsStream(name);
        } else {
            try {
                stream = Files.newInputStream(Paths.get(storeLoc, new String[0]), new OpenOption[0]);
            }
            catch (IOException e) {
                throw E.ioException((IOException)e);
            }
        }
        if (stream == null) {
            throw new RuntimeException("Could not load keystore");
        }
        try (InputStream is = stream;){
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(is, UndertowNetwork.password(name));
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
        catch (Exception e) {
            throw E.unexpected((Throwable)e);
        }
    }

    static char[] password(String name) {
        String pw = System.getProperty(name + ".password");
        return pw != null ? pw.toCharArray() : STORE_PASSWORD;
    }
}

