/*
 * Decompiled with CFR 0.152.
 */
package act.xio.undertow;

import act.Act;
import act.util.DestroyableBase;
import act.xio.WebSocketConnection;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import org.osgl.$;
import org.osgl.http.H;

public class UndertowWebSocketConnection
extends DestroyableBase
implements WebSocketConnection {
    private final WebSocketChannel channel;
    private final String sessionId;
    private final String username;

    public UndertowWebSocketConnection(WebSocketChannel channel, H.Session session) {
        this.channel = (WebSocketChannel)$.requireNotNull((Object)channel);
        this.sessionId = session.id();
        this.username = session.get(Act.appConfig().sessionKeyUsername());
    }

    @Override
    public String sessionId() {
        return this.sessionId;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public void send(String message) {
        WebSockets.sendText((String)message, (WebSocketChannel)this.channel, null);
    }

    @Override
    protected void releaseResources() {
        try {
            this.channel.sendClose();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        this.destroy();
    }

    @Override
    public boolean closed() {
        return this.isDestroyed();
    }
}

