/*
 * Decompiled with CFR 0.152.
 */
package ascii;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import net.sf.image4j.codec.ico.ICODecoder;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.E;
import org.osgl.util.IO;

public class Image2ascii {
    private static final int MAX_WIDTH = 80;
    private int[] statsArray = new int[12];
    char[] convRefArray = new char[]{' ', '~', '-', ':', '+', '%', '=', 'W', '@', '$', '#', '\u2586'};
    char[] imgArray;
    private long dStart;
    private long dEnd;

    public String convert(BufferedImage image, boolean favicon) {
        this.statsArray = new int[12];
        this.dStart = System.nanoTime();
        image = Image2ascii.scale(image, favicon);
        StringBuilder sb = new StringBuilder((image.getWidth() + 1) * image.getHeight());
        for (int y = 0; y < image.getHeight(); ++y) {
            if (sb.length() != 0) {
                sb.append("\n");
            }
            for (int x = 0; x < image.getWidth(); ++x) {
                Color pixelColor = new Color(image.getRGB(x, y), true);
                int alpha = pixelColor.getAlpha();
                boolean isTransient = (double)alpha < 0.1;
                double gValue = isTransient ? 250.0 : ((double)pixelColor.getRed() * 0.2989 + (double)pixelColor.getBlue() * 0.587 + (double)pixelColor.getGreen() * 0.114) / ((double)alpha / 250.0);
                char s = gValue < 130.0 ? this.darkGrayScaleMap(gValue) : this.lightGrayScaleMap(gValue);
                sb.append(s);
            }
        }
        this.imgArray = sb.toString().toCharArray();
        this.dEnd = System.nanoTime();
        return sb.toString();
    }

    private static BufferedImage scale(BufferedImage imageToScale, int dWidth, int dHeight, double fWidth, double fHeight) {
        BufferedImage dbi = null;
        int imageType = imageToScale.getType();
        if (imageToScale != null) {
            dbi = new BufferedImage(dWidth, dHeight, imageType);
            Graphics2D g = dbi.createGraphics();
            AffineTransform at = AffineTransform.getScaleInstance(fWidth, fHeight);
            g.drawRenderedImage(imageToScale, at);
        }
        return dbi;
    }

    private char darkGrayScaleMap(double g) {
        int str = g >= 120.0 ? 61 : (g >= 100.0 ? 87 : (g >= 80.0 ? 64 : (g >= 70.0 ? 36 : (g >= 30.0 ? 35 : (g >= 12.0 ? 9619 : 182)))));
        return (char)str;
    }

    private char lightGrayScaleMap(double g) {
        int str = g >= 240.0 ? 32 : (g >= 220.0 ? 126 : (g >= 200.0 ? 45 : (g >= 180.0 ? 58 : (g >= 160.0 ? 43 : 37))));
        return (char)str;
    }

    private static BufferedImage scale(BufferedImage original, boolean favicon) {
        Lang.T3<Integer, Integer, Double> params = Image2ascii.calcScaleParams(original, favicon);
        return Image2ascii.scale(original, (Integer)params._1, (Integer)params._2 / 2, (Double)params._3, (Double)params._3 / 2.0);
    }

    private static Lang.T3<Integer, Integer, Double> calcScaleParams(BufferedImage original, boolean favicon) {
        int max;
        int width = original.getWidth();
        int height = original.getHeight();
        int n = max = favicon ? 16 : 80;
        if (width <= max) {
            return $.T3((Object)width, (Object)height, (Object)1.0);
        }
        double factor = (double)max / (double)width;
        return $.T3((Object)max, (Object)((int)((double)height * factor)), (Object)factor);
    }

    public static String render(File imageSource, boolean favicon) {
        try {
            URL url = imageSource.toURI().toURL();
            boolean isIcon = imageSource.getName().endsWith(".ico");
            return Image2ascii.render(url, favicon, isIcon);
        }
        catch (MalformedURLException e) {
            throw E.unexpected((Throwable)e);
        }
    }

    public static String render(URL imageSource, boolean iconFile) {
        return Image2ascii.render(imageSource, false, iconFile);
    }

    public static String render(URL imageSource, boolean favicon, boolean iconFile) {
        try {
            BufferedImage image = Image2ascii.read(imageSource, iconFile);
            return new Image2ascii().convert(image, favicon);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static BufferedImage read(URL imageSource, boolean isIcon) throws Exception {
        if (isIcon) {
            List images = ICODecoder.read((InputStream)imageSource.openStream());
            return (BufferedImage)images.get(0);
        }
        return ImageIO.read(imageSource);
    }

    public static void main(String[] args) throws Exception {
        Image2ascii convert = new Image2ascii();
        List images = ICODecoder.read((File)new File("/home/luog/favicon.ico"));
        String s = convert.convert((BufferedImage)images.get(0), true);
        if (images.size() > 0) {
            for (int i = 0; i < images.size(); ++i) {
                ImageIO.write((RenderedImage)images.get(i), "png", new File("/home/luog/f" + i + ".png"));
            }
        }
        IO.writeContent((CharSequence)s, (File)new File("/home/luog/a.txt"));
    }
}

