package jadex.extension.envsupport.environment;

import jadex.bridge.service.types.cms.IComponentDescription;
import jadex.commons.IPropertyObject;

/**
 *  Interface for percept processors.
 *  A percept processor is responsible to process the
 *  percepts generated by percept generators and feed the
 *  percept into the component (e.g. into its beliefs).
 */
public interface IPerceptProcessor extends IPropertyObject
{
	/**
	 *  Process a new percept.
	 *  @param space The space.
	 *  @param type The type.
	 *  @param percept The percept.
	 *  @param component The component identifier.
	 *  @param component The avatar of the component (if any).
	 */
	public void processPercept(IEnvironmentSpace space, String type, Object percept, IComponentDescription component, ISpaceObject avatar);
}
