/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.environment;

import jadex.bridge.BasicComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.component.IMonitoringComponentFeature;
import jadex.bridge.modelinfo.SubcomponentTypeInfo;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.CMSComponentDescription;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.ICMSComponentListener;
import jadex.bridge.service.types.cms.IComponentDescription;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.bridge.service.types.monitoring.IMonitoringEvent;
import jadex.bridge.service.types.monitoring.IMonitoringService;
import jadex.commons.IFilter;
import jadex.commons.IPropertyObject;
import jadex.commons.IValueFetcher;
import jadex.commons.collection.MultiCollection;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateFutureCommandResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.meta.IPropertyMetaDataSet;
import jadex.extension.envsupport.IObjectCreator;
import jadex.extension.envsupport.MEnvSpaceInstance;
import jadex.extension.envsupport.MEnvSpaceType;
import jadex.extension.envsupport.MObjectType;
import jadex.extension.envsupport.MObjectTypeProperty;
import jadex.extension.envsupport.dataview.IDataView;
import jadex.extension.envsupport.environment.AvatarMapping;
import jadex.extension.envsupport.environment.ComponentActionList;
import jadex.extension.envsupport.environment.EnvironmentEvent;
import jadex.extension.envsupport.environment.IEnvironmentListener;
import jadex.extension.envsupport.environment.IEnvironmentSpace;
import jadex.extension.envsupport.environment.IObjectTask;
import jadex.extension.envsupport.environment.IPerceptGenerator;
import jadex.extension.envsupport.environment.IPerceptProcessor;
import jadex.extension.envsupport.environment.ISpaceAction;
import jadex.extension.envsupport.environment.ISpaceExecutor;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.environment.ISpaceProcess;
import jadex.extension.envsupport.environment.PerceptList;
import jadex.extension.envsupport.environment.PerceptType;
import jadex.extension.envsupport.environment.SpaceObject;
import jadex.extension.envsupport.environment.SynchronizedPropertyObject;
import jadex.extension.envsupport.environment.space2d.Space2D;
import jadex.extension.envsupport.environment.space3d.Space3D;
import jadex.extension.envsupport.evaluation.DefaultDataProvider;
import jadex.extension.envsupport.evaluation.IObjectSource;
import jadex.extension.envsupport.evaluation.ITableDataConsumer;
import jadex.extension.envsupport.evaluation.ITableDataProvider;
import jadex.extension.envsupport.evaluation.SpaceObjectSource;
import jadex.extension.envsupport.math.Vector2Double;
import jadex.extension.envsupport.math.Vector3Double;
import jadex.extension.envsupport.observer.gui.IObserverCenter;
import jadex.extension.envsupport.observer.gui.ObserverCenter;
import jadex.extension.envsupport.observer.perspective.IPerspective;
import jadex.javaparser.IParsedExpression;
import jadex.javaparser.SimpleValueFetcher;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public abstract class AbstractEnvironmentSpace
extends SynchronizedPropertyObject
implements IEnvironmentSpace {
    protected IExternalAccess exta;
    protected Map objecttypes;
    protected Map objecttypesMeta;
    protected Map tasktypes;
    protected Map processtypes;
    protected Map percepttypes;
    protected Map actions;
    protected Map perceptgenerators;
    protected MultiCollection<String, Object[]> perceptprocessors;
    protected MultiCollection<String, AvatarMapping> avatarmappings;
    protected Map initialavatars;
    protected MultiCollection<String, Map> dataviewmappings;
    protected Map processes;
    protected Map spaceobjects;
    protected Map spaceobjectsbytype;
    protected Map spaceobjectsbyowner;
    protected AtomicCounter objectidcounter;
    protected AtomicCounter taskidcounter;
    protected ComponentActionList actionlist;
    protected PerceptList perceptlist;
    protected Map views = new HashMap();
    protected List listeners;
    protected SimpleValueFetcher fetcher;
    protected Map dataproviders;
    protected Map dataconsumers;
    protected Map zombieobjects;
    protected List observercenters;
    protected ClassLoader classloader;
    protected IInternalAccess ia;
    protected MEnvSpaceInstance config;
    protected IValueFetcher pfetcher;

    public AbstractEnvironmentSpace() {
        super(null, new Object());
        this.avatarmappings = new MultiCollection();
        this.dataviewmappings = new MultiCollection();
        this.actions = new HashMap();
        this.processtypes = new HashMap();
        this.tasktypes = new HashMap();
        this.processes = new HashMap();
        this.percepttypes = new HashMap();
        this.perceptgenerators = new HashMap();
        this.perceptprocessors = new MultiCollection();
        this.objecttypes = new HashMap();
        this.objecttypesMeta = new HashMap();
        this.spaceobjects = new HashMap();
        this.zombieobjects = new HashMap();
        this.spaceobjectsbytype = new HashMap();
        this.spaceobjectsbyowner = new HashMap();
        this.objectidcounter = new AtomicCounter();
        this.taskidcounter = new AtomicCounter();
        this.actionlist = new ComponentActionList(this);
        this.perceptlist = new PerceptList(this);
        this.dataproviders = new HashMap();
        this.dataconsumers = new HashMap();
        this.observercenters = new ArrayList();
    }

    public void setInitData(IInternalAccess ia, MEnvSpaceInstance config, IValueFetcher pfetcher) {
        this.ia = ia;
        this.config = config;
        this.pfetcher = pfetcher;
    }

    public IFuture<Void> initSpace() {
        final Future ret = new Future();
        try {
            List sourceviews;
            List<Object> actions;
            List<Object> procs;
            List<Object> avatars;
            Map props;
            List<Object> objects;
            List pmaps;
            List gens;
            List tasktypes;
            List processtypes;
            List props2;
            List spaceactions;
            List percepttypes;
            List avmappings;
            List objecttypes;
            Double height;
            Double width;
            this.classloader = this.ia.getClassLoader();
            final MEnvSpaceType mspacetype = this.config.getType();
            final SimpleValueFetcher fetcher = new SimpleValueFetcher(this.pfetcher);
            fetcher.setValue("$space", (Object)this);
            this.setFetcher(fetcher);
            List mspaceprops = mspacetype.getPropertyList("properties");
            MEnvSpaceType.setProperties(this, mspaceprops, (IValueFetcher)fetcher);
            List<Object> spaceprops = this.config.getPropertyList("properties");
            MEnvSpaceType.setProperties(this, spaceprops, (IValueFetcher)fetcher);
            this.exta = this.ia.getExternalAccess();
            if (this instanceof Space2D) {
                width = this.config.getProperty("width") != null ? (Double)this.config.getProperty("width") : (Double)mspacetype.getProperty("width");
                height = this.config.getProperty("height") != null ? (Double)this.config.getProperty("height") : (Double)mspacetype.getProperty("height");
                ((Space2D)this).setAreaSize(Vector2Double.getVector2(width, height));
            }
            if (this instanceof Space3D) {
                width = this.config.getProperty("width") != null ? (Double)this.config.getProperty("width") : (Double)mspacetype.getProperty("width");
                height = this.config.getProperty("height") != null ? (Double)this.config.getProperty("height") : (Double)mspacetype.getProperty("height");
                Double depth = this.config.getProperty("depth") != null ? (Double)this.config.getProperty("depth") : (Double)mspacetype.getProperty("depth");
                ((Space3D)this).setAreaSize(Vector3Double.getVector3(width, depth, height));
            }
            if ((objecttypes = mspacetype.getPropertyList("objecttypes")) != null) {
                for (int i = 0; i < objecttypes.size(); ++i) {
                    MObjectType mobjecttype = (MObjectType)objecttypes.get(i);
                    this.addSpaceObjectType(mobjecttype.getName(), mobjecttype);
                }
            }
            if ((avmappings = mspacetype.getPropertyList("avatarmappings")) != null) {
                for (int i = 0; i < avmappings.size(); ++i) {
                    AvatarMapping mapping = (AvatarMapping)avmappings.get(i);
                    this.addAvatarMappings(mapping);
                }
            }
            if ((percepttypes = mspacetype.getPropertyList("percepttypes")) != null) {
                for (int i = 0; i < percepttypes.size(); ++i) {
                    Map mpercepttype = (Map)percepttypes.get(i);
                    PerceptType pt = new PerceptType();
                    pt.setName((String)MEnvSpaceType.getProperty(mpercepttype, "name"));
                    List atypes = (List)mpercepttype.get("componenttypes");
                    pt.setComponentTypes(atypes == null ? null : new HashSet(atypes));
                    List otypes = (List)mpercepttype.get("objecttypes");
                    pt.setObjectTypes(otypes == null ? null : new HashSet(otypes));
                    this.addPerceptType(pt);
                }
            }
            if ((spaceactions = mspacetype.getPropertyList("actiontypes")) != null) {
                for (int i = 0; i < spaceactions.size(); ++i) {
                    Map maction = (Map)spaceactions.get(i);
                    ISpaceAction action = (ISpaceAction)((Class)MEnvSpaceType.getProperty(maction, "clazz")).newInstance();
                    props2 = (List)maction.get("properties");
                    MEnvSpaceType.setProperties(action, props2, (IValueFetcher)fetcher);
                    this.addSpaceAction((String)MEnvSpaceType.getProperty(maction, "name"), action);
                }
            }
            if ((processtypes = mspacetype.getPropertyList("processtypes")) != null) {
                for (int i = 0; i < processtypes.size(); ++i) {
                    Map mprocess = (Map)processtypes.get(i);
                    props2 = (List)mprocess.get("properties");
                    String name = (String)MEnvSpaceType.getProperty(mprocess, "name");
                    Class clazz = (Class)MEnvSpaceType.getProperty(mprocess, "clazz");
                    this.addSpaceProcessType(name, clazz, props2);
                }
            }
            if ((tasktypes = mspacetype.getPropertyList("tasktypes")) != null) {
                for (int i = 0; i < tasktypes.size(); ++i) {
                    Map mtask = (Map)tasktypes.get(i);
                    List props3 = (List)mtask.get("properties");
                    String name = (String)MEnvSpaceType.getProperty(mtask, "name");
                    Class clazz = (Class)MEnvSpaceType.getProperty(mtask, "clazz");
                    this.addObjectTaskType(name, clazz, props3);
                }
            }
            if ((gens = mspacetype.getPropertyList("perceptgenerators")) != null) {
                for (int i = 0; i < gens.size(); ++i) {
                    Map mgen = (Map)gens.get(i);
                    IPerceptGenerator gen = (IPerceptGenerator)((Class)MEnvSpaceType.getProperty(mgen, "clazz")).newInstance();
                    List props4 = (List)mgen.get("properties");
                    MEnvSpaceType.setProperties(gen, props4, (IValueFetcher)fetcher);
                    this.addPerceptGenerator(MEnvSpaceType.getProperty(mgen, "name"), gen);
                }
            }
            if ((pmaps = mspacetype.getPropertyList("perceptprocessors")) != null) {
                for (int i = 0; i < pmaps.size(); ++i) {
                    Map mproc = (Map)pmaps.get(i);
                    IPerceptProcessor proc = (IPerceptProcessor)((Class)MEnvSpaceType.getProperty(mproc, "clazz")).newInstance();
                    List props5 = (List)mproc.get("properties");
                    MEnvSpaceType.setProperties(proc, props5, (IValueFetcher)fetcher);
                    String componenttype = (String)MEnvSpaceType.getProperty(mproc, "componenttype");
                    List ptypes = (List)mproc.get("percepttypes");
                    this.addPerceptProcessor(componenttype, ptypes == null ? null : new HashSet(ptypes), proc);
                }
            }
            if ((objects = this.config.getPropertyList("objects")) != null) {
                for (int i = 0; i < objects.size(); ++i) {
                    Map mobj = (Map)objects.get(i);
                    List mprops = (List)mobj.get("properties");
                    int num = 1;
                    if (mobj.containsKey("number")) {
                        num = ((Number)MEnvSpaceType.getProperty(mobj, "number")).intValue();
                    }
                    List tasks = (List)mobj.get("tasks");
                    for (int j = 0; j < num; ++j) {
                        fetcher.setValue("$number", (Object)j);
                        fetcher.setValue("$n", (Object)j);
                        props = MEnvSpaceType.convertProperties(mprops, (IValueFetcher)fetcher);
                        ISpaceObject so = this.createSpaceObject((String)MEnvSpaceType.getProperty(mobj, "type"), props, null);
                        if (tasks == null) continue;
                        for (int k = 0; k < tasks.size(); ++k) {
                            Map mtask = (Map)tasks.get(k);
                            List mtprops = (List)mtask.get("properties");
                            Map tprops = MEnvSpaceType.convertProperties(mtprops, (IValueFetcher)fetcher);
                            String type = (String)MEnvSpaceType.getProperty(mtask, "type");
                            this.createObjectTask(type, tprops, so.getId());
                        }
                    }
                }
            }
            if ((avatars = this.config.getPropertyList("avatars")) != null) {
                for (int i = 0; i < avatars.size(); ++i) {
                    Map mobj = (Map)avatars.get(i);
                    List mprops = (List)mobj.get("properties");
                    String owner = (String)MEnvSpaceType.getProperty(mobj, "owner");
                    if (owner == null) {
                        throw new RuntimeException("Attribute 'owner' required for avatar: " + mobj);
                    }
                    BasicComponentIdentifier ownerid = null;
                    ownerid = owner.indexOf("@") != -1 ? new BasicComponentIdentifier(owner) : new BasicComponentIdentifier(owner, this.ia.getComponentIdentifier());
                    props = MEnvSpaceType.convertProperties(mprops, (IValueFetcher)fetcher);
                    this.addInitialAvatar((IComponentIdentifier)ownerid, (String)MEnvSpaceType.getProperty(mobj, "type"), props);
                }
            }
            if ((procs = this.config.getPropertyList("processes")) != null) {
                for (int i = 0; i < procs.size(); ++i) {
                    Map mproc = (Map)procs.get(i);
                    List mprops = (List)mproc.get("properties");
                    Map props6 = MEnvSpaceType.convertProperties(mprops, (IValueFetcher)fetcher);
                    this.createSpaceProcess((String)MEnvSpaceType.getProperty(mproc, "type"), props6);
                }
            }
            if ((actions = this.config.getPropertyList("spaceactions")) != null) {
                for (int i = 0; i < actions.size(); ++i) {
                    Map action = (Map)actions.get(i);
                    List ps = (List)action.get("parameters");
                    HashMap params = null;
                    if (ps != null) {
                        params = new HashMap();
                        for (int j = 0; j < ps.size(); ++j) {
                            Map param = (Map)ps.get(j);
                            IParsedExpression exp = (IParsedExpression)param.get("value");
                            params.put(param.get("name"), exp.getValue((IValueFetcher)fetcher));
                        }
                    }
                    this.performSpaceAction((String)MEnvSpaceType.getProperty(action, "type"), params);
                }
            }
            if ((sourceviews = mspacetype.getPropertyList("dataviews")) != null) {
                for (int i = 0; i < sourceviews.size(); ++i) {
                    Map sourceview = (Map)sourceviews.get(i);
                    if (MEnvSpaceType.getProperty(sourceview, "objecttype") == null) {
                        HashMap<String, Object> viewargs = new HashMap<String, Object>();
                        viewargs.put("sourceview", sourceview);
                        viewargs.put("space", this);
                        IDataView view = (IDataView)((IObjectCreator)MEnvSpaceType.getProperty(sourceview, "creator")).createObject(viewargs);
                        this.addDataView((String)MEnvSpaceType.getProperty(sourceview, "name"), view);
                        continue;
                    }
                    this.addDataViewMapping((String)MEnvSpaceType.getProperty(sourceview, "objecttype"), sourceview);
                }
            }
            List<Object> providers = mspacetype.getPropertyList("dataproviders");
            List<Object> tmp = this.config.getPropertyList("dataproviders");
            if (providers == null && tmp != null) {
                providers = tmp;
            } else if (providers != null && tmp != null) {
                providers.addAll(tmp);
            }
            if (providers != null) {
                for (int i = 0; i < providers.size(); ++i) {
                    Map dcol = (Map)providers.get(i);
                    List sources = (List)dcol.get("source");
                    IObjectSource[] provs = new IObjectSource[sources.size()];
                    for (int j = 0; j < sources.size(); ++j) {
                        Map source = (Map)sources.get(j);
                        String varname = source.get("name") != null ? (String)source.get("name") : "$object";
                        String objecttype = (String)source.get("objecttype");
                        boolean aggregate = source.get("aggregate") != null ? (Boolean)source.get("aggregate") : false;
                        IParsedExpression dataexp = (IParsedExpression)source.get("content");
                        IParsedExpression includeexp = (IParsedExpression)source.get("includecondition");
                        provs[j] = new SpaceObjectSource(varname, this, objecttype, aggregate, dataexp, includeexp);
                    }
                    String tablename = (String)MEnvSpaceType.getProperty(dcol, "name");
                    List subdatas = (List)dcol.get("data");
                    String[] columnnames = new String[subdatas.size()];
                    IParsedExpression[] exps = new IParsedExpression[subdatas.size()];
                    for (int j = 0; j < subdatas.size(); ++j) {
                        Map subdata = (Map)subdatas.get(j);
                        columnnames[j] = (String)MEnvSpaceType.getProperty(subdata, "name");
                        exps[j] = (IParsedExpression)MEnvSpaceType.getProperty(subdata, "content");
                    }
                    DefaultDataProvider tprov = new DefaultDataProvider(this, provs, tablename, columnnames, exps);
                    this.addDataProvider(tablename, tprov);
                }
            }
            List<Object> consumers = mspacetype.getPropertyList("dataconsumers");
            tmp = this.config.getPropertyList("dataconsumers");
            if (consumers == null && tmp != null) {
                consumers = tmp;
            } else if (consumers != null && tmp != null) {
                consumers.addAll(tmp);
            }
            if (consumers != null) {
                for (int i = 0; i < consumers.size(); ++i) {
                    Map dcon = (Map)consumers.get(i);
                    String name = (String)MEnvSpaceType.getProperty(dcon, "name");
                    Class clazz = (Class)MEnvSpaceType.getProperty(dcon, "class");
                    ITableDataConsumer con = (ITableDataConsumer)clazz.newInstance();
                    MEnvSpaceType.setProperties(con, (List)dcon.get("properties"), (IValueFetcher)fetcher);
                    con.setProperty("envspace", this);
                    this.addDataConsumer(name, con);
                }
            }
            Future ocsdone = new Future();
            List<Object> observers = this.config.getPropertyList("observers");
            if (observers != null) {
                CounterResultListener crl1 = new CounterResultListener(observers.size(), (IResultListener)new DelegationResultListener(ocsdone));
                for (int i = 0; i < observers.size(); ++i) {
                    ArrayList<IPropertyObject> plugins;
                    Map observer = (Map)observers.get(i);
                    String title = MEnvSpaceType.getProperty(observer, "name") != null ? (String)MEnvSpaceType.getProperty(observer, "name") : "Default Observer";
                    Boolean killonexit = (Boolean)MEnvSpaceType.getProperty(observer, "killonexit");
                    List plugs = (List)observer.get("plugins");
                    ArrayList<IPropertyObject> arrayList = plugins = plugs != null ? new ArrayList<IPropertyObject>() : null;
                    if (plugs != null) {
                        for (int j = 0; j < plugs.size(); ++j) {
                            Map plug = (Map)plugs.get(j);
                            Class clazz = (Class)MEnvSpaceType.getProperty(plug, "clazz");
                            IPropertyObject po = (IPropertyObject)clazz.newInstance();
                            MEnvSpaceType.setProperties(po, (List)plug.get("properties"), (IValueFetcher)fetcher);
                            plugins.add(po);
                        }
                    }
                    String classname = (String)MEnvSpaceType.getProperty(observer, "class");
                    IObserverCenter tmpoc = null;
                    tmpoc = classname == null ? new ObserverCenter() : (IObserverCenter)this.classloader.loadClass(classname).newInstance();
                    final ObserverCenter oc = tmpoc;
                    oc.startObserver(title, this, this.ia.getClassLoader(), killonexit != null ? killonexit : true);
                    this.observercenters.add(oc);
                    SServiceProvider.getService((IExternalAccess)this.getExternalAccess(), IComponentManagementService.class, (String)"platform").addResultListener((IResultListener)new DefaultResultListener(){

                        public void resultAvailable(final Object result) {
                            ((IComponentManagementService)result).addComponentListener(AbstractEnvironmentSpace.this.getExternalAccess().getComponentIdentifier(), new ICMSComponentListener(){

                                public IFuture componentRemoved(IComponentDescription desc, Map results) {
                                    ((IComponentManagementService)result).removeComponentListener(AbstractEnvironmentSpace.this.getExternalAccess().getComponentIdentifier(), (ICMSComponentListener)this);
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            oc.dispose();
                                        }
                                    });
                                    return IFuture.DONE;
                                }

                                public IFuture componentChanged(IComponentDescription desc) {
                                    return IFuture.DONE;
                                }

                                public IFuture componentAdded(IComponentDescription desc) {
                                    return IFuture.DONE;
                                }
                            });
                        }
                    });
                    Future ocdone = new Future();
                    ocdone.addResultListener((IResultListener)crl1);
                    List perspectives = mspacetype.getPropertyList("perspectives");
                    CounterResultListener crl2 = new CounterResultListener(perspectives.size(), (IResultListener)new DelegationResultListener(ocdone));
                    for (int j = 0; j < perspectives.size(); ++j) {
                        Map sourcepers = (Map)perspectives.get(j);
                        HashMap args = new HashMap();
                        args.put("object", sourcepers);
                        args.put("fetcher", fetcher);
                        try {
                            IPerspective persp = (IPerspective)((IObjectCreator)MEnvSpaceType.getProperty(sourcepers, "creator")).createObject(args);
                            List props7 = (List)sourcepers.get("properties");
                            MEnvSpaceType.setProperties((IPropertyObject)persp, props7, (IValueFetcher)fetcher);
                            oc.addPerspective((String)MEnvSpaceType.getProperty(sourcepers, "name"), persp).addResultListener((IResultListener)crl2);
                            continue;
                        }
                        catch (Exception e) {
                            crl2.exceptionOccurred(e);
                        }
                    }
                    oc.loadPlugins(plugins);
                }
            } else {
                ocsdone.setResult(null);
            }
            ocsdone.addResultListener((IResultListener)new DelegationResultListener<Void>(ret){

                public void customResultAvailable(Void result) {
                    Map mse = (Map)MEnvSpaceType.getProperty(mspacetype.getProperties(), "spaceexecutor");
                    if (mse != null) {
                        IParsedExpression exp = (IParsedExpression)MEnvSpaceType.getProperty(mse, "expression");
                        ISpaceExecutor exe = null;
                        if (exp != null) {
                            exe = (ISpaceExecutor)exp.getValue((IValueFetcher)fetcher);
                        } else {
                            try {
                                exe = (ISpaceExecutor)((Class)MEnvSpaceType.getProperty(mse, "clazz")).newInstance();
                                List props = (List)mse.get("properties");
                                MEnvSpaceType.setProperties(exe, props, (IValueFetcher)fetcher);
                            }
                            catch (Exception e) {
                                ret.setException(e);
                            }
                        }
                        if (exe != null) {
                            exe.start();
                        }
                    }
                    ret.setResultIfUndone((Object)result);
                }
            });
        }
        catch (Exception e) {
            ret.setException(e);
        }
        ret.addResultListener((IResultListener)new IResultListener<Void>(){

            public void resultAvailable(Void result) {
            }

            public void exceptionOccurred(Exception exception) {
                exception.printStackTrace();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; AbstractEnvironmentSpace.this.observercenters != null && i < AbstractEnvironmentSpace.this.observercenters.size(); ++i) {
                            ((ObserverCenter)AbstractEnvironmentSpace.this.observercenters.get(i)).dispose();
                        }
                    }
                });
            }
        });
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSpaceObjectType(String typename, IPropertyMetaDataSet mobjecttype) {
        Object object = this.monitor;
        synchronized (object) {
            this.objecttypes.put(typename, mobjecttype);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSpaceObjectType(String typename) {
        Object object = this.monitor;
        synchronized (object) {
            this.objecttypes.remove(typename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSpaceProcessType(String typename, Class clazz, List properties) {
        Object object = this.monitor;
        synchronized (object) {
            this.processtypes.put(typename, new Object[]{clazz, properties});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSpaceProcessType(String typename) {
        Object object = this.monitor;
        synchronized (object) {
            this.processtypes.remove(typename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSpaceProcess(String typename, Map properties) {
        Object object = this.monitor;
        synchronized (object) {
            Long id;
            while (this.spaceobjects.containsKey(id = this.objectidcounter.getNext())) {
            }
            Object[] procinfo = (Object[])this.processtypes.get(typename);
            if (procinfo == null) {
                throw new RuntimeException("Unknown space process: " + typename);
            }
            try {
                ISpaceProcess process = (ISpaceProcess)((Class)procinfo[0]).newInstance();
                properties = this.mergeProperties((List)procinfo[1], properties);
                if (properties != null) {
                    for (String propname : properties.keySet()) {
                        process.setProperty(propname, properties.get(propname));
                    }
                }
                process.setProperty("##_id", id);
                this.processes.put(id, process);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Could not create space process: " + typename, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObjectTaskType(String typename, Class clazz, List properties) {
        Object object = this.monitor;
        synchronized (object) {
            this.tasktypes.put(typename, new Object[]{clazz, properties});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObjectTaskType(String typename) {
        Object object = this.monitor;
        synchronized (object) {
            this.tasktypes.remove(typename);
        }
    }

    @Override
    public Object createObjectTask(String typename, Map properties, Object objectid) {
        Object object = this.monitor;
        synchronized (object) {
            Object[] taskinfo = (Object[])this.tasktypes.get(typename);
            if (taskinfo == null) {
                throw new RuntimeException("Unknown space task: " + typename);
            }
            try {
                IObjectTask task = (IObjectTask)((Class)taskinfo[0]).newInstance();
                Long id = this.taskidcounter.getNext();
                task.setProperty("task_id", id);
                properties = this.mergeProperties((List)taskinfo[1], properties);
                if (properties != null) {
                    for (String propname : properties.keySet()) {
                        task.setProperty(propname, properties.get(propname));
                    }
                }
                SpaceObject object2 = (SpaceObject)this.getSpaceObject(objectid);
                object2.addTask(task);
                return id;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create space task: " + typename, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObjectTask(Object taskid, Object objectid) {
        Object object = this.monitor;
        synchronized (object) {
            SpaceObject so = (SpaceObject)this.getSpaceObject(objectid);
            so.removeTask(taskid, null);
        }
    }

    @Override
    public void addTaskListener(Object taskid, Object objectid, IResultListener listener) {
        SpaceObject so = (SpaceObject)this.getSpaceObject(objectid);
        so.addTaskListener(taskid, listener);
    }

    @Override
    public void removeTaskListener(Object taskid, Object objectid, IResultListener listener) {
        SpaceObject so = (SpaceObject)this.getSpaceObject(objectid);
        so.removeTaskListener(taskid, listener);
    }

    @Override
    public IFuture<Void> waitForTask(Object taskid, Object objectid) {
        final Future ret = new Future();
        SpaceObject so = (SpaceObject)this.getSpaceObject(objectid);
        so.addTaskListener(taskid, (IResultListener)new IResultListener<Object>(){

            public void resultAvailable(Object result) {
                ret.setResultIfUndone(null);
            }

            public void exceptionOccurred(Exception exception) {
                ret.setExceptionIfUndone(exception);
            }
        });
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getSpaceProcessNames() {
        Object object = this.monitor;
        synchronized (object) {
            return new HashSet(this.processes.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISpaceProcess getSpaceProcess(Object id) {
        Object object = this.monitor;
        synchronized (object) {
            return (ISpaceProcess)this.processes.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSpaceProcess(Object id) {
        Object object = this.monitor;
        synchronized (object) {
            ISpaceProcess process = (ISpaceProcess)this.processes.remove(id);
            if (process != null) {
                process.shutdown(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ISpaceObject createSpaceObject(String typename, Map properties, List tasks) {
        SpaceObject ret;
        if (!this.objecttypes.containsKey(typename)) {
            throw new RuntimeException("Unknown space object type: " + typename);
        }
        Object object = this.monitor;
        synchronized (object) {
            Long id;
            while (this.spaceobjects.containsKey(id = this.objectidcounter.getNext()) || this.zombieobjects.containsKey(id)) {
            }
            MObjectType mObjectType = (MObjectType)this.objecttypes.get(typename);
            if (properties != null) {
                properties = new HashMap(properties);
            }
            properties = this.mergeProperties(mObjectType, properties);
            ret = new SpaceObject(id, mObjectType, properties, tasks, this.monitor, this);
            this.spaceobjects.put(id, ret);
            if (properties != null && properties.containsKey("owner")) {
                Object owner = properties.get("owner");
                ArrayList<SpaceObject> ownerobjects = (ArrayList<SpaceObject>)this.spaceobjectsbyowner.get(owner);
                if (ownerobjects == null) {
                    ownerobjects = new ArrayList<SpaceObject>();
                    this.spaceobjectsbyowner.put(owner, ownerobjects);
                }
                ownerobjects.add(ret);
            }
        }
        this.initSpaceObject(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISpaceObject createSpaceObjectZombie(String typename, Map properties, List tasks) {
        SpaceObject ret;
        if (!this.objecttypes.containsKey(typename)) {
            throw new RuntimeException("Unknown space object type: " + typename);
        }
        Object object = this.monitor;
        synchronized (object) {
            Long id;
            while (this.spaceobjects.containsKey(id = this.objectidcounter.getNext()) || this.zombieobjects.containsKey(id)) {
            }
            MObjectType mObjectType = (MObjectType)this.objecttypes.get(typename);
            properties = this.mergeProperties(mObjectType, properties);
            ret = new SpaceObject(id, mObjectType, properties, tasks, this.monitor, this);
            this.zombieobjects.put(id, ret);
            if (properties != null && properties.containsKey("owner")) {
                Object owner = properties.get("owner");
                ArrayList<SpaceObject> ownerobjects = (ArrayList<SpaceObject>)this.spaceobjectsbyowner.get(owner);
                if (ownerobjects == null) {
                    ownerobjects = new ArrayList<SpaceObject>();
                    this.spaceobjectsbyowner.put(owner, ownerobjects);
                }
                ownerobjects.add(ret);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSpaceObject(final ISpaceObject ret) {
        Object object = this.monitor;
        synchronized (object) {
            ArrayList<ISpaceObject> typeobjects;
            if (this.zombieobjects.containsKey(ret.getId())) {
                this.zombieobjects.remove(ret.getId());
                this.spaceobjects.put(ret.getId(), ret);
            }
            if ((typeobjects = (ArrayList<ISpaceObject>)this.spaceobjectsbytype.get(ret.getType())) == null) {
                typeobjects = new ArrayList<ISpaceObject>();
                this.spaceobjectsbytype.put(ret.getType(), typeobjects);
            }
            typeobjects.add(ret);
            if (this.dataviewmappings != null && this.dataviewmappings.get((Object)ret.getType()) != null) {
                Iterator it = this.dataviewmappings.get((Object)ret.getType()).iterator();
                while (it.hasNext()) {
                    try {
                        Map sourceview = (Map)it.next();
                        HashMap<String, Object> viewargs = new HashMap<String, Object>();
                        viewargs.put("sourceview", sourceview);
                        viewargs.put("space", this);
                        viewargs.put("object", ret);
                        IDataView view = (IDataView)((IObjectCreator)MEnvSpaceType.getProperty(sourceview, "creator")).createObject(viewargs);
                        this.addDataView((String)MEnvSpaceType.getProperty(sourceview, "name") + "_" + ret.getId(), view);
                    }
                    catch (Exception e) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                }
            }
            for (String componenttype : this.avatarmappings.keySet()) {
                AvatarMapping mapping = this.getAvatarMapping(componenttype, ret.getType());
                if (mapping == null || !mapping.isCreateComponent()) continue;
                final String compotype = componenttype;
                this.getExternalAccess().getFileName(compotype).addResultListener((IResultListener)new DefaultResultListener(){

                    public void resultAvailable(Object result) {
                        final String filename = (String)result;
                        SServiceProvider.getService((IExternalAccess)AbstractEnvironmentSpace.this.exta, IComponentManagementService.class, (String)"platform").addResultListener((IResultListener)new DefaultResultListener(){

                            public void resultAvailable(Object result) {
                                IComponentManagementService cms = (IComponentManagementService)result;
                                BasicComponentIdentifier cid = new BasicComponentIdentifier(compotype + "_" + ret.getId(), AbstractEnvironmentSpace.this.getExternalAccess().getComponentIdentifier());
                                CMSComponentDescription desc = new CMSComponentDescription();
                                desc.setName((IComponentIdentifier)cid);
                                desc.setLocalType(compotype);
                                AbstractEnvironmentSpace.this.setOwner(ret.getId(), (IComponentDescription)desc);
                                IFuture future = cms.createComponent(cid.getLocalName(), filename, new CreationInfo(null, null, AbstractEnvironmentSpace.this.getExternalAccess().getComponentIdentifier(), Boolean.valueOf(false), AbstractEnvironmentSpace.this.getExternalAccess().getModel().getAllImports()), null);
                                future.addResultListener(new IResultListener(){

                                    public void resultAvailable(Object result) {
                                    }

                                    public void exceptionOccurred(final Exception exception) {
                                        AbstractEnvironmentSpace.this.exta.scheduleStep((IComponentStep)new IComponentStep<Void>(){

                                            public IFuture<Void> execute(IInternalAccess ia) {
                                                StringWriter sw = new StringWriter();
                                                exception.printStackTrace(new PrintWriter(sw));
                                                ia.getLogger().severe("Could not create component: " + compotype + "\n" + exception);
                                                return IFuture.DONE;
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
            }
        }
        if (this.listeners != null) {
            EnvironmentEvent event = new EnvironmentEvent("created", this, ret, null, null);
            for (int i = 0; i < this.listeners.size(); ++i) {
                IEnvironmentListener lis = (IEnvironmentListener)this.listeners.get(i);
                lis.dispatchEnvironmentEvent(event);
            }
        }
    }

    protected Map mergeProperties(Collection typeprops, Map properties) {
        if (typeprops != null) {
            if (properties == null) {
                properties = new HashMap<String, Object>();
            }
            for (Map prop : typeprops) {
                IParsedExpression exp;
                String propname = (String)prop.get("name");
                if (properties.containsKey(propname) || (exp = (IParsedExpression)prop.get("value")) == null) continue;
                boolean dyn = (Boolean)prop.get("dynamic");
                if (dyn) {
                    properties.put(propname, exp);
                    continue;
                }
                properties.put(propname, exp.getValue((IValueFetcher)this.fetcher));
            }
        }
        return properties;
    }

    protected Map mergeProperties(IPropertyMetaDataSet mObjectType, Map properties) {
        if (mObjectType != null) {
            if (properties == null) {
                properties = new HashMap<String, Object>();
            }
            for (MObjectTypeProperty property : mObjectType) {
                IParsedExpression exp;
                if (properties.containsKey(property.getName()) || (exp = (IParsedExpression)property.getValue()) == null) continue;
                if (property.isDynamic()) {
                    properties.put(property.getName(), exp);
                    continue;
                }
                properties.put(property.getName(), exp.getValue((IValueFetcher)this.fetcher));
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySpaceObject(Object id) {
        Object object;
        SpaceObject obj;
        IComponentDescription tmp = null;
        String ot = null;
        Object object2 = this.monitor;
        synchronized (object2) {
            obj = (SpaceObject)this.spaceobjects.get(id);
            if (obj == null) {
                throw new RuntimeException("No object found for id: " + id);
            }
            ot = obj.getType();
            tmp = (IComponentDescription)obj.getProperty("owner");
        }
        String objecttype = ot;
        final IComponentDescription desc = tmp;
        if (desc != null) {
            object = this.monitor;
            synchronized (object) {
                String componenttype = desc.getLocalType();
                AvatarMapping mapping = this.getAvatarMapping(componenttype, objecttype);
                if (mapping.isKillComponent()) {
                    SServiceProvider.getService((IExternalAccess)this.getExternalAccess(), IComponentManagementService.class, (String)"component").addResultListener((IResultListener)new DefaultResultListener(){

                        public void resultAvailable(Object result) {
                            ((IComponentManagementService)result).destroyComponent(desc.getName());
                        }
                    });
                }
            }
        }
        object = this.monitor;
        synchronized (object) {
            ComponentActionList.ActionEntry[] actions = this.actionlist.getActionEntries();
            for (int i = 0; i < actions.length; ++i) {
                Object avatarid;
                ISpaceObject so;
                Object actorid = actions[i].parameters.get("actor_id");
                if (actorid == null || (so = this.getAvatar((IComponentDescription)actorid)) == null || (avatarid = so.getId()) != id) continue;
                actions[i].setInvalid(true);
            }
            obj.clearTasks();
            this.spaceobjects.remove(id);
            List typeobjs = (List)this.spaceobjectsbytype.get(objecttype);
            typeobjs.remove(obj);
            if (typeobjs.size() == 0) {
                this.spaceobjectsbytype.remove(obj.getType());
            }
            if (obj.getProperty("owner") != null) {
                List ownedobjs = (List)this.spaceobjectsbyowner.get(obj.getProperty("owner"));
                ownedobjs.remove(obj);
                if (ownedobjs.size() == 0) {
                    this.spaceobjectsbyowner.remove(obj.getProperty("owner"));
                }
            }
            if (this.dataviewmappings != null && this.dataviewmappings.get((Object)objecttype) != null) {
                for (Map sourceview : this.dataviewmappings.get((Object)objecttype)) {
                    this.removeDataView((String)MEnvSpaceType.getProperty(sourceview, "name") + "_" + id);
                }
            }
        }
        if (this.listeners != null) {
            EnvironmentEvent ev = new EnvironmentEvent("destroyed", this, obj, null, null);
            for (int i = 0; i < this.listeners.size(); ++i) {
                IEnvironmentListener lis = (IEnvironmentListener)this.listeners.get(i);
                lis.dispatchEnvironmentEvent(ev);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISpaceObject getSpaceObject(Object id) {
        Object object = this.monitor;
        synchronized (object) {
            ISpaceObject ret = (ISpaceObject)this.spaceobjects.get(id);
            if (ret == null) {
                throw new RuntimeException("Space object not found: " + id);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISpaceObject getSpaceObject0(Object id) {
        Object object = this.monitor;
        synchronized (object) {
            return (ISpaceObject)this.spaceobjects.get(id);
        }
    }

    @Override
    public ISpaceObject[] getSpaceObjectsByType(String type) {
        List obs = (List)this.spaceobjectsbytype.get(type);
        return obs == null ? new ISpaceObject[]{} : obs.toArray(new ISpaceObject[obs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAvatarMappings(AvatarMapping mapping) {
        Object object = this.monitor;
        synchronized (object) {
            this.avatarmappings.add((Object)mapping.getComponentType(), (Object)mapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAvatarMappings(AvatarMapping mapping) {
        Object object = this.monitor;
        synchronized (object) {
            this.avatarmappings.removeObject((Object)mapping.getComponentType(), (Object)mapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSpaceAction(String id, ISpaceAction action) {
        Object object = this.monitor;
        synchronized (object) {
            this.actions.put(id, action);
        }
    }

    public ISpaceAction getSpaceAction(String id) {
        ISpaceAction ret = (ISpaceAction)this.actions.get(id);
        if (ret == null) {
            throw new RuntimeException("No such space action: " + id);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSpaceAction(String id) {
        Object object = this.monitor;
        synchronized (object) {
            this.actions.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int performSpaceAction(String id, Map parameters, IResultListener listener) {
        Object object = this.monitor;
        synchronized (object) {
            return this.actionlist.scheduleComponentAction(this.getSpaceAction(id), parameters, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelSpaceAction(int id) {
        Object object = this.monitor;
        synchronized (object) {
            this.actionlist.cancelComponentAction(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object performSpaceAction(String id, Map parameters) {
        Object object = this.monitor;
        synchronized (object) {
            ISpaceAction action = (ISpaceAction)this.actions.get(id);
            if (action == null) {
                throw new RuntimeException("Action not found: " + id);
            }
            return action.perform(parameters, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPercept(String typename, Object data, IComponentDescription comp, ISpaceObject avatar) {
        String componenttype = comp.getLocalType();
        Object object = this.monitor;
        synchronized (object) {
            Object[] tmp;
            int i;
            List procs = (List)this.perceptprocessors.get((Object)componenttype);
            IPerceptProcessor proc = null;
            if (procs != null) {
                for (i = 0; i < procs.size() && proc == null; ++i) {
                    tmp = (Object[])procs.get(i);
                    if (tmp[0] != null && !((Collection)tmp[0]).contains(typename)) continue;
                    proc = (IPerceptProcessor)tmp[1];
                }
            }
            if (proc == null && (procs = (List)this.perceptprocessors.get(null)) != null) {
                for (i = 0; i < procs.size() && proc == null; ++i) {
                    tmp = (Object[])procs.get(i);
                    if (tmp[0] != null && !((Collection)tmp[0]).contains(typename)) continue;
                    proc = (IPerceptProcessor)tmp[1];
                }
            }
            if (proc != null) {
                this.perceptlist.schedulePercept(typename, data, comp, avatar, proc);
            } else {
                System.out.println("Warning: No processor for percept: " + typename + ", " + data + ", " + comp + ", " + avatar);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IComponentDescription getOwner(Object id) {
        Object object = this.monitor;
        synchronized (object) {
            ISpaceObject obj = this.getSpaceObject(id);
            if (obj == null) {
                throw new RuntimeException("Space object not found: " + id);
            }
            return (IComponentDescription)obj.getProperty("owner");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOwner(Object id, IComponentDescription owner) {
        Object object = this.monitor;
        synchronized (object) {
            List<ISpaceObject> ownedobjs;
            ISpaceObject obj = this.getSpaceObject(id);
            if (obj == null) {
                throw new RuntimeException("Space object not found: " + id);
            }
            Object oldowner = obj.getProperty("owner");
            if (oldowner != null) {
                ownedobjs = (ArrayList<ISpaceObject>)this.spaceobjectsbyowner.get(oldowner);
                ownedobjs.remove(obj);
                if (ownedobjs.size() == 0) {
                    this.spaceobjectsbyowner.remove(oldowner);
                }
            }
            if (owner != null) {
                ownedobjs = (List)this.spaceobjectsbyowner.get(owner);
                if (ownedobjs == null) {
                    ownedobjs = new ArrayList<ISpaceObject>();
                    this.spaceobjectsbyowner.put(owner, ownedobjs);
                }
                ownedobjs.add(obj);
            }
            obj.setProperty("owner", owner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISpaceObject[] getAvatars(IComponentDescription owner) {
        Object object = this.monitor;
        synchronized (object) {
            List ownedobjs = (List)this.spaceobjectsbyowner.get(owner);
            return ownedobjs == null ? new ISpaceObject[]{} : ownedobjs.toArray(new ISpaceObject[ownedobjs.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IComponentDescription[] getComponents() {
        Object object = this.monitor;
        synchronized (object) {
            return this.spaceobjectsbyowner.keySet().toArray(new IComponentDescription[this.spaceobjectsbyowner.keySet().size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISpaceObject getAvatar(IComponentDescription owner) {
        Object object = this.monitor;
        synchronized (object) {
            ISpaceObject ret = null;
            List ownedobjs = (List)this.spaceobjectsbyowner.get(owner);
            if (ownedobjs != null) {
                if (ownedobjs.size() > 1) {
                    throw new RuntimeException("More than one avatar for component: " + owner);
                }
                if (ownedobjs.size() == 1) {
                    ret = (ISpaceObject)ownedobjs.get(0);
                }
            }
            return ret;
        }
    }

    public ISpaceObject getAvatar(IComponentDescription owner, String fullname) {
        ISpaceObject ret = this.getAvatar(owner);
        if (ret == null) {
            ret = this.createAvatar(owner, fullname, true);
        }
        return ret;
    }

    protected ISpaceObject createAvatar(IComponentDescription owner, String fullname, boolean zombie) {
        ISpaceObject ret = null;
        if (this.initialavatars != null && this.initialavatars.containsKey(owner)) {
            Object[] ia = (Object[])this.initialavatars.get(owner);
            String objecttype = (String)ia[0];
            HashMap<String, IComponentDescription> props = (HashMap<String, IComponentDescription>)ia[1];
            if (props == null) {
                props = new HashMap<String, IComponentDescription>();
            }
            props.put("owner", owner);
            ret = zombie ? this.createSpaceObjectZombie(objecttype, props, null) : this.createSpaceObject(objecttype, props, null);
        } else {
            String componenttype = owner.getLocalType();
            if (componenttype == null && fullname != null) {
                SubcomponentTypeInfo[] atypes = this.exta.getModel().getSubcomponentTypes();
                for (int i = 0; i < atypes.length; ++i) {
                    String tmp = atypes[i].getFilename().replace('/', '.');
                    if (tmp.indexOf(fullname) == -1) continue;
                    componenttype = atypes[i].getName();
                    break;
                }
            }
            if (componenttype != null && this.avatarmappings.get((Object)componenttype) != null) {
                for (AvatarMapping mapping : this.avatarmappings.get((Object)componenttype)) {
                    if (!mapping.isCreateAvatar() || this.spaceobjectsbyowner.containsKey(owner)) continue;
                    HashMap<String, IComponentDescription> props = new HashMap<String, IComponentDescription>();
                    props.put("owner", owner);
                    ret = zombie ? this.createSpaceObjectZombie(mapping.getObjectType(), props, null) : this.createSpaceObject(mapping.getObjectType(), props, null);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDataView(String name, IDataView view) {
        Object object = this.monitor;
        synchronized (object) {
            this.views.put(name, view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataView(String name) {
        Object object = this.monitor;
        synchronized (object) {
            this.views.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDataView getDataView(String name) {
        Object object = this.monitor;
        synchronized (object) {
            return (IDataView)this.views.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getDataViews() {
        Object object = this.monitor;
        synchronized (object) {
            return new HashMap(this.views);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataViewMapping(String objecttype, Map view) {
        Object object = this.monitor;
        synchronized (object) {
            this.dataviewmappings.add((Object)objecttype, (Object)view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEnvironmentListener(IEnvironmentListener listener) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEnvironmentListener(IEnvironmentListener listener) {
        Object object = this.monitor;
        synchronized (object) {
            this.listeners.remove(listener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPerceptGenerator(Object id, IPerceptGenerator gen) {
        Object object = this.monitor;
        synchronized (object) {
            this.addEnvironmentListener(gen);
            this.perceptgenerators.put(id, gen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePerceptGenerator(Object id) {
        Object object = this.monitor;
        synchronized (object) {
            this.removeEnvironmentListener((IEnvironmentListener)this.perceptgenerators.remove(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPerceptProcessor(String componenttype, Set percepttypes, IPerceptProcessor proc) {
        Object object = this.monitor;
        synchronized (object) {
            this.perceptprocessors.add((Object)componenttype, (Object)new Object[]{percepttypes, proc});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePerceptProcessor(String componenttype, IPerceptProcessor proc) {
        Object object = this.monitor;
        synchronized (object) {
            List procs = (List)this.perceptprocessors.get((Object)componenttype);
            for (int i = 0; i < procs.size(); ++i) {
                Object[] tmp = (Object[])procs.get(i);
                if (!proc.equals(tmp[1])) continue;
                this.perceptprocessors.removeObject((Object)componenttype, (Object)tmp);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPerceptType(PerceptType percepttype) {
        Object object = this.monitor;
        synchronized (object) {
            this.percepttypes.put(percepttype.getName(), percepttype);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePerceptType(String typename) {
        Object object = this.monitor;
        synchronized (object) {
            this.percepttypes.remove(typename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PerceptType getPerceptType(String percepttype) {
        Object object = this.monitor;
        synchronized (object) {
            return (PerceptType)this.percepttypes.get(percepttype);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void componentAdded(IComponentDescription owner) {
        Object object = this.monitor;
        synchronized (object) {
            List ownedobjs = (List)this.spaceobjectsbyowner.get(owner);
            if (ownedobjs == null) {
                this.createAvatar(owner, null, false);
            } else {
                for (ISpaceObject obj : ownedobjs) {
                    if (this.spaceobjects.containsKey(obj.getId())) continue;
                    this.initSpaceObject(obj);
                }
            }
            if (this.perceptgenerators != null) {
                Iterator<Object> it = this.perceptgenerators.keySet().iterator();
                while (it.hasNext()) {
                    IPerceptGenerator gen = (IPerceptGenerator)this.perceptgenerators.get(it.next());
                    gen.componentAdded(owner, this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void componentRemoved(IComponentDescription desc) {
        String componenttype = desc.getLocalType();
        Object object = this.monitor;
        synchronized (object) {
            ISpaceObject[] avatars;
            if (componenttype != null && this.avatarmappings.get((Object)componenttype) != null && (avatars = this.getAvatars(desc)) != null) {
                for (int i = 0; i < avatars.length; ++i) {
                    String avatartype = avatars[i].getType();
                    AvatarMapping mapping = this.getAvatarMapping(componenttype, avatartype);
                    if (mapping == null || !mapping.isKillAvatar()) continue;
                    this.destroySpaceObject(avatars[i].getId());
                }
            }
            if (this.perceptgenerators != null) {
                Iterator it = this.perceptgenerators.keySet().iterator();
                while (it.hasNext()) {
                    IPerceptGenerator gen = (IPerceptGenerator)this.perceptgenerators.get(it.next());
                    gen.componentRemoved(desc, this);
                }
            }
        }
    }

    protected IFuture getComponentType(final IComponentIdentifier cid) {
        final Future ret = new Future();
        SServiceProvider.getService((IExternalAccess)this.getExternalAccess(), IComponentManagementService.class, (String)"platform").addResultListener((IResultListener)new DelegationResultListener(ret){

            public void customResultAvailable(Object result) {
                IComponentManagementService cms = (IComponentManagementService)result;
                cms.getExternalAccess(cid).addResultListener((IResultListener)new DelegationResultListener(ret){

                    public void customResultAvailable(Object result) {
                        IExternalAccess exta = (IExternalAccess)result;
                        String componenttype = exta.getLocalType();
                        ret.setResult((Object)componenttype);
                    }
                });
            }
        });
        return ret;
    }

    @Override
    public IExternalAccess getExternalAccess() {
        return this.exta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String name) {
        Object object = this.monitor;
        synchronized (object) {
            Object ret = super.getProperty(name);
            if (ret instanceof IParsedExpression) {
                ret = ((IParsedExpression)ret).getValue((IValueFetcher)this.getFetcher());
            }
            return ret;
        }
    }

    public SimpleValueFetcher getFetcher() {
        if (this.fetcher == null) {
            this.fetcher = new SimpleValueFetcher(){

                public Object fetchValue(String name) {
                    Object ret = null;
                    ret = AbstractEnvironmentSpace.this.getPropertyNames().contains(name) ? AbstractEnvironmentSpace.this.getProperty(name) : super.fetchValue(name);
                    return ret;
                }
            };
            this.fetcher.setValue("$space", (Object)this);
        }
        return this.fetcher;
    }

    public void setFetcher(SimpleValueFetcher fetcher) {
        this.fetcher = fetcher;
    }

    public Collection getSpaceObjectsCollection() {
        return this.spaceobjects.values();
    }

    public Collection getProcesses() {
        return this.processes.values();
    }

    public ComponentActionList getComponentActionList() {
        return this.actionlist;
    }

    public PerceptList getPerceptList() {
        return this.perceptlist;
    }

    public Collection getViews() {
        return this.views.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEnvironmentEvent(EnvironmentEvent event) {
        IEnvironmentListener[] alisteners = null;
        Object object = this.monitor;
        synchronized (object) {
            if (this.listeners != null) {
                alisteners = this.listeners.toArray(new IEnvironmentListener[this.listeners.size()]);
            }
        }
        if (alisteners != null) {
            for (int i = 0; i < alisteners.length; ++i) {
                alisteners[i].dispatchEnvironmentEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireObjectEvent(SpaceObject object, String property, Object value) {
        boolean fire = false;
        Object object2 = this.monitor;
        synchronized (object2) {
            MObjectType props = (MObjectType)this.objecttypes.get(object.getType());
            if (props != null) {
                MObjectTypeProperty prop = (MObjectTypeProperty)props.getProperty(property);
                fire = prop != null && prop.isEvent();
            }
        }
        if (fire) {
            this.fireEnvironmentEvent(new EnvironmentEvent("property_changed", this, object, property, value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInitialAvatar(IComponentIdentifier ownerid, String type, Map props) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.initialavatars == null) {
                this.initialavatars = new HashMap();
            }
            this.initialavatars.put(ownerid, new Object[]{type, props});
        }
    }

    protected AvatarMapping getAvatarMapping(String componenttype, String avatartype) {
        AvatarMapping mapping = null;
        Iterator it = this.avatarmappings.getCollection((Object)componenttype).iterator();
        while (mapping == null && it.hasNext()) {
            AvatarMapping test = (AvatarMapping)it.next();
            if (!avatartype.equals(test.getObjectType())) continue;
            mapping = test;
        }
        return mapping;
    }

    public void addDataProvider(String name, ITableDataProvider provider) {
        this.dataproviders.put(name, provider);
    }

    public ITableDataProvider getDataProvider(String name) {
        return (ITableDataProvider)this.dataproviders.get(name);
    }

    public void addDataConsumer(String name, ITableDataConsumer consumer) {
        this.dataconsumers.put(name, consumer);
    }

    public ITableDataConsumer getDataConsumer(String name) {
        return (ITableDataConsumer)this.dataconsumers.get(name);
    }

    public Collection getDataConsumers() {
        return this.dataconsumers.values();
    }

    public IFuture<Void> init() {
        final Future ret = new Future();
        this.initSpace().addResultListener(((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener<Void>(ret){

            public void customResultAvailable(Void result) {
                ISubscriptionIntermediateFuture sub = ((IMonitoringComponentFeature)AbstractEnvironmentSpace.this.ia.getComponentFeature(IMonitoringComponentFeature.class)).subscribeToEvents((IFilter)new IFilter<IMonitoringEvent>(){

                    public boolean filter(IMonitoringEvent obj) {
                        return obj.getType().endsWith("Component") || obj.getType().equals("created.subscription");
                    }
                }, false, IMonitoringService.PublishEventLevel.COARSE);
                sub.addResultListener((IResultListener)new IIntermediateFutureCommandResultListener<IMonitoringEvent>(){

                    public void resultAvailable(Collection<IMonitoringEvent> result) {
                    }

                    public void intermediateResultAvailable(IMonitoringEvent result) {
                        if (result.getType().equals("created.subscription")) {
                            ret.setResult(null);
                        } else if (result.getType().startsWith("created")) {
                            AbstractEnvironmentSpace.this.componentAdded((IComponentDescription)result.getProperty("details"));
                        } else if (result.getType().startsWith("disposed")) {
                            AbstractEnvironmentSpace.this.componentRemoved((IComponentDescription)result.getProperty("details"));
                        }
                    }

                    public void finished() {
                    }

                    public void exceptionOccurred(Exception e) {
                        e.printStackTrace();
                    }

                    public void commandAvailable(Object command) {
                    }
                });
            }
        }));
        return ret;
    }

    public IFuture<Void> terminate() {
        final Future ret = new Future();
        final IObserverCenter[] ocs = this.observercenters.toArray(new IObserverCenter[this.observercenters.size()]);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < ocs.length; ++i) {
                        ocs[i].dispose();
                    }
                    ret.setResult(null);
                }
                catch (Exception e) {
                    ret.setException(e);
                }
            }
        });
        return ret;
    }

    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    public MObjectType getSpaceObjectType(String type) {
        return (MObjectType)this.objecttypes.get(type);
    }

    protected class AtomicCounter {
        long count_ = 0L;

        public synchronized Long getNext() {
            return this.count_++;
        }
    }
}

