/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.environment;

import jadex.bridge.service.types.clock.IClockService;
import jadex.commons.IValueFetcher;
import jadex.commons.SimplePropertyObject;
import jadex.extension.envsupport.environment.IEnvironmentSpace;
import jadex.extension.envsupport.environment.ISpaceProcess;
import jadex.javaparser.IParsedExpression;
import jadex.javaparser.SimpleValueFetcher;
import java.util.HashMap;
import java.util.Map;

public class DefaultObjectCreationProcess
extends SimplePropertyObject
implements ISpaceProcess {
    protected double lasttick;
    protected double lasttime;
    protected double lastrate;
    protected SimpleValueFetcher fetcher;

    @Override
    public void start(IClockService clock, IEnvironmentSpace space) {
        this.lasttick = clock.getTick();
        this.lasttime = clock.getTime();
        this.fetcher = new SimpleValueFetcher();
        this.fetcher.setValue("$space", (Object)space);
        this.fetcher.setValue("$clock", (Object)clock);
        if (this.getProperty("tickrate") != null) {
            this.lastrate = ((Number)this.getProperty("tickrate")).doubleValue();
            this.lasttick -= this.lastrate;
        } else if (this.getProperty("timerate") != null) {
            this.lastrate = ((Number)this.getProperty("timerate")).doubleValue();
            this.lasttime -= this.lastrate;
        }
    }

    @Override
    public void shutdown(IEnvironmentSpace space) {
    }

    @Override
    public void execute(IClockService clock, IEnvironmentSpace space) {
        Map props;
        String type;
        Boolean cond;
        double current;
        if (this.getProperty("tickrate") != null) {
            current = clock.getTick();
            while (this.lastrate > 0.0 && this.lasttick + this.lastrate < current) {
                cond = (Boolean)this.getProperty("condition");
                if (cond != null && !cond.booleanValue()) {
                    this.lasttick = clock.getTick();
                } else {
                    this.lasttick += this.lastrate;
                    type = (String)this.getProperty("type");
                    props = (Map)this.getProperty("properties");
                    props = props != null ? new HashMap(props) : null;
                    space.createSpaceObject(type, props, null);
                }
                this.lastrate = ((Number)this.getProperty("tickrate")).doubleValue();
            }
        }
        if (this.getProperty("timerate") != null) {
            current = clock.getTime();
            while (this.lastrate > 0.0 && this.lasttime + this.lastrate < current) {
                cond = (Boolean)this.getProperty("condition");
                if (cond != null && !cond.booleanValue()) {
                    this.lasttime = clock.getTime();
                } else {
                    this.lasttime += this.lastrate;
                    type = (String)this.getProperty("type");
                    props = (Map)this.getProperty("properties");
                    props = props != null ? new HashMap(props) : null;
                    space.createSpaceObject(type, props, null);
                }
                this.lastrate = ((Number)this.getProperty("timerate")).doubleValue();
            }
        }
    }

    public Object getProperty(String name) {
        Object ret = super.getProperty(name);
        if (ret instanceof IParsedExpression) {
            ret = ((IParsedExpression)ret).getValue((IValueFetcher)this.fetcher);
        }
        return ret;
    }
}

