/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.environment;

import jadex.bridge.ComponentTerminatedException;
import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.clock.IClockService;
import jadex.bridge.service.types.clock.ITimedObject;
import jadex.bridge.service.types.clock.ITimer;
import jadex.bridge.service.types.execution.IExecutionService;
import jadex.commons.ChangeEvent;
import jadex.commons.IChangeListener;
import jadex.commons.SimplePropertyObject;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.extension.envsupport.dataview.IDataView;
import jadex.extension.envsupport.environment.AbstractEnvironmentSpace;
import jadex.extension.envsupport.environment.ISpaceExecutor;
import jadex.extension.envsupport.environment.ISpaceProcess;
import jadex.extension.envsupport.environment.RoundBasedExecutor;
import jadex.extension.envsupport.environment.SpaceObject;
import jadex.extension.envsupport.evaluation.ITableDataConsumer;

public class DeltaTimeExecutor
extends SimplePropertyObject
implements ISpaceExecutor {
    protected long timestamp;
    protected IExternalAccess container;
    protected IChangeListener clocklistener;
    protected ITimer timer;
    protected boolean terminated;
    protected boolean scheduled;

    public DeltaTimeExecutor() {
    }

    public DeltaTimeExecutor(AbstractEnvironmentSpace space, boolean tick) {
        this.setProperty("space", space);
        this.setProperty("tick", tick);
    }

    @Override
    public void start() {
        this.terminated = false;
        final AbstractEnvironmentSpace space = (AbstractEnvironmentSpace)this.getProperty("space");
        final boolean tick = this.getProperty("tick") != null && (Boolean)this.getProperty("tick") != false;
        this.container = space.getExternalAccess();
        SServiceProvider.getService((IExternalAccess)this.container, IExecutionService.class, (String)"platform").addResultListener((IResultListener)new DefaultResultListener<IExecutionService>(){

            public void resultAvailable(final IExecutionService exeservice) {
                SServiceProvider.getService((IExternalAccess)DeltaTimeExecutor.this.container, IClockService.class, (String)"platform").addResultListener((IResultListener)new DefaultResultListener<IClockService>(){

                    public void resultAvailable(final IClockService clockservice) {
                        DeltaTimeExecutor.this.timestamp = clockservice.getTime();
                        Object[] procs = space.getProcesses().toArray();
                        for (int i = 0; i < procs.length; ++i) {
                            ISpaceProcess process = (ISpaceProcess)procs[i];
                            process.start(clockservice, space);
                        }
                        IComponentStep<Void> step = new IComponentStep<Void>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public IFuture<Void> execute(IInternalAccess ia) {
                                if (Boolean.TRUE.equals(DeltaTimeExecutor.this.getProperty("execution_monitoring"))) {
                                    RoundBasedExecutor.monitorExecution(space.getExternalAccess(), exeservice);
                                }
                                DeltaTimeExecutor.this.scheduled = false;
                                long currenttime = clockservice.getTime();
                                long progress = currenttime - DeltaTimeExecutor.this.timestamp;
                                DeltaTimeExecutor.this.timestamp = currenttime;
                                Object object = space.getMonitor();
                                synchronized (object) {
                                    Object[] objs = space.getSpaceObjectsCollection().toArray();
                                    for (int i = 0; i < objs.length; ++i) {
                                        SpaceObject obj = (SpaceObject)objs[i];
                                        obj.updateObject(space, progress, clockservice);
                                    }
                                    space.getComponentActionList().executeActions(null, true);
                                    Object[] procs = space.getProcesses().toArray();
                                    for (int i = 0; i < procs.length; ++i) {
                                        ISpaceProcess process = (ISpaceProcess)procs[i];
                                        process.execute(clockservice, space);
                                    }
                                    for (IDataView view : space.getViews()) {
                                        view.update(space);
                                    }
                                    for (ITableDataConsumer consumer : space.getDataConsumers()) {
                                        consumer.consumeData(currenttime, clockservice.getTick());
                                    }
                                    space.getPerceptList().processPercepts(null);
                                }
                                final 1 step = this;
                                if (tick) {
                                    DeltaTimeExecutor.this.timer = clockservice.createTickTimer(new ITimedObject(){

                                        public void timeEventOccurred(long currenttime) {
                                            if (!DeltaTimeExecutor.this.terminated) {
                                                try {
                                                    space.getExternalAccess().scheduleStep(step);
                                                }
                                                catch (ComponentTerminatedException componentTerminatedException) {
                                                    // empty catch block
                                                }
                                            }
                                        }

                                        public String toString() {
                                            return "DeltaTimeExecutor for " + DeltaTimeExecutor.this.container.getComponentIdentifier();
                                        }
                                    });
                                }
                                return IFuture.DONE;
                            }
                        };
                        step.execute(null);
                        if (!tick) {
                            DeltaTimeExecutor.this.clocklistener = new IChangeListener((IComponentStep)step){
                                final /* synthetic */ IComponentStep val$step;
                                {
                                    this.val$step = iComponentStep;
                                }

                                public void changeOccurred(ChangeEvent e) {
                                    if (!DeltaTimeExecutor.this.terminated && !DeltaTimeExecutor.this.scheduled) {
                                        DeltaTimeExecutor.this.scheduled = true;
                                        try {
                                            space.getExternalAccess().scheduleStep(this.val$step);
                                        }
                                        catch (ComponentTerminatedException componentTerminatedException) {
                                            // empty catch block
                                        }
                                    }
                                }
                            };
                            clockservice.addChangeListener(DeltaTimeExecutor.this.clocklistener);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void terminate() {
        this.terminated = true;
        SServiceProvider.getService((IExternalAccess)this.container, IClockService.class, (String)"platform").addResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object result) {
                IClockService clockservice = (IClockService)result;
                if (DeltaTimeExecutor.this.clocklistener != null) {
                    clockservice.removeChangeListener(DeltaTimeExecutor.this.clocklistener);
                } else if (DeltaTimeExecutor.this.timer != null) {
                    DeltaTimeExecutor.this.timer.cancel();
                }
            }
        });
    }
}

