/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.environment.space2d;

import jadex.bridge.service.types.cms.IComponentDescription;
import jadex.commons.SimplePropertyObject;
import jadex.commons.collection.MultiCollection;
import jadex.extension.envsupport.environment.AbstractEnvironmentSpace;
import jadex.extension.envsupport.environment.EnvironmentEvent;
import jadex.extension.envsupport.environment.IEnvironmentSpace;
import jadex.extension.envsupport.environment.IPerceptGenerator;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.environment.PerceptType;
import jadex.extension.envsupport.environment.space2d.Space2D;
import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector1Double;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class DefaultVisionGenerator
extends SimplePropertyObject
implements IPerceptGenerator {
    public static final String PROPERTY_MAXRANGE = "range";
    public static final String PROPERTY_RANGE = "range_property";
    public static final String PROPERTY_PERCEPTTYPES = "percepttypes";
    public static final String APPEARED = "appeared";
    public static final String DISAPPEARED = "disappeared";
    public static final String CREATED = "created";
    public static final String DESTROYED = "destroyed";
    public static final String MOVED = "moved";
    protected static final ISpaceObject[] EMPTY_SPACEOBJECTS = new ISpaceObject[0];
    protected MultiCollection<String, String> actiontypes;

    @Override
    public void componentAdded(IComponentDescription component, IEnvironmentSpace space) {
    }

    @Override
    public void componentRemoved(IComponentDescription component, IEnvironmentSpace space) {
    }

    @Override
    public void dispatchEnvironmentEvent(EnvironmentEvent event) {
        block10: {
            IVector2 pos;
            IVector1 maxrange;
            Space2D space;
            block11: {
                IComponentDescription eventowner;
                block9: {
                    String percepttype;
                    int i;
                    space = (Space2D)event.getSpace();
                    maxrange = this.getDefaultRange();
                    pos = (IVector2)event.getSpaceObject().getProperty("position");
                    eventowner = (IComponentDescription)event.getSpaceObject().getProperty("owner");
                    if (!"property_changed".equals(event.getType()) || !"position".equals(event.getProperty())) break block9;
                    IVector2 oldpos = (IVector2)event.getOldValue();
                    ISpaceObject[] objects = pos == null ? EMPTY_SPACEOBJECTS : space.getNearObjects(pos, maxrange).toArray(new ISpaceObject[0]);
                    ISpaceObject[] oldobjects = oldpos == null ? EMPTY_SPACEOBJECTS : space.getNearObjects(oldpos, maxrange).toArray(new ISpaceObject[0]);
                    for (i = 0; i < objects.length; ++i) {
                        IVector2 objpos = (IVector2)objects[i].getProperty("position");
                        IComponentDescription owner = (IComponentDescription)objects[i].getProperty("owner");
                        if (owner != null && (oldpos == null || space.getDistance(oldpos, objpos).greater(this.getRange(objects[i]))) && !space.getDistance(pos, objpos).greater(this.getRange(objects[i])) && (percepttype = this.getPerceptType(space, owner.getLocalType(), event.getSpaceObject().getType(), APPEARED)) != null) {
                            ((AbstractEnvironmentSpace)event.getSpace()).createPercept(percepttype, event.getSpaceObject(), owner, objects[i]);
                        }
                        if (eventowner != null && (oldpos == null || space.getDistance(oldpos, objpos).greater(this.getRange(event.getSpaceObject()))) && !space.getDistance(pos, objpos).greater(this.getRange(event.getSpaceObject())) && (percepttype = this.getPerceptType(space, eventowner.getLocalType(), objects[i].getType(), APPEARED)) != null) {
                            ((AbstractEnvironmentSpace)event.getSpace()).createPercept(percepttype, objects[i], eventowner, event.getSpaceObject());
                        }
                        if (owner == null || oldpos == null || space.getDistance(oldpos, objpos).greater(this.getRange(objects[i])) || space.getDistance(pos, objpos).greater(this.getRange(objects[i])) || (percepttype = this.getPerceptType(space, owner.getLocalType(), event.getSpaceObject().getType(), MOVED)) == null) continue;
                        ((AbstractEnvironmentSpace)event.getSpace()).createPercept(percepttype, event.getSpaceObject(), owner, objects[i]);
                    }
                    for (i = 0; i < oldobjects.length; ++i) {
                        IComponentDescription owner = (IComponentDescription)oldobjects[i].getProperty("owner");
                        IVector2 objpos = (IVector2)oldobjects[i].getProperty("position");
                        if (owner != null && !space.getDistance(oldpos, objpos).greater(this.getRange(oldobjects[i])) && (pos == null || space.getDistance(pos, objpos).greater(this.getRange(oldobjects[i]))) && (percepttype = this.getPerceptType(space, owner.getLocalType(), event.getSpaceObject().getType(), DISAPPEARED)) != null) {
                            ((AbstractEnvironmentSpace)event.getSpace()).createPercept(percepttype, event.getSpaceObject(), owner, oldobjects[i]);
                        }
                        if (eventowner == null || space.getDistance(oldpos, objpos).greater(this.getRange(event.getSpaceObject())) || pos != null && !space.getDistance(pos, objpos).greater(this.getRange(event.getSpaceObject())) || (percepttype = this.getPerceptType(space, eventowner.getLocalType(), oldobjects[i].getType(), DISAPPEARED)) == null) continue;
                        ((AbstractEnvironmentSpace)event.getSpace()).createPercept(percepttype, oldobjects[i], eventowner, event.getSpaceObject());
                    }
                    break block10;
                }
                if (!CREATED.equals(event.getType())) break block11;
                if (pos == null) break block10;
                ISpaceObject[] objects = space.getNearObjects(pos, maxrange).toArray(new ISpaceObject[0]);
                for (int i = 0; i < objects.length; ++i) {
                    String percepttype;
                    IComponentDescription owner = (IComponentDescription)objects[i].getProperty("owner");
                    IVector2 objpos = (IVector2)objects[i].getProperty("position");
                    if (owner != null && !space.getDistance(pos, objpos).greater(this.getRange(objects[i])) && (percepttype = this.getPerceptType(space, owner.getLocalType(), event.getSpaceObject().getType(), CREATED)) != null) {
                        ((AbstractEnvironmentSpace)event.getSpace()).createPercept(percepttype, event.getSpaceObject(), owner, objects[i]);
                    }
                    if (eventowner == null || space.getDistance(pos, objpos).greater(this.getRange(event.getSpaceObject())) || (percepttype = this.getPerceptType(space, eventowner.getLocalType(), objects[i].getType(), CREATED)) == null) continue;
                    ((AbstractEnvironmentSpace)event.getSpace()).createPercept(percepttype, objects[i], eventowner, event.getSpaceObject());
                }
                break block10;
            }
            if (DESTROYED.equals(event.getType()) && pos != null) {
                ISpaceObject[] objects = space.getNearObjects(pos, maxrange).toArray(new ISpaceObject[0]);
                for (int i = 0; i < objects.length; ++i) {
                    String percepttype;
                    IVector2 objpos;
                    IComponentDescription owner = (IComponentDescription)objects[i].getProperty("owner");
                    if (owner == null || space.getDistance(pos, objpos = (IVector2)objects[i].getProperty("position")).greater(this.getRange(objects[i])) || (percepttype = this.getPerceptType(space, owner.getLocalType(), event.getSpaceObject().getType(), DESTROYED)) == null) continue;
                    ((AbstractEnvironmentSpace)event.getSpace()).createPercept(percepttype, event.getSpaceObject(), owner, objects[i]);
                }
            }
        }
    }

    protected String getPerceptType(IEnvironmentSpace space, String componenttype, String objecttype, String actiontype) {
        String ret = null;
        Object[] percepttypes = this.getPerceptTypes();
        for (int i = 0; i < percepttypes.length; ++i) {
            PerceptType pt = space.getPerceptType(((String[])percepttypes[i])[0]);
            if (pt == null) {
                throw new RuntimeException("Unknown percept type: " + ((String[])percepttypes[i])[0]);
            }
            if (pt.getComponentTypes() != null && !pt.getComponentTypes().contains(componenttype) || pt.getObjectTypes() != null && !pt.getObjectTypes().contains(objecttype) || this.getActionTypes(pt) != null && !this.getActionTypes(pt).contains(actiontype)) continue;
            ret = pt.getName();
        }
        if (ret == null && "garbage".equals(objecttype)) {
            System.out.println("No percept found for: " + componenttype + " " + objecttype + " " + actiontype);
        }
        return ret;
    }

    protected Set<String> getActionTypes(PerceptType pt) {
        Set ret;
        if (this.actiontypes == null) {
            this.actiontypes = new MultiCollection(new HashMap(), HashSet.class);
            Object[] percepttypes = this.getPerceptTypes();
            for (int i = 0; i < percepttypes.length; ++i) {
                String[] per = (String[])percepttypes[i];
                for (int j = 1; j < per.length; ++j) {
                    this.actiontypes.add((Object)per[0], (Object)per[j]);
                }
            }
        }
        return (ret = (Set)this.actiontypes.get((Object)pt.getName())) == null ? Collections.EMPTY_SET : ret;
    }

    protected Object[] getPerceptTypes() {
        return (Object[])this.getProperty(PROPERTY_PERCEPTTYPES);
    }

    protected IVector1 getRange(ISpaceObject avatar) {
        Object tmp = avatar.getProperty(this.getRangePropertyName());
        return tmp == null ? this.getDefaultRange() : (tmp instanceof Number ? new Vector1Double(((Number)tmp).doubleValue()) : (IVector1)tmp);
    }

    protected IVector1 getDefaultRange() {
        Object tmp = this.getProperty(PROPERTY_MAXRANGE);
        return tmp == null ? Vector1Double.ZERO : (tmp instanceof Number ? new Vector1Double(((Number)tmp).doubleValue()) : (IVector1)tmp);
    }

    protected String getRangePropertyName() {
        Object tmp = this.getProperty(PROPERTY_RANGE);
        return tmp == null ? PROPERTY_MAXRANGE : (String)tmp;
    }
}

