/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.environment.space2d;

import jadex.commons.collection.MultiCollection;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.environment.space2d.Space2D;
import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector1Double;
import jadex.extension.envsupport.math.Vector1Int;
import jadex.extension.envsupport.math.Vector2Int;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Grid2D
extends Space2D {
    public static final String DEFAULT_NAME = Grid2D.class.getName();
    public static final String NEIGHBORHOOD_MOORE = "moore";
    public static final String NEIGHBORHOOD_VON_NEUMANN = "von_neumann";
    public static final String PROPERTY_NEIGHBORHOOD = "neighborhood";
    protected MultiCollection<IVector2, ISpaceObject> objectsygridpos;

    public Grid2D() {
        this(null);
    }

    public Grid2D(IVector2 areasize) {
        this(DEFAULT_NAME, areasize);
    }

    public Grid2D(Object name, IVector2 areasize) {
        super(areasize == null ? null : new Vector2Int(areasize.getXAsInteger(), areasize.getYAsInteger()));
        this.setProperty("name", name);
        this.objectsygridpos = new MultiCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAreaSize(IVector2 areasize) {
        Object object = this.monitor;
        synchronized (object) {
            this.areasize = areasize == null ? null : new Vector2Int(areasize.getXAsInteger(), areasize.getYAsInteger());
        }
    }

    public String getNeighborhood() {
        return this.getPropertyNames().contains(PROPERTY_NEIGHBORHOOD) ? (String)this.getProperty(PROPERTY_NEIGHBORHOOD) : NEIGHBORHOOD_VON_NEUMANN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ISpaceObject> getSpaceObjectsByGridPosition(IVector2 position, Object type) {
        ArrayList<ISpaceObject> ret = null;
        Object object = this.monitor;
        synchronized (object) {
            if (position != null) {
                position = this.adjustPosition(position);
                Vector2Int fieldpos = new Vector2Int(position.getXAsInteger(), position.getYAsInteger());
                ArrayList<ISpaceObject> simobjs = this.objectsygridpos.getCollection((Object)fieldpos);
                if (null == type) {
                    ret = simobjs;
                } else {
                    ArrayList<ISpaceObject> tmp = new ArrayList<ISpaceObject>();
                    for (ISpaceObject curobj : simobjs) {
                        if (!type.equals(curobj.getType())) continue;
                        tmp.add(curobj);
                    }
                    if (tmp.size() > 0) {
                        ret = tmp;
                    }
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVector2 getEmptyGridPosition() {
        Object object = this.monitor;
        synchronized (object) {
            Vector2Int ret = null;
            int n = 5;
            for (int i = 0; i < n && ret == null; ++i) {
                ret = new Vector2Int(this.getRandomPosition(Vector2Int.ZERO));
                if (!this.objectsygridpos.containsKey((Object)ret)) continue;
                ret = null;
            }
            if (ret == null) {
                for (int y = 0; ret == null && y < this.areasize.getYAsInteger(); ++y) {
                    for (int x = 0; ret == null && x < this.areasize.getXAsInteger(); ++x) {
                        ret = new Vector2Int(x, y);
                        if (!this.objectsygridpos.containsKey((Object)ret)) continue;
                        ret = null;
                    }
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVector2 getRandomGridPosition(IVector2 distance) {
        Object object = this.monitor;
        synchronized (object) {
            Vector2Int ret = null;
            ret = new Vector2Int(this.getRandomPosition(distance));
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPosition(Object id, IVector2 pos) {
        Object object = this.monitor;
        synchronized (object) {
            IVector2 newpos;
            ISpaceObject obj = this.getSpaceObject(id);
            IVector2 oldpos = (IVector2)obj.getProperty("position");
            if (oldpos != null && this.objectsygridpos.containsKey((Object)(oldpos = new Vector2Int(oldpos.getXAsInteger(), oldpos.getYAsInteger())))) {
                this.objectsygridpos.removeObject((Object)oldpos, (Object)obj);
            }
            if ((newpos = this.adjustPosition(pos)) != null) {
                this.objectsygridpos.add((Object)new Vector2Int(newpos.getXAsInteger(), newpos.getYAsInteger()), (Object)obj);
            }
            super.setPosition(id, newpos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initSpaceObject(ISpaceObject ret) {
        Object object = this.monitor;
        synchronized (object) {
            IVector2 pos;
            if (!ret.getPropertyNames().contains("position") && (pos = this.getEmptyGridPosition()) != null) {
                ret.setProperty("position", pos);
            }
            super.initSpaceObject(ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroyAndVerifySpaceObject(Object id) {
        boolean ret = false;
        try {
            Object object = this.monitor;
            synchronized (object) {
                IVector2 pos = (IVector2)this.getSpaceObject(id).getProperty("position");
                if (pos != null) {
                    Vector2Int fieldpos = new Vector2Int(pos.getXAsInteger(), pos.getYAsInteger());
                    this.objectsygridpos.removeObject((Object)fieldpos, this.spaceobjects.get(id));
                }
                super.destroySpaceObject(id);
                ret = true;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySpaceObject(Object id) {
        try {
            Object object = this.monitor;
            synchronized (object) {
                IVector2 pos = (IVector2)this.getSpaceObject(id).getProperty("position");
                if (pos != null) {
                    Vector2Int fieldpos = new Vector2Int(pos.getXAsInteger(), pos.getYAsInteger());
                    this.objectsygridpos.removeObject((Object)fieldpos, this.spaceobjects.get(id));
                }
                super.destroySpaceObject(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ISpaceObject> getNearGridObjects(IVector2 position, int range, String[] types) {
        Object object = this.monitor;
        synchronized (object) {
            HashSet<ISpaceObject> ret = new HashSet<ISpaceObject>();
            int sizex = this.areasize.getXAsInteger();
            int sizey = this.areasize.getYAsInteger();
            int x = position.getXAsInteger();
            int y = position.getYAsInteger();
            int minx = x - range >= 0 || this.getBorderMode().equals("torus") ? x - range : 0;
            int maxx = x + range <= sizex || this.getBorderMode().equals("torus") ? x + range : sizex;
            int miny = y - range >= 0 || this.getBorderMode().equals("torus") ? y - range : 0;
            int maxy = y + range <= sizey || this.getBorderMode().equals("torus") ? y + range : sizey;
            for (int i = minx; i <= maxx; ++i) {
                for (int j = miny; j <= maxy; ++j) {
                    Vector2Int testpos = new Vector2Int((i + sizex) % sizex, (j + sizey) % sizey);
                    Collection tmp = this.objectsygridpos.getCollection((Object)testpos);
                    if (tmp == null) continue;
                    if (types == null) {
                        ret.addAll(tmp);
                        continue;
                    }
                    for (ISpaceObject obj : tmp) {
                        for (int z = 0; z < types.length; ++z) {
                            if (!obj.getType().equals(types[z])) continue;
                            ret.add(obj);
                        }
                    }
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ISpaceObject> getNearObjects(IVector2 position, IVector1 distance, String type) {
        Object object = this.monitor;
        synchronized (object) {
            HashSet<ISpaceObject> ret = new HashSet<ISpaceObject>();
            int sizex = this.areasize.getXAsInteger();
            int sizey = this.areasize.getYAsInteger();
            int x = position.getXAsInteger();
            int y = position.getYAsInteger();
            Vector2Int pos = new Vector2Int(x, y);
            int range = distance.getAsInteger();
            int minx = x - range >= 0 || this.getBorderMode().equals("torus") ? x - range : 0;
            int maxx = x + range <= sizex || this.getBorderMode().equals("torus") ? x + range : sizex;
            int miny = y - range >= 0 || this.getBorderMode().equals("torus") ? y - range : 0;
            int maxy = y + range <= sizey || this.getBorderMode().equals("torus") ? y + range : sizey;
            for (int i = minx; i <= maxx; ++i) {
                for (int j = miny; j <= maxy; ++j) {
                    Collection tmp;
                    Vector2Int testpos = new Vector2Int((i + sizex) % sizex, (j + sizey) % sizey);
                    if (this.getDistance(testpos, pos).greater(distance) || (tmp = this.objectsygridpos.getCollection((Object)testpos)) == null) continue;
                    if (type == null) {
                        ret.addAll(tmp);
                        continue;
                    }
                    for (ISpaceObject obj : tmp) {
                        if (!obj.getType().equals(type)) continue;
                        ret.add(obj);
                    }
                }
            }
            return ret;
        }
    }

    @Override
    public IVector1 calculateDistance(IVector1 dx, IVector1 dy) {
        if (NEIGHBORHOOD_MOORE.equals(this.getNeighborhood())) {
            return dx.greater(dy) ? dx : dy;
        }
        if (NEIGHBORHOOD_VON_NEUMANN.equals(this.getNeighborhood())) {
            if (dx.less(Vector1Double.ZERO)) {
                dx = dx.copy().negate();
            }
            if (dy.less(Vector1Double.ZERO)) {
                dy = dy.copy().negate();
            }
        }
        return dx.add(dy);
    }

    public IVector1 getShortestDirection(IVector1 pos1, IVector1 pos2, boolean isx) {
        IVector1 ret = Vector1Int.ZERO;
        if (this.getBorderMode().equals("torus")) {
            IVector1 size;
            IVector1 iVector1 = size = isx ? this.areasize.getX() : this.areasize.getY();
            if (pos1.less(pos2)) {
                IVector1 d2;
                IVector1 d1 = pos2.copy().subtract(pos1);
                ret = d1.less(d2 = pos1.copy().add(size).subtract(pos2)) ? new Vector1Int(1) : new Vector1Int(-1);
            } else if (pos1.greater(pos2)) {
                IVector1 d2;
                IVector1 d1 = pos1.copy().subtract(pos2);
                ret = d1.less(d2 = pos2.copy().add(size).subtract(pos1)) ? new Vector1Int(-1) : new Vector1Int(1);
            }
        } else if (pos1.less(pos2)) {
            ret = new Vector1Int(1);
        } else if (pos1.greater(pos2)) {
            ret = new Vector1Int(-1);
        }
        return ret;
    }
}

