/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.environment.space2d;

import jadex.commons.IFilter;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.math.IVector2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class KdNode {
    protected int maxLeafNodeSize;
    protected int maxMedianSamples;
    protected IKdValueFetcher fetcher;
    protected KdNode left;
    protected KdNode right;
    protected double hyperplane;
    protected List<ISpaceObject> content;

    protected KdNode(List<ISpaceObject> input, Random random) {
        this(input, random, KdValueFetcherX.FETCHER, 6, 10);
    }

    protected KdNode(List<ISpaceObject> input, Random random, int maxLeafNodeSize, int maxMedianSamples) {
        this(input, random, KdValueFetcherX.FETCHER, maxLeafNodeSize, maxMedianSamples);
    }

    protected KdNode(List<ISpaceObject> input, Random random, IKdValueFetcher fetcher, int maxLeafNodeSize, int maxMedianSamples) {
        this.fetcher = fetcher;
        this.maxLeafNodeSize = maxLeafNodeSize;
        this.maxMedianSamples = maxMedianSamples;
        if (input != null) {
            if (input.size() <= maxLeafNodeSize) {
                this.content = input;
            } else {
                this.hyperplane = this.estimateMedian(input, random, fetcher);
                int halfSize = input.size() >> 1;
                ArrayList<ISpaceObject> leftList = new ArrayList<ISpaceObject>(halfSize);
                ArrayList<ISpaceObject> rightList = new ArrayList<ISpaceObject>(halfSize);
                for (ISpaceObject obj : input) {
                    if (fetcher.getValue(KdNode.getPosition(obj)) < this.hyperplane) {
                        leftList.add(obj);
                        continue;
                    }
                    rightList.add(obj);
                }
                if (leftList.size() > 0 && rightList.size() > 0) {
                    this.left = new KdNode(leftList, random, fetcher.nextFetcher(), maxLeafNodeSize, maxMedianSamples);
                    this.right = new KdNode(rightList, random, fetcher.nextFetcher(), maxLeafNodeSize, maxMedianSamples);
                } else {
                    this.content = input;
                }
            }
        }
    }

    public List<ISpaceObject> getNearestObjects(IVector2 point, double radiusSquared, IFilter filter) {
        List<ISpaceObject> ret = null;
        if (this.content != null) {
            ret = new LinkedList<ISpaceObject>();
            for (ISpaceObject obj : this.content) {
                if (!(KdNode.getDistance(obj, point).getSquaredLength().getAsDouble() < radiusSquared) || filter != null && !filter.filter((Object)obj)) continue;
                ret.add(obj);
            }
        } else if (this.left != null) {
            double diff = this.fetcher.getValue(point) - this.hyperplane;
            double distFromMedian2 = Math.abs(diff);
            if ((distFromMedian2 *= distFromMedian2) < radiusSquared) {
                ret = this.left.getNearestObjects(point, radiusSquared, filter);
                ret.addAll(this.right.getNearestObjects(point, radiusSquared, filter));
            } else {
                ret = diff < 0.0 ? this.left.getNearestObjects(point, radiusSquared, filter) : this.right.getNearestObjects(point, radiusSquared, filter);
            }
        }
        return ret;
    }

    public ISpaceObject getNearestObject(IVector2 point, double radiusSquared) {
        return this.getNearestObject(point, radiusSquared, null);
    }

    public ISpaceObject getNearestObject(IVector2 point, double radiusSquared, IFilter filter) {
        ISpaceObject ret = null;
        if (this.content != null) {
            double lengthSquared = Double.MAX_VALUE;
            for (ISpaceObject obj : this.content) {
                IVector2 dist = KdNode.getDistance(obj, point);
                double sqLength = dist.getSquaredLength().getAsDouble();
                if (!(sqLength < lengthSquared) || !filter.filter((Object)obj)) continue;
                ret = obj;
                lengthSquared = sqLength;
            }
        } else if (this.left != null) {
            double diff = this.fetcher.getValue(point) - this.hyperplane;
            double distFromMedian2 = Math.abs(diff);
            if ((distFromMedian2 *= distFromMedian2) < radiusSquared) {
                ret = this.left.getNearestObject(point, radiusSquared, filter);
                ISpaceObject rightBest = this.right.getNearestObject(point, radiusSquared, filter);
                if (rightBest != null) {
                    if (ret == null) {
                        ret = rightBest;
                    } else if (KdNode.getDistance(rightBest, point).getSquaredLength().getAsDouble() < KdNode.getDistance(ret, point).getSquaredLength().getAsDouble()) {
                        ret = rightBest;
                    }
                }
            } else if (diff < 0.0) {
                ret = this.left.getNearestObject(point, radiusSquared, filter);
            } else {
                this.right.getNearestObject(point, radiusSquared, filter);
            }
        }
        return ret;
    }

    protected double estimateMedian(List<ISpaceObject> input, Random random, IKdValueFetcher fetcher) {
        ISpaceObject[] samples = new ISpaceObject[Math.min(input.size(), this.maxMedianSamples)];
        for (int i = 0; i < samples.length; ++i) {
            samples[i] = input.get(random.nextInt(input.size()));
        }
        Arrays.sort(samples, fetcher.getComparator());
        int mIndex = this.maxMedianSamples >> 1;
        return fetcher.getValue(KdNode.getPosition(samples[mIndex + 1]));
    }

    protected static final IVector2 getPosition(ISpaceObject obj) {
        return (IVector2)obj.getProperty("position");
    }

    protected static final IVector2 getDistance(ISpaceObject obj, IVector2 point) {
        return KdNode.getPosition(obj).copy().subtract(point);
    }

    protected static class KdValueFetcherY
    implements IKdValueFetcher {
        public static final KdValueFetcherY FETCHER = new KdValueFetcherY();
        protected static final Comparator COMPARATOR = new Comparator<ISpaceObject>(){

            @Override
            public int compare(ISpaceObject o1, ISpaceObject o2) {
                return (int)Math.signum(FETCHER.getValue(KdNode.getPosition(o1)) - FETCHER.getValue(KdNode.getPosition(o2)));
            }
        };

        protected KdValueFetcherY() {
        }

        @Override
        public double getValue(IVector2 point) {
            return point.getYAsDouble();
        }

        @Override
        public IKdValueFetcher nextFetcher() {
            return KdValueFetcherX.FETCHER;
        }

        @Override
        public Comparator<ISpaceObject> getComparator() {
            return COMPARATOR;
        }
    }

    protected static class KdValueFetcherX
    implements IKdValueFetcher {
        public static final KdValueFetcherX FETCHER = new KdValueFetcherX();
        protected static final Comparator COMPARATOR = new Comparator<ISpaceObject>(){

            @Override
            public int compare(ISpaceObject o1, ISpaceObject o2) {
                return (int)Math.signum(FETCHER.getValue(KdNode.getPosition(o1)) - FETCHER.getValue(KdNode.getPosition(o2)));
            }
        };

        protected KdValueFetcherX() {
        }

        @Override
        public double getValue(IVector2 point) {
            return point.getXAsDouble();
        }

        @Override
        public IKdValueFetcher nextFetcher() {
            return KdValueFetcherY.FETCHER;
        }

        @Override
        public Comparator<ISpaceObject> getComparator() {
            return COMPARATOR;
        }
    }

    protected static interface IKdValueFetcher {
        public double getValue(IVector2 var1);

        public IKdValueFetcher nextFetcher();

        public Comparator<ISpaceObject> getComparator();
    }
}

