/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.environment.space3d;

import jadex.commons.IFilter;
import jadex.extension.envsupport.environment.AbstractEnvironmentSpace;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector3;
import jadex.extension.envsupport.math.Vector1Double;
import jadex.extension.envsupport.math.Vector3Double;
import jadex.extension.envsupport.math.Vector3Int;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class Space3D
extends AbstractEnvironmentSpace {
    public static final String PROPERTY_POSITION = "position";
    public static final String PROPERTY_BORDER = "border";
    public static final String BORDER_STRICT = "strict";
    public static final String BORDER_RELAXED = "relaxed";
    public static final String BORDER_TORUS = "torus";
    protected IVector3 areasize;

    protected Space3D(IVector3 areasize) {
        this.areasize = areasize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVector3 getAreaSize() {
        Object object = this.monitor;
        synchronized (object) {
            return this.areasize.copy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAreaSize(IVector3 areasize) {
        Object object = this.monitor;
        synchronized (object) {
            this.areasize = areasize;
        }
    }

    public String getBorderMode() {
        return this.getPropertyNames().contains(PROPERTY_BORDER) ? (String)this.getProperty(PROPERTY_BORDER) : BORDER_TORUS;
    }

    @Override
    public void initSpaceObject(ISpaceObject ret) {
        IVector3 pos;
        super.initSpaceObject(ret);
        IVector3 iVector3 = pos = ret.getPropertyNames().contains(PROPERTY_POSITION) ? (IVector3)ret.getProperty(PROPERTY_POSITION) : this.getRandomPosition(Vector3Int.ZERO);
        if (pos != null) {
            ret.setProperty(PROPERTY_POSITION, null);
            this.setPosition(ret.getId(), pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPosition(Object id, IVector3 pos) {
        Object object = this.monitor;
        synchronized (object) {
            ISpaceObject obj = this.getSpaceObject(id);
            if (obj == null) {
                throw new RuntimeException("Space object not found: " + id);
            }
            IVector3 newpos = this.adjustPosition(pos);
            obj.setProperty(PROPERTY_POSITION, newpos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVector1 getDistance(IVector3 pos1, IVector3 pos2) {
        Object object = this.monitor;
        synchronized (object) {
            IVector1 dx = this.getDistance(pos1.getX(), pos2.getX(), true);
            IVector1 dy = this.getDistance(pos1.getY(), pos2.getY(), false);
            IVector1 dz = this.getDistance(pos1.getZ(), pos2.getZ(), false);
            IVector1 ret = this.calculateDistance(dx, dy, dz);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVector1 getDistance(IVector1 pos1, IVector1 pos2, boolean isx) {
        Object object = this.monitor;
        synchronized (object) {
            IVector1 ret = null;
            if (BORDER_TORUS.equals(this.getBorderMode())) {
                IVector1 d2;
                IVector1 d1;
                IVector1 size;
                IVector1 iVector1 = size = isx ? this.areasize.getX() : this.areasize.getY();
                if (pos1.greater(pos2)) {
                    IVector1 tmp = pos1;
                    pos1 = pos2;
                    pos2 = tmp;
                }
                ret = (d1 = pos2.copy().subtract(pos1)).less(d2 = pos1.copy().add(size).subtract(pos2)) ? d1 : d2;
            } else {
                ret = pos1.getDistance(pos2);
            }
            return ret;
        }
    }

    public IVector1 calculateDistance(IVector1 dx, IVector1 dy, IVector1 dz) {
        IVector1 x2 = dx.copy().multiply(dx);
        IVector1 y2 = dy.copy().multiply(dy);
        IVector1 z2 = dz.copy().multiply(dz);
        return x2.add(y2).add(z2).sqrt();
    }

    public IVector3 adjustPosition(IVector3 pos) {
        IVector3 ret = null;
        if (pos != null) {
            IVector1 sizex = this.areasize.getX();
            IVector1 sizey = this.areasize.getY();
            IVector1 sizez = this.areasize.getZ();
            if (BORDER_TORUS.equals(this.getBorderMode())) {
                IVector1 x = pos.getX().copy();
                IVector1 y = pos.getY().copy();
                IVector1 z = pos.getZ().copy();
                while (x.less(Vector1Double.ZERO)) {
                    x.add(sizex);
                }
                while (y.less(Vector1Double.ZERO)) {
                    y.add(sizey);
                }
                while (z.less(Vector1Double.ZERO)) {
                    z.add(sizez);
                }
                x = x.copy().mod(sizex);
                y = y.copy().mod(sizey);
                z = z.copy().mod(sizez);
                ret = Vector3Double.getVector3(x.getAsDouble(), y.getAsDouble(), z.getAsDouble());
            } else if (BORDER_STRICT.equals(this.getBorderMode())) {
                if (pos.getX().greater(sizex) || pos.getX().less(Vector1Double.ZERO) || pos.getY().greater(sizey) || pos.getY().less(Vector1Double.ZERO) || pos.getZ().greater(sizez) || pos.getZ().less(Vector1Double.ZERO)) {
                    throw new RuntimeException("Position out of areasize: " + pos + " " + this.areasize);
                }
                ret = pos;
            } else if (BORDER_RELAXED.equals(this.getBorderMode())) {
                ret = pos;
            } else {
                throw new RuntimeException("Unknown bordermode: " + this.getBorderMode());
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVector3 getRandomPosition(IVector3 distance) {
        Object object = this.monitor;
        synchronized (object) {
            if (distance == null) {
                distance = Vector3Double.ZERO;
            }
            IVector3 position = this.areasize.copy();
            position.subtract(distance);
            position.randomX(distance.getX(), position.getX());
            position.randomY(distance.getY(), position.getY());
            position.randomZ(distance.getZ(), position.getZ());
            return position;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISpaceObject getNearestObject(IVector3 position, IVector1 maxdist, String type) {
        ISpaceObject ret = null;
        Object object = this.monitor;
        synchronized (object) {
            ISpaceObject nearest = null;
            IVector1 distance = null;
            ISpaceObject[] objects = type != null ? this.getSpaceObjectsByType(type) : (ISpaceObject[])this.getSpaceObjects();
            for (int i = 0; objects != null && i < objects.length; ++i) {
                IVector3 curpos = (IVector3)objects[i].getProperty(PROPERTY_POSITION);
                if (curpos == null) continue;
                IVector1 objdist = this.getDistance(curpos, position);
                if (nearest != null && !objdist.less(distance)) continue;
                nearest = objects[i];
                distance = objdist;
            }
            if (maxdist == null || distance != null && !maxdist.less(distance)) {
                ret = nearest;
            }
            return ret;
        }
    }

    public Set getNearObjects(IVector3 position, IVector1 maxdist) {
        return this.getNearObjects(position, maxdist, (IFilter)null);
    }

    public Set getNearObjects(IVector3 position, IVector1 maxdist, final String type) {
        return this.getNearObjects(position, maxdist, new IFilter(){

            public boolean filter(Object obj) {
                return type.equals(((ISpaceObject)obj).getType());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getNearObjects(IVector3 position, IVector1 maxdist, IFilter filter) {
        Object object = this.monitor;
        synchronized (object) {
            HashSet<ISpaceObject> ret = new HashSet<ISpaceObject>();
            Set objects = this.spaceobjects.entrySet();
            for (Map.Entry entry : objects) {
                ISpaceObject obj = (ISpaceObject)entry.getValue();
                IVector3 pos = (IVector3)obj.getProperty(PROPERTY_POSITION);
                if (pos == null || filter != null && !filter.filter((Object)obj)) continue;
                IVector1 dist = this.getDistance(pos, position);
                if (maxdist != null && maxdist.less(dist)) continue;
                ret.add(obj);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getSpaceObjects() {
        Object object = this.monitor;
        synchronized (object) {
            return this.spaceobjects.values().toArray();
        }
    }
}

