/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.evaluation;

import jadex.commons.ResourceInfo;
import jadex.extension.envsupport.evaluation.AbstractChartDataConsumer;
import jadex.extension.envsupport.evaluation.DataTable;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class CategoryChartDataConsumer
extends AbstractChartDataConsumer {
    @Override
    protected JFreeChart createChart() {
        String title = (String)this.getProperty("title");
        String labelx = (String)this.getProperty("labelx");
        String labely = (String)this.getProperty("labely");
        boolean legend = this.getProperty("legend") == null ? true : (Boolean)this.getProperty("legend");
        boolean tooltips = this.getProperty("tooltips") == null ? true : (Boolean)this.getProperty("tooltips");
        boolean urls = this.getProperty("urls") == null ? false : (Boolean)this.getProperty("urls");
        boolean autorepaint = this.getProperty("autorepaint") == null ? false : (Boolean)this.getProperty("autorepaint");
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        JFreeChart chart = ChartFactory.createLineChart((String)title, (String)labelx, (String)labely, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)tooltips, (boolean)urls);
        chart.setNotify(autorepaint);
        String bgimagefn = (String)this.getProperty("bgimage");
        if (bgimagefn != null) {
            try {
                ClassLoader cl = this.getSpace().getClassLoader();
                ResourceInfo rinfo = this.getResourceInfo(bgimagefn, this.getSpace().getExternalAccess().getModel().getAllImports(), cl);
                BufferedImage image = ImageIO.read(rinfo.getInputStream());
                rinfo.getInputStream().close();
                chart.getPlot().setBackgroundImage((Image)image);
            }
            catch (Exception e) {
                System.out.println("Background image not found: " + bgimagefn);
            }
        }
        return chart;
    }

    @Override
    protected void addValue(Comparable seriesname, Object valx, Object valy, DataTable data, Object[] row) {
        DefaultCategoryDataset dataset = (DefaultCategoryDataset)((CategoryPlot)this.getChart().getPlot()).getDataset();
        dataset.addValue(((Double)valy).doubleValue(), seriesname, (Comparable)valx);
    }
}

