/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.evaluation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataTable {
    protected String name;
    protected String[] columnnames;
    protected List rows;
    protected Map columns;

    public DataTable(String name, String[] columnnames) {
        this.name = name;
        this.columnnames = columnnames;
        this.columns = new HashMap();
        for (int i = 0; i < columnnames.length; ++i) {
            this.columns.put(columnnames[i], i);
        }
    }

    public void addRow(Object[] row) {
        if (row.length != this.columnnames.length) {
            throw new IllegalArgumentException("Data row must have same length as table: " + row.length + " " + this.columnnames.length);
        }
        if (this.rows == null) {
            this.rows = new ArrayList();
        }
        this.rows.add(row);
    }

    public List getRows() {
        return this.rows == null ? Collections.EMPTY_LIST : this.rows;
    }

    public String[] getColumnNames() {
        return this.columnnames;
    }

    public int getColumnIndex(String columnname) {
        Integer ret = (Integer)this.columns.get(columnname);
        return ret == null ? -1 : ret;
    }

    public Object getData(int row, int column) {
        return ((Object[])this.rows.get(row))[column];
    }

    public String getName() {
        return this.name;
    }
}

