/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.evaluation;

import jadex.commons.IValueFetcher;
import jadex.commons.SUtil;
import jadex.extension.envsupport.environment.AbstractEnvironmentSpace;
import jadex.extension.envsupport.evaluation.DataTable;
import jadex.extension.envsupport.evaluation.IObjectSource;
import jadex.extension.envsupport.evaluation.ITableDataProvider;
import jadex.javaparser.IParsedExpression;
import jadex.javaparser.SimpleValueFetcher;
import java.util.List;
import java.util.Map;

public class DefaultDataProvider
implements ITableDataProvider {
    protected AbstractEnvironmentSpace envspace;
    protected IObjectSource[] rowproviders;
    protected String tablename;
    protected String[] columnnames;
    protected IParsedExpression[] exps;

    public DefaultDataProvider(AbstractEnvironmentSpace envspace, IObjectSource[] rowproviders, String tablename, String[] columnnames, IParsedExpression[] exps) {
        this.envspace = envspace;
        this.rowproviders = rowproviders;
        this.tablename = tablename;
        this.columnnames = columnnames;
        this.exps = exps;
    }

    @Override
    public DataTable getTableData(long time, double tick) {
        DataTable ret = new DataTable(this.tablename, this.columnnames);
        Object[] names = new String[this.rowproviders.length];
        Object[] values = new Object[this.rowproviders.length];
        for (int i = 0; i < this.rowproviders.length; ++i) {
            names[i] = this.rowproviders[i].getSourceName();
            values[i] = this.rowproviders[i].getObjects();
        }
        List res = SUtil.calculateCartesianProduct((Object[])names, (Object[])values);
        SimpleValueFetcher fetcher = new SimpleValueFetcher();
        fetcher.setValue("$space", (Object)this.envspace);
        fetcher.setValue("$time", (Object)time);
        fetcher.setValue("$tick", (Object)tick);
        for (int i = 0; i < res.size(); ++i) {
            Map binding = (Map)res.get(i);
            for (String key : binding.keySet()) {
                Object val = binding.get(key);
                fetcher.setValue(key, val);
            }
            Object[] row = new Object[this.exps.length];
            for (int j = 0; j < this.exps.length; ++j) {
                row[j] = this.exps[j].getValue((IValueFetcher)fetcher);
            }
            ret.addRow(row);
        }
        return ret;
    }
}

