/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.evaluation;

import jadex.commons.ResourceInfo;
import jadex.extension.envsupport.evaluation.AbstractChartDataConsumer;
import jadex.extension.envsupport.evaluation.DataTable;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.statistics.SimpleHistogramBin;
import org.jfree.data.statistics.SimpleHistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class HistogramDataConsumer
extends AbstractChartDataConsumer {
    @Override
    protected JFreeChart createChart() {
        String title = (String)this.getProperty("title");
        String labelx = (String)this.getProperty("labelx");
        String labely = (String)this.getProperty("labely");
        boolean legend = this.getProperty("legend") == null ? true : (Boolean)this.getProperty("legend");
        boolean tooltips = this.getProperty("tooltips") == null ? true : (Boolean)this.getProperty("tooltips");
        boolean urls = this.getProperty("urls") == null ? false : (Boolean)this.getProperty("urls");
        boolean autorepaint = this.getProperty("autorepaint") == null ? false : (Boolean)this.getProperty("autorepaint");
        String seriesname = (String)this.getProperty("seriesname");
        SimpleHistogramDataset dataset = new SimpleHistogramDataset((Comparable)((Object)seriesname));
        Number low = (Number)this.getProperty("lowvalue");
        Number high = (Number)this.getProperty("highvalue");
        Number bincnt = (Number)this.getProperty("bincount");
        if (low != null && high != null) {
            int cnt = bincnt != null ? bincnt.intValue() : 1;
            double lv = low.doubleValue();
            double hv = high.doubleValue();
            double bsize = (hv - lv) / (double)cnt;
            for (int i = 0; i < cnt; ++i) {
                dataset.addBin(new SimpleHistogramBin(lv + (double)i * bsize, lv + (double)(i + 1) * bsize, true, false));
            }
        } else {
            int i = 0;
            while (true) {
                Number lb = i == 0 && this.getPropertyNames().contains("lowbin") ? (Number)((Number)this.getProperty("lowbin")) : (Number)((Number)this.getProperty("lowbin_" + i));
                Number hb = i == 0 && this.getPropertyNames().contains("highbin") ? (Number)((Number)this.getProperty("highbin")) : (Number)((Number)this.getProperty("highhbin_" + i));
                if (lb == null || hb == null) break;
                dataset.addBin(new SimpleHistogramBin(lb.doubleValue(), hb.doubleValue(), true, false));
                ++i;
            }
        }
        if (dataset.getItemCount(0) == 0) {
            throw new RuntimeException("No bins defined.");
        }
        JFreeChart chart = ChartFactory.createHistogram((String)title, (String)labelx, (String)labely, (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)tooltips, (boolean)urls);
        chart.setNotify(autorepaint);
        String bgimagefn = (String)this.getProperty("bgimage");
        if (bgimagefn != null) {
            try {
                ClassLoader cl = this.getSpace().getClassLoader();
                ResourceInfo rinfo = this.getResourceInfo(bgimagefn, this.getSpace().getExternalAccess().getModel().getAllImports(), cl);
                BufferedImage image = ImageIO.read(rinfo.getInputStream());
                rinfo.getInputStream().close();
                chart.getPlot().setBackgroundImage((Image)image);
            }
            catch (Exception e) {
                System.out.println("Background image not found: " + bgimagefn);
            }
        }
        return chart;
    }

    @Override
    protected void addValue(Comparable seriesname, Object valx, Object valy, DataTable data, Object[] row) {
        double val = ((Number)valy).doubleValue();
        Number low = (Number)this.getProperty("lowvalue");
        Number high = (Number)this.getProperty("highvalue");
        if (val >= low.doubleValue() && val <= high.doubleValue()) {
            SimpleHistogramDataset dataset = (SimpleHistogramDataset)((XYPlot)this.getChart().getPlot()).getDataset();
            dataset.addObservation(val);
        }
    }
}

