/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.evaluation;

import jadex.commons.ResourceInfo;
import jadex.extension.envsupport.evaluation.AbstractChartDataConsumer;
import jadex.extension.envsupport.evaluation.DataTable;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;
import org.jfree.data.xy.XYDataset;

public class TimeChartDataConsumer
extends AbstractChartDataConsumer {
    protected Map seriesmap = new HashMap();

    @Override
    protected JFreeChart createChart() {
        String title = (String)this.getProperty("title");
        String labelx = (String)this.getProperty("labelx");
        String labely = (String)this.getProperty("labely");
        boolean legend = this.getProperty("legend") == null ? true : (Boolean)this.getProperty("legend");
        boolean tooltips = this.getProperty("tooltips") == null ? true : (Boolean)this.getProperty("tooltips");
        boolean urls = this.getProperty("urls") == null ? false : (Boolean)this.getProperty("urls");
        boolean autorepaint = this.getProperty("autorepaint") == null ? false : (Boolean)this.getProperty("autorepaint");
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)title, (String)labelx, (String)labely, (XYDataset)dataset, (boolean)legend, (boolean)tooltips, (boolean)urls);
        chart.setNotify(autorepaint);
        String bgimagefn = (String)this.getProperty("bgimage");
        if (bgimagefn != null) {
            try {
                ClassLoader cl = this.getSpace().getClassLoader();
                ResourceInfo rinfo = this.getResourceInfo(bgimagefn, this.getSpace().getExternalAccess().getModel().getAllImports(), cl);
                BufferedImage image = ImageIO.read(rinfo.getInputStream());
                rinfo.getInputStream().close();
                chart.getPlot().setBackgroundImage((Image)image);
            }
            catch (Exception e) {
                System.out.println("Background image not found: " + bgimagefn);
            }
        }
        return chart;
    }

    @Override
    protected void addValue(Comparable seriesname, Object valx, Object valy, DataTable data, Object[] row) {
        int seriesnum = 0;
        TimeSeriesCollection dataset = (TimeSeriesCollection)((XYPlot)this.getChart().getPlot()).getDataset();
        int sercnt = dataset.getSeriesCount();
        Integer sernum = (Integer)this.seriesmap.get(seriesname);
        seriesnum = sernum != null ? sernum : sercnt;
        Class time = this.getProperty("timescale") != null ? (Class)this.getProperty("timescale") : Millisecond.class;
        for (int j = sercnt; j <= seriesnum; ++j) {
            TimeSeries series;
            Integer maxitemcnt = (Integer)this.getProperty("maxitemcount");
            if (seriesname != null) {
                series = new TimeSeries(seriesname, time);
                if (maxitemcnt != null) {
                    series.setMaximumItemCount(maxitemcnt.intValue());
                }
                this.seriesmap.put(seriesname, j);
            } else {
                series = new TimeSeries((Comparable)Integer.valueOf(j), time);
                if (maxitemcnt != null) {
                    series.setMaximumItemCount(maxitemcnt.intValue());
                }
                this.seriesmap.put(j, j);
            }
            dataset.addSeries(series);
        }
        TimeSeries ser = dataset.getSeries(seriesnum);
        Millisecond t = null;
        if (Millisecond.class.equals((Object)time) || time == null) {
            t = new Millisecond(new Date(((Number)valx).longValue()));
        } else if (Second.class.equals((Object)time)) {
            t = new Second(new Date(((Number)valx).longValue()));
        } else if (Hour.class.equals((Object)time)) {
            t = new Hour(new Date(((Number)valx).longValue()));
        } else if (Day.class.equals((Object)time)) {
            t = new Day(new Date(((Number)valx).longValue()));
        } else if (Week.class.equals((Object)time)) {
            t = new Week(new Date(((Number)valx).longValue()));
        } else if (Month.class.equals((Object)time)) {
            t = new Month(new Date(((Number)valx).longValue()));
        } else if (Quarter.class.equals((Object)time)) {
            t = new Quarter(new Date(((Number)valx).longValue()));
        } else if (Year.class.equals((Object)time)) {
            t = new Year(new Date(((Number)valx).longValue()));
        }
        ser.addOrUpdate((RegularTimePeriod)t, ((Number)valy).doubleValue());
    }
}

