/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.math;

import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector2Double;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class Vector1Double
implements IVector1 {
    public static final IVector1 ZERO = new Vector1Double(0.0);
    private double x_;

    public Vector1Double(double value) {
        this.x_ = value;
    }

    public Vector1Double() {
    }

    @Override
    public IVector1 add(IVector1 vector) {
        this.x_ += vector.getAsDouble();
        return this;
    }

    @Override
    public IVector1 subtract(IVector1 vector) {
        this.x_ -= vector.getAsDouble();
        return this;
    }

    @Override
    public IVector1 multiply(IVector1 vector) {
        this.x_ *= vector.getAsDouble();
        return this;
    }

    @Override
    public IVector1 zero() {
        this.x_ = 0.0;
        return this;
    }

    @Override
    public IVector1 negate() {
        this.x_ = -this.x_;
        return this;
    }

    @Override
    public IVector1 sqrt() {
        this.x_ = Math.sqrt(this.x_);
        return this;
    }

    @Override
    public IVector1 mod(IVector1 mod) {
        this.x_ %= mod.getAsDouble();
        return this;
    }

    @Override
    public IVector1 getDistance(IVector1 vector) {
        double distance = Math.abs(Math.abs(this.x_) - Math.abs(vector.getAsDouble()));
        return new Vector1Double(distance);
    }

    @Override
    public int getAsInteger() {
        return (int)Math.round(this.x_);
    }

    @Override
    public long getAsLong() {
        return Math.round(this.x_);
    }

    @Override
    public float getAsFloat() {
        return (float)this.x_;
    }

    @Override
    public double getAsDouble() {
        return this.x_;
    }

    public void setAsDouble(double x) {
        this.x_ = x;
    }

    @Override
    public BigDecimal getAsBigDecimal() {
        return new BigDecimal(this.x_);
    }

    @Override
    public IVector1 copy() {
        return new Vector1Double(this.x_);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IVector1) {
            return this.equals((IVector1)obj);
        }
        return false;
    }

    @Override
    public boolean equals(IVector1 vector) {
        return Double.doubleToLongBits(this.x_) == Double.doubleToLongBits(vector.getAsDouble());
    }

    public int hashCode() {
        return (int)this.x_;
    }

    @Override
    public boolean greater(IVector1 vector) {
        return this.x_ > vector.getAsDouble();
    }

    @Override
    public boolean less(IVector1 vector) {
        return this.x_ < vector.getAsDouble();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        DecimalFormat format = new DecimalFormat("####.####");
        if (this.x_ < 1000.0 || this.x_ > 0.001) {
            buffer.append(format.format(this.x_));
        } else {
            buffer.append(Double.toString(this.x_));
        }
        return buffer.toString();
    }

    public static IVector1 getVector1(Double val) {
        IVector1 ret = null;
        if (val != null) {
            ret = val == 0.0 ? ZERO : new Vector1Double(val);
        }
        return ret;
    }

    @Override
    public IVector2 createVector2(IVector1 sec) {
        return new Vector2Double(this.getAsDouble(), sec.getAsDouble());
    }

    @Override
    public IVector1 cbrt() {
        return null;
    }
}

