/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.math;

import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector2Double;
import java.math.BigDecimal;

public class Vector1Int
implements IVector1 {
    public static final IVector1 ZERO = new Vector1Int(0);
    private int x_;

    public Vector1Int(int value) {
        this.x_ = value;
    }

    public Vector1Int() {
    }

    @Override
    public IVector1 add(IVector1 vector) {
        this.x_ += vector.getAsInteger();
        return this;
    }

    @Override
    public IVector1 subtract(IVector1 vector) {
        this.x_ -= vector.getAsInteger();
        return this;
    }

    @Override
    public IVector1 multiply(IVector1 vector) {
        this.x_ *= vector.getAsInteger();
        return this;
    }

    @Override
    public IVector1 zero() {
        this.x_ = 0;
        return this;
    }

    @Override
    public IVector1 negate() {
        this.x_ = -this.x_;
        return this;
    }

    @Override
    public IVector1 sqrt() {
        this.x_ = (int)Math.sqrt(this.x_);
        return this;
    }

    @Override
    public IVector1 mod(IVector1 mod) {
        this.x_ %= mod.getAsInteger();
        return this;
    }

    @Override
    public IVector1 getDistance(IVector1 vector) {
        int distance = Math.abs(this.x_) - Math.abs(vector.getAsInteger());
        return new Vector1Int(distance);
    }

    @Override
    public int getAsInteger() {
        return this.x_;
    }

    public void setAsInteger(int x) {
        this.x_ = x;
    }

    @Override
    public long getAsLong() {
        return this.x_;
    }

    @Override
    public float getAsFloat() {
        return this.x_;
    }

    @Override
    public double getAsDouble() {
        return this.x_;
    }

    @Override
    public BigDecimal getAsBigDecimal() {
        return new BigDecimal(this.x_);
    }

    @Override
    public IVector1 copy() {
        return new Vector1Int(this.x_);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IVector1) {
            return this.equals((IVector1)obj);
        }
        return false;
    }

    public int hashCode() {
        return this.x_;
    }

    @Override
    public boolean equals(IVector1 vector) {
        return vector != null && this.x_ == vector.getAsInteger();
    }

    @Override
    public boolean greater(IVector1 vector) {
        return this.x_ > vector.getAsInteger();
    }

    @Override
    public boolean less(IVector1 vector) {
        return this.x_ < vector.getAsInteger();
    }

    @Override
    public IVector2 createVector2(IVector1 sec) {
        return new Vector2Double(this.getAsInteger(), sec.getAsInteger());
    }

    public String toString() {
        return Integer.toString(this.x_);
    }

    @Override
    public IVector1 cbrt() {
        return null;
    }
}

